/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.IInsertable;
import com.hbm.blocks.BlockContainerBase;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BufferUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PistonInserter
extends BlockContainerBase
implements ITooltipProvider {
    public PistonInserter() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPistonInserter();
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        this.updateState(world, x, y, z);
    }

    protected void updateState(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z));
            if (world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).func_149721_r()) {
                return;
            }
            boolean flag = this.checkRedstone(world, x, y, z);
            TileEntityPistonInserter piston = (TileEntityPistonInserter)world.func_147438_o(x, y, z);
            if (flag && !piston.lastState && piston.extend <= 0) {
                piston.isRetracting = false;
            }
            piston.lastState = flag;
        }
    }

    protected boolean checkRedstone(World world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!world.func_94574_k(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.ordinal())) continue;
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (side != world.func_72805_g(x, y, z)) {
            return false;
        }
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                TileEntityPistonInserter piston = (TileEntityPistonInserter)world.func_147438_o(x, y, z);
                if (piston.slot != null && piston.isRetracting) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)piston.func_145832_p());
                    EntityItem dust = new EntityItem(world, (double)x + 0.5 + (double)dir.offsetX * 0.75, (double)y + 0.5 + (double)dir.offsetY * 0.75, (double)z + 0.5 + (double)dir.offsetZ * 0.75, piston.slot);
                    piston.slot = null;
                    dust.field_70159_w = (double)dir.offsetX * 0.25;
                    dust.field_70181_x = (double)dir.offsetY * 0.25;
                    dust.field_70179_y = (double)dir.offsetZ * 0.25;
                    world.func_72838_d((Entity)dust);
                }
            }
            return true;
        }
        if (player.func_70694_bm() != null) {
            if (!world.field_72995_K) {
                TileEntityPistonInserter piston = (TileEntityPistonInserter)world.func_147438_o(x, y, z);
                if (piston.slot == null) {
                    piston.slot = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    player.field_71069_bz.func_75142_b();
                }
            }
            return true;
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int l = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        world.func_72921_c(x, y, z, l, 2);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        return meta != side.ordinal() && meta != side.getOpposite().ordinal();
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        IInventory tileentityfurnace = (IInventory)world.func_147438_o(x, y, z);
        if (tileentityfurnace != null) {
            ItemStack itemstack = tileentityfurnace.func_70301_a(0);
            if (itemstack != null) {
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = world.field_73012_v.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }

    public static class TileEntityPistonInserter
    extends TileEntityLoadedBase
    implements IInventory {
        public ItemStack slot;
        public int extend;
        public static final int maxExtend = 25;
        public boolean isRetracting = true;
        public int delay;
        private boolean lastState;
        @SideOnly(value=Side.CLIENT)
        public double renderExtend;
        @SideOnly(value=Side.CLIENT)
        public double lastExtend;
        @SideOnly(value=Side.CLIENT)
        private int syncExtend;
        @SideOnly(value=Side.CLIENT)
        private int turnProgress;
        @SideOnly(value=Side.CLIENT)
        private AxisAlignedBB aabb;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                if (this.delay <= 0) {
                    if (this.isRetracting && this.extend > 0) {
                        --this.extend;
                    } else if (!this.isRetracting) {
                        ++this.extend;
                        if (this.extend >= 25) {
                            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.pressOperate", 1.0f, 1.5f);
                            ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                            Block b = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX * 2, this.field_145848_d + dir.offsetY * 2, this.field_145849_e + dir.offsetZ * 2);
                            if (b instanceof IInsertable && ((IInsertable)b).insertItem(this.field_145850_b, this.field_145851_c + dir.offsetX * 2, this.field_145848_d + dir.offsetY * 2, this.field_145849_e + dir.offsetZ * 2, dir, this.slot)) {
                                this.func_70298_a(0, 1);
                            }
                            this.isRetracting = true;
                            this.delay = 5;
                        }
                    }
                } else {
                    --this.delay;
                }
                this.networkPackNT(25);
            } else {
                this.lastExtend = this.renderExtend;
                if (this.turnProgress > 0) {
                    this.renderExtend += ((double)this.syncExtend - this.renderExtend) / (double)this.turnProgress;
                    --this.turnProgress;
                } else {
                    this.renderExtend = this.syncExtend;
                }
            }
        }

        @Override
        public void serialize(ByteBuf buf) {
            buf.writeInt(this.extend);
            buf.writeBoolean(this.slot != null);
            if (this.slot != null) {
                BufferUtil.writeNBT(buf, this.slot.field_77990_d);
            }
            this.turnProgress = 2;
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.syncExtend = buf.readInt();
            if (buf.readBoolean()) {
                NBTTagCompound stack = BufferUtil.readNBT(buf);
                this.slot = ItemStack.func_77949_a((NBTTagCompound)stack);
            } else {
                this.slot = null;
            }
            this.turnProgress = 2;
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74768_a("extend", this.extend);
            nbt.func_74757_a("retract", this.isRetracting);
            nbt.func_74757_a("state", this.lastState);
            if (this.slot != null) {
                NBTTagCompound stack = new NBTTagCompound();
                this.slot.func_77955_b(stack);
                nbt.func_74782_a("stack", (NBTBase)stack);
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.extend = nbt.func_74762_e("extend");
            this.isRetracting = nbt.func_74767_n("retract");
            this.lastState = nbt.func_74767_n("state");
            if (nbt.func_74764_b("stack")) {
                NBTTagCompound stack = nbt.func_74775_l("stack");
                this.slot = ItemStack.func_77949_a((NBTTagCompound)stack);
            } else {
                this.slot = null;
            }
        }

        public AxisAlignedBB getRenderBoundingBox() {
            if (this.aabb != null) {
                return this.aabb;
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
            this.aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72321_a((double)dir.offsetX, (double)dir.offsetY, (double)dir.offsetZ);
            return this.aabb;
        }

        public int func_70302_i_() {
            return 1;
        }

        public ItemStack func_70301_a(int slot) {
            return this.slot;
        }

        public ItemStack func_70298_a(int slot, int amount) {
            if (this.slot != null) {
                if (this.slot.field_77994_a <= amount) {
                    ItemStack stack = this.slot;
                    this.slot = null;
                    return stack;
                }
                ItemStack stack = this.slot.func_77979_a(amount);
                if (this.slot.field_77994_a == 0) {
                    this.slot = null;
                }
                return stack;
            }
            return null;
        }

        public ItemStack func_70304_b(int slot) {
            return null;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.slot = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
        }

        public String func_145825_b() {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }
    }
}

