/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ITooltipProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RailGeneric
extends BlockRailBase
implements ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    protected IIcon turnedIcon;
    protected static final float baseSpeed = 0.4f;
    protected float maxSpeed = 0.4f;
    protected boolean slopable = true;
    protected boolean flexible = true;

    public RailGeneric() {
        super(false);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.flexible && meta >= 6 ? this.turnedIcon : this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        if (this.flexible) {
            this.turnedIcon = reg.func_94245_a(this.func_149641_N() + "_turned");
        }
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, int y, int x, int z) {
        return this.maxSpeed;
    }

    public RailGeneric setMaxSpeed(float speed) {
        this.maxSpeed = speed;
        return this;
    }

    public boolean isFlexibleRail(IBlockAccess world, int y, int x, int z) {
        return !this.func_150050_e();
    }

    public RailGeneric setFlexible(boolean flexible) {
        this.flexible = flexible;
        return this;
    }

    public boolean canMakeSlopes(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public RailGeneric setSlopable(boolean slopable) {
        this.slopable = slopable;
        return this;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        float speed = this.maxSpeed / 0.4f;
        if (speed != 1.0f) {
            list.add((speed > 1.0f ? EnumChatFormatting.BLUE : EnumChatFormatting.RED) + "Speed: " + (int)(speed * 100.0f) + "%");
        }
        if (!this.flexible) {
            list.add(EnumChatFormatting.RED + "Cannot be used for turns!");
        }
        if (!this.slopable) {
            list.add(EnumChatFormatting.RED + "Cannot be used for slopes!");
        }
    }
}

