/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ISpotlight;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.SpotlightBeam;
import com.hbm.main.ResourceManager;
import com.hbm.world.gen.INBTTransformable;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.minecraftforge.common.util.ForgeDirection;

public class Spotlight
extends Block
implements ISpotlight,
INBTTransformable {
    public static boolean disableOnGeneration = true;
    public boolean isOn;
    public int beamLength;
    public BlockEnums.LightType type;
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public Spotlight(Material mat, int beamLength, BlockEnums.LightType type, boolean isOn) {
        super(mat);
        this.beamLength = beamLength;
        this.type = type;
        this.isOn = isOn;
        this.func_149711_c(1.0f);
        if (isOn) {
            this.func_149715_a(1.0f);
        }
    }

    public int func_149645_b() {
        return renderID;
    }

    public WavefrontObject getModel() {
        switch (this.type) {
            case FLUORESCENT: {
                return (WavefrontObject)ResourceManager.fluorescent_lamp;
            }
            case HALOGEN: {
                return (WavefrontObject)ResourceManager.flood_lamp;
            }
        }
        return (WavefrontObject)ResourceManager.cage_lamp;
    }

    public String getPartName(int connectionCount) {
        switch (this.type) {
            case HALOGEN: {
                return "FloodLamp";
            }
        }
        return "CageLamp";
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        ForgeDirection dir = this.getDirection(world, x, y, z);
        float[] bounds = this.swizzleBounds(dir);
        float[] offset = new float[]{0.5f - (float)dir.offsetX * (0.5f - bounds[0]), 0.5f - (float)dir.offsetY * (0.5f - bounds[1]), 0.5f - (float)dir.offsetZ * (0.5f - bounds[2])};
        this.func_149676_a(offset[0] - bounds[0], offset[1] - bounds[1], offset[2] - bounds[2], offset[0] + bounds[0], offset[1] + bounds[1], offset[2] + bounds[2]);
    }

    private float[] swizzleBounds(ForgeDirection dir) {
        float[] bounds = this.getBounds();
        switch (dir) {
            case EAST: 
            case WEST: {
                return new float[]{bounds[2], bounds[1], bounds[0]};
            }
            case UP: 
            case DOWN: {
                return new float[]{bounds[1], bounds[2], bounds[0]};
            }
        }
        return bounds;
    }

    private float[] getBounds() {
        switch (this.type) {
            case FLUORESCENT: {
                return new float[]{0.5f, 0.5f, 0.1f};
            }
            case HALOGEN: {
                return new float[]{0.35f, 0.25f, 0.2f};
            }
        }
        return new float[]{0.25f, 0.2f, 0.15f};
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hx, float hy, float hz, int initData) {
        return side << 1;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        if (this.updatePower(world, x, y, z)) {
            return;
        }
        this.updateBeam(world, x, y, z);
    }

    private boolean updatePower(World world, int x, int y, int z) {
        if (this.isBroken(world.func_72805_g(x, y, z))) {
            return false;
        }
        boolean isPowered = world.func_72864_z(x, y, z);
        if (this.isOn && isPowered) {
            world.func_147464_a(x, y, z, (Block)this, 4);
            return true;
        }
        if (!this.isOn && !isPowered) {
            world.func_147465_d(x, y, z, this.getOn(), world.func_72805_g(x, y, z), 2);
            return true;
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        ForgeDirection dir = this.getDirection(metadata);
        super.func_149749_a(world, x, y, z, block, metadata);
        if (world.field_72995_K) {
            return;
        }
        Spotlight.unpropagateBeam(world, x, y, z, dir);
    }

    public void func_149674_a(World world, int x, int y, int z, Random p_149674_5_) {
        if (world.field_72995_K) {
            return;
        }
        if (this.isOn && world.func_72864_z(x, y, z)) {
            world.func_147465_d(x, y, z, this.getOff(), world.func_72805_g(x, y, z), 2);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        if (world.field_72995_K) {
            return;
        }
        if (neighborBlock instanceof SpotlightBeam) {
            return;
        }
        if (neighborBlock == Blocks.field_150350_a) {
            return;
        }
        ForgeDirection dir = this.getDirection((IBlockAccess)world, x, y, z);
        if (!this.canPlace(world, x, y, z, dir)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
            return;
        }
        if (this.updatePower(world, x, y, z)) {
            return;
        }
        this.updateBeam(world, x, y, z);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (!super.func_149707_d(world, x, y, z, side)) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return this.canPlace(world, x, y, z, dir);
    }

    private boolean canPlace(World world, int x, int y, int z, ForgeDirection dir) {
        Block block = world.func_147439_a(x -= dir.offsetX, y -= dir.offsetY, z -= dir.offsetZ);
        if (block instanceof BlockSlab) {
            int meta = world.func_72805_g(x, y, z);
            return dir == ((meta & 8) == 8 ? ForgeDirection.UP : ForgeDirection.DOWN) || block.func_149730_j();
        }
        return block.isSideSolid((IBlockAccess)world, x, y, z, dir);
    }

    private void updateBeam(World world, int x, int y, int z) {
        if (!this.isOn) {
            return;
        }
        ForgeDirection dir = this.getDirection((IBlockAccess)world, x, y, z);
        Spotlight.propagateBeam(world, x, y, z, dir, this.beamLength);
    }

    public ForgeDirection getDirection(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        return this.getDirection(metadata);
    }

    public ForgeDirection getDirection(int metadata) {
        return ForgeDirection.getOrientation((int)(metadata >> 1));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta = world.func_72805_g(x, y, z);
        if (!this.isBroken(meta)) {
            return false;
        }
        this.repair(world, x, y, z);
        return true;
    }

    private void repair(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (!this.isBroken(meta)) {
            return;
        }
        world.func_147465_d(x, y, z, this.getOn(), meta - 1, 2);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int ox = x + dir.offsetX;
            int oy = y + dir.offsetY;
            int oz = z + dir.offsetZ;
            Block block = world.func_147439_a(ox, oy, oz);
            if (block != this) continue;
            this.repair(world, ox, oy, oz);
        }
    }

    public boolean isBroken(int metadata) {
        return (metadata & 1) == 1;
    }

    public Item func_149650_a(int i, Random r, int j) {
        return Item.func_150898_a((Block)this.getOn());
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this.getOn());
    }

    protected ItemStack func_149644_j(int e) {
        return new ItemStack(this.getOn());
    }

    public static void propagateBeam(World world, int x, int y, int z, ForgeDirection dir, int distance) {
        if (--distance <= 0) {
            return;
        }
        Block block = world.func_147439_a(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ);
        if (!block.isAir((IBlockAccess)world, x, y, z)) {
            return;
        }
        if (!(block instanceof SpotlightBeam)) {
            world.func_147449_b(x, y, z, ModBlocks.spotlight_beam);
        }
        if (SpotlightBeam.setDirection(world, x, y, z, dir, true) == 0) {
            return;
        }
        Spotlight.propagateBeam(world, x, y, z, dir, distance);
    }

    public static void unpropagateBeam(World world, int x, int y, int z, ForgeDirection dir) {
        Block block = world.func_147439_a(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ);
        if (!(block instanceof SpotlightBeam)) {
            return;
        }
        if (SpotlightBeam.setDirection(world, x, y, z, dir, false) == 0) {
            world.func_147468_f(x, y, z);
        }
        Spotlight.unpropagateBeam(world, x, y, z, dir);
    }

    public static void backPropagate(World world, int x, int y, int z, ForgeDirection dir) {
        Block block = world.func_147439_a(x -= dir.offsetX, y -= dir.offsetY, z -= dir.offsetZ);
        if (block instanceof ISpotlight) {
            ISpotlight spot = (ISpotlight)block;
            Spotlight.propagateBeam(world, x, y, z, dir, spot.getBeamLength());
        } else if (!(block instanceof SpotlightBeam)) {
            return;
        }
        Spotlight.backPropagate(world, x, y, z, dir);
    }

    protected Block getOff() {
        if (this == ModBlocks.spotlight_incandescent) {
            return ModBlocks.spotlight_incandescent_off;
        }
        if (this == ModBlocks.spotlight_fluoro) {
            return ModBlocks.spotlight_fluoro_off;
        }
        if (this == ModBlocks.spotlight_halogen) {
            return ModBlocks.spotlight_halogen_off;
        }
        return this;
    }

    protected Block getOn() {
        if (this == ModBlocks.spotlight_incandescent_off) {
            return ModBlocks.spotlight_incandescent;
        }
        if (this == ModBlocks.spotlight_fluoro_off) {
            return ModBlocks.spotlight_fluoro;
        }
        if (this == ModBlocks.spotlight_halogen_off) {
            return ModBlocks.spotlight_halogen;
        }
        return this;
    }

    @Override
    public int getBeamLength() {
        return this.beamLength;
    }

    @Override
    public int transformMeta(int meta, int coordBaseMode) {
        int disabled = disableOnGeneration ? 1 : 0;
        return (INBTTransformable.transformMetaDeco(meta >> 1, coordBaseMode) << 1) + disabled;
    }

    @Override
    public Block transformBlock(Block block) {
        if (!disableOnGeneration) {
            return block;
        }
        if (block == ModBlocks.spotlight_incandescent) {
            return ModBlocks.spotlight_incandescent_off;
        }
        if (block == ModBlocks.spotlight_fluoro) {
            return ModBlocks.spotlight_fluoro_off;
        }
        if (block == ModBlocks.spotlight_halogen) {
            return ModBlocks.spotlight_halogen_off;
        }
        return block;
    }
}

