/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.conveyor.IConveyorBelt;
import api.hbm.conveyor.IConveyorItem;
import api.hbm.conveyor.IConveyorPackage;
import api.hbm.conveyor.IEnterableBlock;
import com.hbm.blocks.IBlockMultiPass;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.main.MainRegistry;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.render.block.RenderBlockMultipass;
import com.hbm.tileentity.network.TileEntityCraneRouter;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CraneRouter
extends BlockContainer
implements IBlockMultiPass,
IEnterableBlock,
ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconOverlay;

    public CraneRouter() {
        super(Material.field_151573_f);
        this.func_149658_d("hbm:crane_in");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCraneRouter();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconOverlay = iconRegister.func_94245_a("hbm:crane_router_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return RenderBlockMultipass.currentPass == 0 ? this.field_149761_L : this.iconOverlay;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (RenderBlockMultipass.currentPass == 0) {
            return 0xFFFFFF;
        }
        switch (RenderBlockMultipass.currentPass - 1) {
            case 0: {
                return 0xFF0000;
            }
            case 1: {
                return 0xFF8000;
            }
            case 2: {
                return 0xFFFF00;
            }
            case 3: {
                return 65280;
            }
            case 4: {
                return 33023;
            }
            case 5: {
                return 0x8000FF;
            }
        }
        return 0xFFFFFF;
    }

    public int func_149645_b() {
        return IBlockMultiPass.getRenderType();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (RenderBlockMultipass.currentPass == 0) {
            return true;
        }
        return side == RenderBlockMultipass.currentPass - 1;
    }

    @Override
    public int getPasses() {
        return 7;
    }

    @Override
    public boolean canItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
        return true;
    }

    @Override
    public void onItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
        int side;
        TileEntityCraneRouter router = (TileEntityCraneRouter)world.func_147438_o(x, y, z);
        ItemStack stack = entity.getItemStack();
        ArrayList<ForgeDirection> validDirs = new ArrayList<ForgeDirection>();
        for (side = 0; side < 6; ++side) {
            ModulePatternMatcher matcher = router.patterns[side];
            int mode = router.modes[side];
            if (mode == 0) continue;
            if (mode == 3) continue;
            boolean matchesFilter = false;
            for (int slot = 0; slot < 5; ++slot) {
                ItemStack filter = router.slots[side * 5 + slot];
                if (filter == null || !matcher.isValidForFilter(filter, slot, stack)) continue;
                matchesFilter = true;
                break;
            }
            if (mode != 1 || !matchesFilter) {
                if (mode != 2 || matchesFilter) continue;
            }
            validDirs.add(ForgeDirection.getOrientation((int)side));
        }
        if (validDirs.isEmpty()) {
            for (side = 0; side < 6; ++side) {
                if (router.modes[side] != 3) continue;
                validDirs.add(ForgeDirection.getOrientation((int)side));
            }
        }
        if (validDirs.isEmpty()) {
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack.func_77946_l()));
            return;
        }
        int i = world.field_73012_v.nextInt(validDirs.size());
        this.sendOnRoute(world, x, y, z, entity, (ForgeDirection)validDirs.get(i));
    }

    protected void sendOnRoute(World world, int x, int y, int z, IConveyorItem item, ForgeDirection dir) {
        IConveyorBelt belt = null;
        Block block = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if (block instanceof IConveyorBelt) {
            belt = (IConveyorBelt)block;
        }
        if (belt != null) {
            EntityMovingItem moving = new EntityMovingItem(world);
            Vec3 pos = Vec3.func_72443_a((double)((double)x + 0.5 + (double)dir.offsetX * 0.55), (double)((double)y + 0.5 + (double)dir.offsetY * 0.55), (double)((double)z + 0.5 + (double)dir.offsetZ * 0.55));
            Vec3 snap = belt.getClosestSnappingPosition(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, pos);
            moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
            moving.setItemStack(item.getItemStack());
            world.func_72838_d((Entity)moving);
        } else {
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5 + (double)dir.offsetX * 0.55, (double)y + 0.5 + (double)dir.offsetY * 0.55, (double)z + 0.5 + (double)dir.offsetZ * 0.55, item.getItemStack()));
        }
    }

    @Override
    public boolean canPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
        return false;
    }

    @Override
    public void onPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

