/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import api.hbm.entity.IRadarDetectable;
import api.hbm.entity.IRadarDetectableNT;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.entity.missile.EntityMissileStealth;
import com.hbm.entity.projectile.EntityThrowableInterp;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityMachineRadarNT;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityMissileAntiBallistic
extends EntityThrowableInterp
implements IChunkLoader,
IRadarDetectable,
IRadarDetectableNT {
    private ForgeChunkManager.Ticket loaderTicket;
    public Entity tracking;
    public double velocity;
    protected int activationTimer;
    public static double baseSpeed = 1.5;
    List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();

    public EntityMissileAntiBallistic(World world) {
        super(world);
        this.func_70105_a(1.5f, 1.5f);
        this.field_70181_x = baseSpeed;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
    }

    @Override
    protected double motionMult() {
        return this.velocity;
    }

    @Override
    public boolean doesImpactEntities() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.velocity < 6.0) {
                this.velocity += 0.1;
            }
            if (this.activationTimer < 40) {
                ++this.activationTimer;
                this.field_70181_x = baseSpeed;
            } else {
                Entity prevTracking = this.tracking;
                if (this.tracking == null || this.tracking.field_70128_L) {
                    this.targetMissile();
                }
                if (prevTracking == null && this.tracking != null) {
                    ExplosionLarge.spawnShock(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 24, 3.0);
                }
                if (this.tracking != null && !this.tracking.field_70128_L) {
                    this.aimAtTarget();
                } else if (this.field_70173_aa > 600) {
                    this.func_70106_y();
                }
            }
            this.loadNeighboringChunks((int)Math.floor(this.field_70165_t / 16.0), (int)Math.floor(this.field_70161_v / 16.0));
            if (this.field_70163_u > 2000.0 && (this.tracking == null || this.tracking.field_70128_L)) {
                this.func_70106_y();
            }
        } else {
            Vec3 vec = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72432_b();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "ABMContrail");
            data.func_74780_a("posX", this.field_70165_t - vec.field_72450_a);
            data.func_74780_a("posY", this.field_70163_u - vec.field_72448_b);
            data.func_74780_a("posZ", this.field_70161_v - vec.field_72449_c);
            MainRegistry.proxy.effectNT(data);
        }
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    protected void targetMissile() {
        Entity closest = null;
        double dist = 1000.0;
        for (Entity e : TileEntityMachineRadarNT.matchingEntities) {
            Vec3 vec;
            if (e.field_71093_bK != this.field_71093_bK || !(e instanceof EntityMissileBaseNT) || e instanceof EntityMissileStealth || !((vec = Vec3.func_72443_a((double)(e.field_70165_t - this.field_70165_t), (double)(e.field_70163_u - this.field_70163_u), (double)(e.field_70161_v - this.field_70161_v))).func_72433_c() < dist)) continue;
            closest = e;
        }
        this.tracking = closest;
    }

    protected void aimAtTarget() {
        Vec3 delta = Vec3.func_72443_a((double)(this.tracking.field_70165_t - this.field_70165_t), (double)(this.tracking.field_70163_u - this.field_70163_u), (double)(this.tracking.field_70161_v - this.field_70161_v));
        double intercept = delta.func_72433_c() / (baseSpeed * this.velocity);
        Vec3 predicted = Vec3.func_72443_a((double)(this.tracking.field_70165_t + (this.tracking.field_70165_t - this.tracking.field_70142_S) * intercept), (double)(this.tracking.field_70163_u + (this.tracking.field_70163_u - this.tracking.field_70137_T) * intercept), (double)(this.tracking.field_70161_v + (this.tracking.field_70161_v - this.tracking.field_70136_U) * intercept));
        Vec3 motion = Vec3.func_72443_a((double)(predicted.field_72450_a - this.field_70165_t), (double)(predicted.field_72448_b - this.field_70163_u), (double)(predicted.field_72449_c - this.field_70161_v)).func_72432_b();
        if (delta.func_72433_c() < 10.0 && this.activationTimer >= 40) {
            this.func_70106_y();
            ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15.0f, true, false, false);
        }
        this.field_70159_w = motion.field_72450_a * baseSpeed;
        this.field_70181_x = motion.field_72448_b * baseSpeed;
        this.field_70179_y = motion.field_72449_c * baseSpeed;
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        if (this.activationTimer >= 40) {
            this.func_70106_y();
            ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0f, true, false, false);
        }
    }

    @Override
    public double getGravityVelocity() {
        return 0.0;
    }

    @Override
    protected float getAirDrag() {
        return 1.0f;
    }

    @Override
    protected float getWaterDrag() {
        return 1.0f;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.velocity = nbt.func_74769_h("veloc");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74780_a("veloc", this.velocity);
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            this.clearChunkLoader();
            this.loadedChunks.clear();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + i, newChunkZ + j));
                }
            }
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.clearChunkLoader();
    }

    public void clearChunkLoader() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @Override
    public IRadarDetectable.RadarTargetType getTargetType() {
        return IRadarDetectable.RadarTargetType.MISSILE_AB;
    }

    @Override
    public String getUnlocalizedName() {
        return "radar.target.abm";
    }

    @Override
    public int getBlipLevel() {
        return 10;
    }

    @Override
    public boolean canBeSeenBy(Object radar) {
        return true;
    }

    @Override
    public boolean paramsApplicable(IRadarDetectableNT.RadarScanParams params) {
        return params.scanMissiles;
    }

    @Override
    public boolean suppliesRedstone(IRadarDetectableNT.RadarScanParams params) {
        return false;
    }
}

