/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import api.hbm.entity.IRadarDetectableNT;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.projectile.EntityThrowableInterp;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockMutatorFire;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCross;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.main.MainRegistry;
import com.hbm.util.TrackerUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public abstract class EntityMissileBaseNT
extends EntityThrowableInterp
implements IChunkLoader,
IRadarDetectableNT {
    public int startX;
    public int startZ;
    public int targetX;
    public int targetZ;
    public double velocity;
    public double decelY;
    public double accelXZ;
    public boolean isCluster = false;
    private ForgeChunkManager.Ticket loaderTicket;
    public int health = 50;
    List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();

    public EntityMissileBaseNT(World world) {
        super(world);
        this.field_70158_ak = true;
        this.startX = (int)this.field_70165_t;
        this.startZ = (int)this.field_70161_v;
        this.targetX = (int)this.field_70165_t;
        this.targetZ = (int)this.field_70161_v;
    }

    public EntityMissileBaseNT(World world, float x, float y, float z, int a, int b) {
        super(world);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.startX = (int)x;
        this.startZ = (int)z;
        this.targetX = a;
        this.targetZ = b;
        this.field_70181_x = 2.0;
        Vec3 vector = Vec3.func_72443_a((double)(this.targetX - this.startX), (double)0.0, (double)(this.targetZ - this.startZ));
        this.accelXZ = this.decelY = 1.0 / vector.func_72433_c();
        this.decelY *= 2.0;
        this.velocity = 0.0;
        this.field_70177_z = (float)(Math.atan2((double)this.targetX - this.field_70165_t, (double)this.targetZ - this.field_70161_v) * 180.0 / Math.PI);
        this.func_70105_a(1.5f, 1.5f);
    }

    public abstract ItemStack getMissileItemForInfo();

    @Override
    public boolean canBeSeenBy(Object radar) {
        return true;
    }

    @Override
    public boolean paramsApplicable(IRadarDetectableNT.RadarScanParams params) {
        return params.scanMissiles;
    }

    @Override
    public boolean suppliesRedstone(IRadarDetectableNT.RadarScanParams params) {
        return !params.smartMode || !(this.field_70181_x >= 0.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_75682_a(3, (Object)new Byte(5));
    }

    @Override
    protected double motionMult() {
        return this.velocity;
    }

    @Override
    public boolean doesImpactEntities() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.velocity < 4.0) {
            this.velocity += MathHelper.func_151237_a((double)((double)this.field_70173_aa / 60.0 * 0.05), (double)0.0, (double)0.05);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.hasPropulsion()) {
                this.field_70181_x -= this.decelY * this.velocity;
                Vec3 vector = Vec3.func_72443_a((double)(this.targetX - this.startX), (double)0.0, (double)(this.targetZ - this.startZ));
                vector = vector.func_72432_b();
                vector.field_72450_a *= this.accelXZ;
                vector.field_72449_c *= this.accelXZ;
                if (this.field_70181_x > 0.0) {
                    this.field_70159_w += vector.field_72450_a * this.velocity;
                    this.field_70179_y += vector.field_72449_c * this.velocity;
                }
                if (this.field_70181_x < 0.0) {
                    this.field_70159_w -= vector.field_72450_a * this.velocity;
                    this.field_70179_y -= vector.field_72449_c * this.velocity;
                }
            } else {
                this.field_70159_w *= 0.99;
                this.field_70179_y *= 0.99;
                if (this.field_70181_x > -1.5) {
                    this.field_70181_x -= 0.05;
                }
            }
            if (this.field_70181_x < -this.velocity && this.isCluster) {
                this.cluster();
                this.func_70106_y();
                return;
            }
            this.field_70177_z = (float)(Math.atan2((double)this.targetX - this.field_70165_t, (double)this.targetZ - this.field_70161_v) * 180.0 / Math.PI);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            EntityTrackerEntry tracker = TrackerUtil.getTrackerEntry((WorldServer)this.field_70170_p, this.func_145782_y());
            if (tracker != null) {
                tracker.field_73127_g += 100;
            }
            this.loadNeighboringChunks((int)Math.floor(this.field_70165_t / 16.0), (int)Math.floor(this.field_70161_v / 16.0));
        } else {
            this.spawnContrail();
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    public boolean hasPropulsion() {
        return true;
    }

    protected void spawnContrail() {
        this.spawnContraolWithOffset(0.0, 0.0, 0.0);
    }

    protected void spawnContraolWithOffset(double offsetX, double offsetY, double offsetZ) {
        Vec3 vec = Vec3.func_72443_a((double)(this.field_70142_S - this.field_70165_t), (double)(this.field_70137_T - this.field_70163_u), (double)(this.field_70136_U - this.field_70161_v));
        double len = vec.func_72433_c();
        vec = vec.func_72432_b();
        Vec3 thrust = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
        thrust.func_72446_c(this.field_70125_A * (float)Math.PI / 180.0f);
        thrust.func_72442_b((this.field_70177_z + 90.0f) * (float)Math.PI / 180.0f);
        int i = 0;
        while ((double)i < Math.max(Math.min(len, 10.0), 1.0)) {
            double j = (double)i - len;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74780_a("posX", this.field_70165_t - vec.field_72450_a * j + offsetX);
            data.func_74780_a("posY", this.field_70163_u - vec.field_72448_b * j + offsetY);
            data.func_74780_a("posZ", this.field_70161_v - vec.field_72449_c * j + offsetZ);
            data.func_74778_a("type", "missileContrail");
            data.func_74776_a("scale", this.getContrailScale());
            data.func_74780_a("moX", -thrust.field_72450_a);
            data.func_74780_a("moY", -thrust.field_72448_b);
            data.func_74780_a("moZ", -thrust.field_72449_c);
            data.func_74768_a("maxAge", 60 + this.field_70146_Z.nextInt(20));
            MainRegistry.proxy.effectNT(data);
            ++i;
        }
    }

    protected float getContrailScale() {
        return 1.0f;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70159_w = nbt.func_74769_h("moX");
        this.field_70181_x = nbt.func_74769_h("moY");
        this.field_70179_y = nbt.func_74769_h("moZ");
        this.field_70165_t = nbt.func_74769_h("poX");
        this.field_70163_u = nbt.func_74769_h("poY");
        this.field_70161_v = nbt.func_74769_h("poZ");
        this.decelY = nbt.func_74769_h("decel");
        this.accelXZ = nbt.func_74769_h("accel");
        this.targetX = nbt.func_74762_e("tX");
        this.targetZ = nbt.func_74762_e("tZ");
        this.startX = nbt.func_74762_e("sX");
        this.startZ = nbt.func_74762_e("sZ");
        this.velocity = nbt.func_74769_h("veloc");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74780_a("moX", this.field_70159_w);
        nbt.func_74780_a("moY", this.field_70181_x);
        nbt.func_74780_a("moZ", this.field_70179_y);
        nbt.func_74780_a("poX", this.field_70165_t);
        nbt.func_74780_a("poY", this.field_70163_u);
        nbt.func_74780_a("poZ", this.field_70161_v);
        nbt.func_74780_a("decel", this.decelY);
        nbt.func_74780_a("accel", this.accelXZ);
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tZ", this.targetZ);
        nbt.func_74768_a("sX", this.startX);
        nbt.func_74768_a("sZ", this.startZ);
        nbt.func_74780_a("veloc", this.velocity);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.health > 0 && !this.field_70170_p.field_72995_K) {
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                this.killMissile();
            }
        }
        return true;
    }

    protected void killMissile() {
        if (!this.field_70128_L) {
            this.func_70106_y();
            ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
            ExplosionLarge.spawnShrapnelShower(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 15, 0.075);
            ExplosionLarge.spawnMissileDebris(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.25, this.getDebris(), this.getDebrisRareDrop());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        if (mop != null) {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                this.onImpact();
                this.func_70106_y();
            }
        }
    }

    public abstract void onImpact();

    public abstract List<ItemStack> getDebris();

    public abstract ItemStack getDebrisRareDrop();

    public void cluster() {
    }

    @Override
    public double getGravityVelocity() {
        return 0.0;
    }

    @Override
    protected float getAirDrag() {
        return 1.0f;
    }

    @Override
    protected float getWaterDrag() {
        return 1.0f;
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            this.clearChunkLoader();
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ));
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.clearChunkLoader();
    }

    public void clearChunkLoader() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public void explodeStandard(float strength, int resolution, boolean fire) {
        ExplosionVNT xnt = new ExplosionVNT(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength);
        xnt.setBlockAllocator(new BlockAllocatorStandard(resolution));
        xnt.setBlockProcessor(new BlockProcessorStandard().setNoDrop().withBlockEffect(fire ? new BlockMutatorFire() : null));
        xnt.setEntityProcessor(new EntityProcessorCross(7.5).withRangeMod(2.0f));
        xnt.setPlayerProcessor(new PlayerProcessorStandard());
        xnt.explode();
    }

    @Override
    public String getUnlocalizedName() {
        ItemStack item = this.getMissileItemForInfo();
        if (item != null && item.func_77973_b() instanceof ItemMissile) {
            ItemMissile missile = (ItemMissile)item.func_77973_b();
            switch (missile.tier) {
                case TIER0: {
                    return "radar.target.tier0";
                }
                case TIER1: {
                    return "radar.target.tier1";
                }
                case TIER2: {
                    return "radar.target.tier2";
                }
                case TIER3: {
                    return "radar.target.tier3";
                }
                case TIER4: {
                    return "radar.target.tier4";
                }
            }
            return "Unknown";
        }
        return "Unknown";
    }

    @Override
    public int getBlipLevel() {
        ItemStack item = this.getMissileItemForInfo();
        if (item != null && item.func_77973_b() instanceof ItemMissile) {
            ItemMissile missile = (ItemMissile)item.func_77973_b();
            switch (missile.tier) {
                case TIER0: {
                    return 0;
                }
                case TIER1: {
                    return 1;
                }
                case TIER2: {
                    return 2;
                }
                case TIER3: {
                    return 3;
                }
                case TIER4: {
                    return 4;
                }
            }
            return 13;
        }
        return 13;
    }
}

