/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.MissileStruct;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomMissilePart;
import com.hbm.main.MainRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityMissileCustom
extends EntityMissileBaseNT
implements IChunkLoader {
    public float fuel;
    public float consumption;

    public EntityMissileCustom(World world) {
        super(world);
    }

    public EntityMissileCustom(World world, float x, float y, float z, int a, int b, MissileStruct template) {
        super(world);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.startX = (int)x;
        this.startZ = (int)z;
        this.targetX = a;
        this.targetZ = b;
        this.field_70181_x = 2.0;
        Vec3 vector = Vec3.func_72443_a((double)(this.targetX - this.startX), (double)0.0, (double)(this.targetZ - this.startZ));
        this.accelXZ = this.decelY = 1.0 / vector.func_72433_c();
        this.decelY *= 2.0;
        this.velocity = 0.0;
        this.field_70180_af.func_75692_b(9, (Object)Item.func_150891_b((Item)template.warhead));
        this.field_70180_af.func_75692_b(10, (Object)Item.func_150891_b((Item)template.fuselage));
        this.field_70180_af.func_75692_b(12, (Object)Item.func_150891_b((Item)template.thruster));
        if (template.fins != null) {
            this.field_70180_af.func_75692_b(11, (Object)Item.func_150891_b((Item)template.fins));
        } else {
            this.field_70180_af.func_75692_b(11, (Object)0);
        }
        ItemCustomMissilePart fuselage = template.fuselage;
        ItemCustomMissilePart thruster = template.thruster;
        this.fuel = ((Float)fuselage.attributes[1]).floatValue();
        this.consumption = ((Float)thruster.attributes[1]).floatValue();
        this.func_70105_a(1.5f, 1.5f);
    }

    @Override
    protected void killMissile() {
        if (!this.field_70128_L) {
            this.func_70106_y();
            ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
            ExplosionLarge.spawnShrapnelShower(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 15, 0.075);
        }
    }

    @Override
    public void func_70071_h_() {
        ItemCustomMissilePart part = (ItemCustomMissilePart)Item.func_150899_d((int)this.field_70180_af.func_75679_c(9));
        ItemCustomMissilePart.WarheadType type = (ItemCustomMissilePart.WarheadType)((Object)part.attributes[0]);
        if (type != null && type.updateCustom != null) {
            type.updateCustom.accept(this);
        }
        if (!this.field_70170_p.field_72995_K && this.hasPropulsion()) {
            this.fuel -= this.consumption;
        }
        super.func_70071_h_();
    }

    @Override
    public boolean hasPropulsion() {
        return this.fuel > 0.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(8, (Object)this.health);
        this.field_70180_af.func_75682_a(9, (Object)0);
        this.field_70180_af.func_75682_a(10, (Object)0);
        this.field_70180_af.func_75682_a(11, (Object)0);
        this.field_70180_af.func_75682_a(12, (Object)0);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.fuel = nbt.func_74760_g("fuel");
        this.consumption = nbt.func_74760_g("consumption");
        this.field_70180_af.func_75692_b(9, (Object)nbt.func_74762_e("warhead"));
        this.field_70180_af.func_75692_b(10, (Object)nbt.func_74762_e("fuselage"));
        this.field_70180_af.func_75692_b(11, (Object)nbt.func_74762_e("fins"));
        this.field_70180_af.func_75692_b(12, (Object)nbt.func_74762_e("thruster"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("fuel", this.fuel);
        nbt.func_74776_a("consumption", this.consumption);
        nbt.func_74768_a("warhead", this.field_70180_af.func_75679_c(9));
        nbt.func_74768_a("fuselage", this.field_70180_af.func_75679_c(10));
        nbt.func_74768_a("fins", this.field_70180_af.func_75679_c(11));
        nbt.func_74768_a("thruster", this.field_70180_af.func_75679_c(12));
    }

    @Override
    protected void spawnContrail() {
        Vec3 v = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72432_b();
        String smoke = "";
        ItemCustomMissilePart part = (ItemCustomMissilePart)Item.func_150899_d((int)this.field_70180_af.func_75679_c(10));
        ItemCustomMissilePart.FuelType type = (ItemCustomMissilePart.FuelType)((Object)part.attributes[0]);
        switch (type) {
            case BALEFIRE: {
                smoke = "exBalefire";
                break;
            }
            case HYDROGEN: {
                smoke = "exHydrogen";
                break;
            }
            case KEROSENE: {
                smoke = "exKerosene";
                break;
            }
            case SOLID: {
                smoke = "exSolid";
                break;
            }
        }
        if (!smoke.isEmpty()) {
            int i = 0;
            while ((double)i < this.velocity) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74780_a("posX", this.field_70165_t - v.field_72450_a * (double)i);
                data.func_74780_a("posY", this.field_70163_u - v.field_72448_b * (double)i);
                data.func_74780_a("posZ", this.field_70161_v - v.field_72449_c * (double)i);
                data.func_74778_a("type", smoke);
                MainRegistry.proxy.effectNT(data);
                ++i;
            }
        }
    }

    @Override
    public void onImpact() {
        ItemCustomMissilePart part = (ItemCustomMissilePart)Item.func_150899_d((int)this.field_70180_af.func_75679_c(9));
        ItemCustomMissilePart.WarheadType type = (ItemCustomMissilePart.WarheadType)((Object)part.attributes[0]);
        float strength = ((Float)part.attributes[1]).floatValue();
        if (type.impactCustom != null) {
            type.impactCustom.accept(this);
            return;
        }
        switch (type) {
            case HE: {
                ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true, false, true);
                ExplosionLarge.jolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, (int)(strength * 50.0f), 0.25);
                break;
            }
            case INC: {
                ExplosionLarge.explodeFire(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true, false, true);
                ExplosionLarge.jolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)strength * 1.5, (int)(strength * 50.0f), 0.25);
                break;
            }
            case CLUSTER: {
                break;
            }
            case BUSTER: {
                ExplosionLarge.buster(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y), strength, strength * 4.0f);
                break;
            }
            case NUCLEAR: 
            case TX: {
                this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(this.field_70170_p, (int)strength, this.field_70165_t, this.field_70163_u, this.field_70161_v));
                EntityNukeTorex.statFac(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength);
                break;
            }
            case BALEFIRE: {
                EntityBalefire bf = new EntityBalefire(this.field_70170_p);
                bf.field_70165_t = this.field_70165_t;
                bf.field_70163_u = this.field_70163_u;
                bf.field_70161_v = this.field_70161_v;
                bf.destructionRange = (int)strength;
                this.field_70170_p.func_72838_d((Entity)bf);
                EntityNukeTorex.statFacBale(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength);
                break;
            }
            case N2: {
                this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK5.statFacNoRad(this.field_70170_p, (int)strength, this.field_70165_t, this.field_70163_u, this.field_70161_v));
                EntityNukeTorex.statFac(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength);
                break;
            }
            case TAINT: {
                int r = (int)strength;
                for (int i = 0; i < r * 10; ++i) {
                    int c;
                    int b;
                    int a = this.field_70146_Z.nextInt(r) + (int)this.field_70165_t - (r / 2 - 1);
                    Block block = this.field_70170_p.func_147439_a(a, b = this.field_70146_Z.nextInt(r) + (int)this.field_70163_u - (r / 2 - 1), c = this.field_70146_Z.nextInt(r) + (int)this.field_70161_v - (r / 2 - 1));
                    if (!block.func_149721_r() || block.isAir((IBlockAccess)this.field_70170_p, a, b, c)) continue;
                    this.field_70170_p.func_147465_d(a, b, c, ModBlocks.taint, this.field_70146_Z.nextInt(3) + 4, 2);
                }
                break;
            }
            case CLOUD: {
                this.field_70170_p.func_72926_e(2002, (int)Math.round(this.field_70165_t), (int)Math.round(this.field_70163_u), (int)Math.round(this.field_70161_v), 0);
                ExplosionChaos.spawnChlorine(this.field_70170_p, this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x, this.field_70161_v - this.field_70179_y, 750, 2.5, 2);
                break;
            }
            case TURBINE: {
                ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10.0f, true, false, true);
                int count = (int)strength;
                Vec3 vec = Vec3.func_72443_a((double)0.5, (double)0.0, (double)0.0);
                for (int i = 0; i < count; ++i) {
                    EntityBulletBaseNT blade = new EntityBulletBaseNT(this.field_70170_p, BulletConfigSyncingUtil.TURBINE);
                    blade.func_70080_a(this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x + this.field_70146_Z.nextGaussian(), this.field_70161_v - this.field_70179_y, 0.0f, 0.0f);
                    blade.field_70159_w = vec.field_72450_a;
                    blade.field_70179_y = vec.field_72449_c;
                    this.field_70170_p.func_72838_d((Entity)blade);
                    vec.func_72442_b((float)(Math.PI * 2 / (double)count));
                }
                break;
            }
        }
    }

    @Override
    public String getUnlocalizedName() {
        ItemCustomMissilePart part = (ItemCustomMissilePart)Item.func_150899_d((int)this.field_70180_af.func_75679_c(10));
        ItemCustomMissilePart.PartSize top = part.top;
        ItemCustomMissilePart.PartSize bottom = part.bottom;
        if (top == ItemCustomMissilePart.PartSize.SIZE_10 && bottom == ItemCustomMissilePart.PartSize.SIZE_10) {
            return "radar.target.custom10";
        }
        if (top == ItemCustomMissilePart.PartSize.SIZE_10 && bottom == ItemCustomMissilePart.PartSize.SIZE_15) {
            return "radar.target.custom1015";
        }
        if (top == ItemCustomMissilePart.PartSize.SIZE_15 && bottom == ItemCustomMissilePart.PartSize.SIZE_15) {
            return "radar.target.custom15";
        }
        if (top == ItemCustomMissilePart.PartSize.SIZE_15 && bottom == ItemCustomMissilePart.PartSize.SIZE_20) {
            return "radar.target.custom1520";
        }
        if (top == ItemCustomMissilePart.PartSize.SIZE_20 && bottom == ItemCustomMissilePart.PartSize.SIZE_20) {
            return "radar.target.custom20";
        }
        return "radar.target.custom";
    }

    @Override
    public int getBlipLevel() {
        ItemCustomMissilePart part = (ItemCustomMissilePart)Item.func_150899_d((int)this.field_70180_af.func_75679_c(10));
        ItemCustomMissilePart.PartSize top = part.top;
        ItemCustomMissilePart.PartSize bottom = part.bottom;
        if (top == ItemCustomMissilePart.PartSize.SIZE_10 && bottom == ItemCustomMissilePart.PartSize.SIZE_10) {
            return 5;
        }
        if (top == ItemCustomMissilePart.PartSize.SIZE_10 && bottom == ItemCustomMissilePart.PartSize.SIZE_15) {
            return 6;
        }
        if (top == ItemCustomMissilePart.PartSize.SIZE_15 && bottom == ItemCustomMissilePart.PartSize.SIZE_15) {
            return 7;
        }
        if (top == ItemCustomMissilePart.PartSize.SIZE_15 && bottom == ItemCustomMissilePart.PartSize.SIZE_20) {
            return 8;
        }
        if (top == ItemCustomMissilePart.PartSize.SIZE_20 && bottom == ItemCustomMissilePart.PartSize.SIZE_20) {
            return 9;
        }
        return 1;
    }

    @Override
    public List<ItemStack> getDebris() {
        return new ArrayList<ItemStack>();
    }

    @Override
    public ItemStack getDebrisRareDrop() {
        return null;
    }

    @Override
    public ItemStack getMissileItemForInfo() {
        return new ItemStack(ModItems.missile_custom);
    }
}

