/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.items.ModItems;
import com.hbm.particle.helper.ExplosionCreator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class EntityMissileTier1
extends EntityMissileBaseNT {
    public EntityMissileTier1(World world) {
        super(world);
    }

    public EntityMissileTier1(World world, float x, float y, float z, int a, int b) {
        super(world, x, y, z, a, b);
    }

    @Override
    public List<ItemStack> getDebris() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(ModItems.plate_titanium, 4));
        list.add(new ItemStack(ModItems.thruster_small, 1));
        return list;
    }

    @Override
    protected float getContrailScale() {
        return 0.5f;
    }

    public static class EntityMissileBunkerBuster
    extends EntityMissileTier1 {
        public EntityMissileBunkerBuster(World world) {
            super(world);
        }

        public EntityMissileBunkerBuster(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u - (double)i, this.field_70161_v, 5.0f, true);
            }
            ExplosionLarge.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5);
            ExplosionLarge.spawnShrapnels(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5);
            ExplosionLarge.spawnRubble(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_buster_small);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_buster);
        }
    }

    public static class EntityMissileCluster
    extends EntityMissileTier1 {
        public EntityMissileCluster(World world) {
            super(world);
        }

        public EntityMissileCluster(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
            this.isCluster = true;
        }

        @Override
        public void onImpact() {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
            ExplosionChaos.cluster(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 25, 100);
        }

        @Override
        public void cluster() {
            this.onImpact();
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_cluster_small);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_cluster);
        }
    }

    public static class EntityMissileIncendiary
    extends EntityMissileTier1 {
        public EntityMissileIncendiary(World world) {
            super(world);
        }

        public EntityMissileIncendiary(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            this.explodeStandard(15.0f, 24, true);
            ExplosionCreator.composeEffectSmall(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_incendiary_small);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_incendiary);
        }
    }

    public static class EntityMissileDecoy
    extends EntityMissileTier1 {
        public EntityMissileDecoy(World world) {
            super(world);
        }

        public EntityMissileDecoy(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 4.0f, false, false);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.ingot_steel);
        }

        @Override
        public String getUnlocalizedName() {
            return "radar.target.tier4";
        }

        @Override
        public int getBlipLevel() {
            return 4;
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_decoy);
        }
    }

    public static class EntityMissileGeneric
    extends EntityMissileTier1 {
        public EntityMissileGeneric(World world) {
            super(world);
        }

        public EntityMissileGeneric(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            this.explodeStandard(15.0f, 24, false);
            ExplosionCreator.composeEffectSmall(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_generic_small);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_generic);
        }
    }
}

