/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import com.hbm.entity.logic.EntityEMP;
import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.items.ModItems;
import com.hbm.particle.helper.ExplosionCreator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class EntityMissileTier2
extends EntityMissileBaseNT {
    public EntityMissileTier2(World world) {
        super(world);
    }

    public EntityMissileTier2(World world, float x, float y, float z, int a, int b) {
        super(world, x, y, z, a, b);
    }

    @Override
    public List<ItemStack> getDebris() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(ModItems.plate_steel, 10));
        list.add(new ItemStack(ModItems.plate_titanium, 6));
        list.add(new ItemStack(ModItems.thruster_medium, 1));
        return list;
    }

    @Override
    public String getUnlocalizedName() {
        return "radar.target.tier2";
    }

    @Override
    public int getBlipLevel() {
        return 2;
    }

    public static class EntityMissileEMPStrong
    extends EntityMissileTier2 {
        public EntityMissileEMPStrong(World world) {
            super(world);
        }

        public EntityMissileEMPStrong(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            EntityEMP emp = new EntityEMP(this.field_70170_p);
            emp.field_70165_t = this.field_70165_t;
            emp.field_70163_u = this.field_70163_u;
            emp.field_70161_v = this.field_70161_v;
            this.field_70170_p.func_72838_d((Entity)emp);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_generic_medium);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_emp_strong);
        }
    }

    public static class EntityMissileBusterStrong
    extends EntityMissileTier2 {
        public EntityMissileBusterStrong(World world) {
            super(world);
        }

        public EntityMissileBusterStrong(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u - (double)i, this.field_70161_v, 7.5f, true);
            }
            ExplosionLarge.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8);
            ExplosionLarge.spawnShrapnels(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8);
            ExplosionLarge.spawnRubble(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_buster_medium);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_buster_strong);
        }
    }

    public static class EntityMissileClusterStrong
    extends EntityMissileTier2 {
        public EntityMissileClusterStrong(World world) {
            super(world);
        }

        public EntityMissileClusterStrong(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
            this.isCluster = true;
        }

        @Override
        public void onImpact() {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15.0f, true);
            ExplosionChaos.cluster(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 50, 100);
        }

        @Override
        public void cluster() {
            this.onImpact();
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_cluster_medium);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_cluster_strong);
        }
    }

    public static class EntityMissileIncendiaryStrong
    extends EntityMissileTier2 {
        public EntityMissileIncendiaryStrong(World world) {
            super(world);
        }

        public EntityMissileIncendiaryStrong(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            this.explodeStandard(30.0f, 32, true);
            ExplosionCreator.composeEffectStandard(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            ExplosionChaos.flameDeath(this.field_70170_p, (int)((float)this.field_70165_t + 0.5f), (int)((float)this.field_70163_u + 0.5f), (int)((float)this.field_70161_v + 0.5f), 25);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_incendiary_medium);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_incendiary_strong);
        }
    }

    public static class EntityMissileStrong
    extends EntityMissileTier2 {
        public EntityMissileStrong(World world) {
            super(world);
        }

        public EntityMissileStrong(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            this.explodeStandard(30.0f, 32, false);
            ExplosionCreator.composeEffectStandard(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_generic_medium);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_strong);
        }
    }
}

