/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityMissileTier4
extends EntityMissileBaseNT {
    public EntityMissileTier4(World world) {
        super(world);
    }

    public EntityMissileTier4(World world, float x, float y, float z, int a, int b) {
        super(world, x, y, z, a, b);
    }

    @Override
    public List<ItemStack> getDebris() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(ModItems.plate_titanium, 16));
        list.add(new ItemStack(ModItems.plate_steel, 20));
        list.add(new ItemStack(ModItems.plate_aluminium, 12));
        list.add(new ItemStack(ModItems.thruster_large, 1));
        return list;
    }

    @Override
    public String getUnlocalizedName() {
        return "radar.target.tier4";
    }

    @Override
    public int getBlipLevel() {
        return 4;
    }

    @Override
    protected void spawnContrail() {
        byte rot = this.field_70180_af.func_75683_a(3);
        Vec3 thrust = Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0);
        switch (rot) {
            case 2: {
                thrust.func_72442_b(-1.5707964f);
                break;
            }
            case 4: {
                thrust.func_72442_b((float)(-Math.PI));
                break;
            }
            case 3: {
                thrust.func_72442_b(-4.712389f);
            }
        }
        thrust.func_72442_b((this.field_70177_z + 90.0f) * (float)Math.PI / 180.0f);
        thrust.func_72440_a(this.field_70125_A * (float)Math.PI / 180.0f);
        thrust.func_72442_b(-(this.field_70177_z + 90.0f) * (float)Math.PI / 180.0f);
        this.spawnContraolWithOffset(thrust.field_72450_a, thrust.field_72448_b, thrust.field_72449_c);
        this.spawnContraolWithOffset(0.0, 0.0, 0.0);
        this.spawnContraolWithOffset(-thrust.field_72450_a, -thrust.field_72449_c, -thrust.field_72449_c);
    }

    public static class EntityMissileDoomsdayRusted
    extends EntityMissileDoomsday {
        public EntityMissileDoomsdayRusted(World world) {
            super(world);
        }

        public EntityMissileDoomsdayRusted(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(this.field_70170_p, BombConfig.missileRadius, this.field_70165_t, this.field_70163_u, this.field_70161_v).moreFallout(100));
            EntityNukeTorex.statFac(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, BombConfig.missileRadius);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_doomsday_rusted);
        }
    }

    public static class EntityMissileDoomsday
    extends EntityMissileTier4 {
        public EntityMissileDoomsday(World world) {
            super(world);
        }

        public EntityMissileDoomsday(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(this.field_70170_p, BombConfig.missileRadius * 2, this.field_70165_t, this.field_70163_u, this.field_70161_v).moreFallout(100));
            EntityNukeTorex.statFac(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, BombConfig.missileRadius * 2);
        }

        @Override
        public List<ItemStack> getDebris() {
            return null;
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return null;
        }

        @Override
        public String getUnlocalizedName() {
            return "radar.target.doomsday";
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_doomsday);
        }
    }

    public static class EntityMissileVolcano
    extends EntityMissileTier4 {
        public EntityMissileVolcano(World world) {
            super(world);
        }

        public EntityMissileVolcano(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10.0f, true, true, true);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        this.field_70170_p.func_147449_b((int)Math.floor(this.field_70165_t + (double)x), (int)Math.floor(this.field_70163_u + (double)y), (int)Math.floor(this.field_70161_v + (double)z), ModBlocks.volcanic_lava_block);
                    }
                }
            }
            this.field_70170_p.func_147449_b((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), ModBlocks.volcano_core);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_volcano);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_volcano);
        }
    }

    public static class EntityMissileMirv
    extends EntityMissileTier4 {
        public EntityMissileMirv(World world) {
            super(world);
        }

        public EntityMissileMirv(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(this.field_70170_p, BombConfig.missileRadius * 2, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            EntityNukeTorex.statFac(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, BombConfig.missileRadius * 2);
        }

        @Override
        public List<ItemStack> getDebris() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack(ModItems.plate_titanium, 16));
            list.add(new ItemStack(ModItems.plate_steel, 20));
            list.add(new ItemStack(ModItems.plate_aluminium, 12));
            list.add(new ItemStack(ModItems.thruster_large, 1));
            return list;
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_mirv);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_nuclear_cluster);
        }
    }

    public static class EntityMissileNuclear
    extends EntityMissileTier4 {
        public EntityMissileNuclear(World world) {
            super(world);
        }

        public EntityMissileNuclear(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onImpact() {
            this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(this.field_70170_p, BombConfig.missileRadius, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            EntityNukeTorex.statFac(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, BombConfig.missileRadius);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_nuclear);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_nuclear);
        }
    }
}

