/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.ai;

import com.hbm.handler.HbmKeybinds;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.Receiver;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;

public class EntityAIFireGun
extends EntityAIBase {
    private final EntityLiving host;
    private double attackMoveSpeed = 1.0;
    private double maxRange = 20.0;
    private int burstTime = 10;
    private int minWait = 10;
    private int maxWait = 40;
    private float inaccuracy = 30.0f;
    private int attackTimer = 0;
    private FireState state = FireState.IDLE;
    private int stateTimer = 0;

    public EntityAIFireGun(EntityLiving host) {
        this.host = host;
    }

    public boolean func_75250_a() {
        return this.host.func_70638_az() != null && this.getYerGun() != null;
    }

    public void func_75246_d() {
        EntityLivingBase target = this.host.func_70638_az();
        ItemStack stack = this.host.func_70694_bm();
        ItemGunBaseNT gun = this.getYerGun();
        gun.func_77663_a(stack, this.host.field_70170_p, (Entity)this.host, 0, true);
        double distanceToTargetSquared = this.host.func_70092_e(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        boolean canSeeTarget = this.host.func_70635_at().func_75522_a((Entity)target);
        this.attackTimer = canSeeTarget ? ++this.attackTimer : 0;
        if (distanceToTargetSquared < this.maxRange * this.maxRange && this.attackTimer > 20) {
            this.host.func_70661_as().func_75499_g();
        } else {
            this.host.func_70661_as().func_75497_a((Entity)target, this.attackMoveSpeed);
        }
        this.host.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        --this.stateTimer;
        if (this.stateTimer < 0) {
            this.stateTimer = 0;
            if (this.state == FireState.WAIT) {
                this.updateState(FireState.IDLE, 0, gun, stack);
            } else if (this.state != FireState.IDLE) {
                this.updateState(FireState.WAIT, this.host.field_70170_p.field_73012_v.nextInt(this.maxWait - this.minWait) + this.minWait, gun, stack);
            }
        } else if (this.state == FireState.FIRING) {
            this.updateKeybind(gun, stack, HbmKeybinds.EnumKeybind.GUN_PRIMARY);
        }
        if (canSeeTarget && distanceToTargetSquared < this.maxRange * this.maxRange && this.state == FireState.IDLE) {
            GunConfig config = gun.getConfig(stack, 0);
            Receiver rec = config.getReceivers(stack)[0];
            if (rec.getMagazine(stack).getAmount(stack, null) <= 0) {
                this.updateState(FireState.RELOADING, 20, gun, stack);
            } else if (ItemGunBaseNT.getState(stack, 0) == ItemGunBaseNT.GunState.IDLE) {
                this.updateState(FireState.FIRING, this.host.field_70170_p.field_73012_v.nextInt(this.burstTime), gun, stack);
            }
        }
    }

    private void updateState(FireState toState, int time, ItemGunBaseNT gun, ItemStack stack) {
        this.state = toState;
        this.stateTimer = time;
        switch (this.state) {
            case FIRING: {
                this.updateKeybind(gun, stack, HbmKeybinds.EnumKeybind.GUN_PRIMARY);
            }
            case RELOADING: {
                this.updateKeybind(gun, stack, HbmKeybinds.EnumKeybind.RELOAD);
            }
        }
        this.clearKeybinds(gun, stack);
    }

    private void clearKeybinds(ItemGunBaseNT gun, ItemStack stack) {
        this.updateKeybind(gun, stack, null);
    }

    private void updateKeybind(ItemGunBaseNT gun, ItemStack stack, HbmKeybinds.EnumKeybind bind) {
        if (bind != null && bind != HbmKeybinds.EnumKeybind.RELOAD) {
            this.host.field_70759_as += (this.host.field_70170_p.field_73012_v.nextFloat() - 0.5f) * this.inaccuracy;
            this.host.field_70125_A += (this.host.field_70170_p.field_73012_v.nextFloat() - 0.5f) * this.inaccuracy;
            this.host.field_70177_z = this.host.field_70759_as;
        }
        gun.handleKeybind((EntityLivingBase)this.host, null, stack, HbmKeybinds.EnumKeybind.GUN_PRIMARY, bind == HbmKeybinds.EnumKeybind.GUN_PRIMARY);
        gun.handleKeybind((EntityLivingBase)this.host, null, stack, HbmKeybinds.EnumKeybind.GUN_SECONDARY, bind == HbmKeybinds.EnumKeybind.GUN_SECONDARY);
        gun.handleKeybind((EntityLivingBase)this.host, null, stack, HbmKeybinds.EnumKeybind.GUN_TERTIARY, bind == HbmKeybinds.EnumKeybind.GUN_TERTIARY);
        gun.handleKeybind((EntityLivingBase)this.host, null, stack, HbmKeybinds.EnumKeybind.RELOAD, bind == HbmKeybinds.EnumKeybind.RELOAD);
    }

    public ItemGunBaseNT getYerGun() {
        ItemStack stack = this.host.func_70694_bm();
        if (stack == null || !(stack.func_77973_b() instanceof ItemGunBaseNT)) {
            return null;
        }
        return (ItemGunBaseNT)stack.func_77973_b();
    }

    private static enum FireState {
        IDLE,
        WAIT,
        FIRING,
        RELOADING;

    }
}

