/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.botprime;

import com.hbm.entity.mob.botprime.EntityBurrowingNT;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class EntityWormBaseNT
extends EntityBurrowingNT {
    public int aggroCooldown = 0;
    public int courseChangeCooldown = 0;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    protected Entity targetedEntity = null;
    protected boolean canFly = false;
    protected int dmgCooldown = 0;
    protected boolean wasNearGround;
    protected ChunkCoordinates spawnPoint = new ChunkCoordinates();
    protected double attackRange;
    protected double maxSpeed;
    protected double fallSpeed;
    protected double rangeForParts;
    protected EntityLivingBase followed;
    protected int surfaceY;
    private int headID;
    private int partNum;
    protected boolean didCheck;
    protected double maxBodySpeed;
    protected double segmentDistance;
    protected double knockbackDivider;
    public static final IEntitySelector wormSelector = new IEntitySelector(){

        public boolean func_82704_a(Entity target) {
            return target instanceof EntityWormBaseNT;
        }
    };

    public EntityWormBaseNT(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.surfaceY = 60;
        this.field_70155_l = 15.0;
    }

    public int getPartNumber() {
        return this.partNum;
    }

    public void setPartNumber(int num) {
        this.partNum = num;
    }

    public Entity getHead() {
        return this.field_70170_p.func_73045_a(this.headID);
    }

    public int getHeadID() {
        return this.headID;
    }

    public void setHeadID(int id) {
        this.headID = id;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar() || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source.func_76346_g() instanceof EntityWormBaseNT && ((EntityWormBaseNT)source.func_76346_g()).getHeadID() == this.getHeadID()) {
            return false;
        }
        this.func_70018_K();
        if (this.getIsHead()) {
            return super.func_70097_a(source, amount);
        }
        Entity head = this.targetedEntity;
        if (head != null) {
            return head.func_70097_a(source, amount);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70626_be() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (this.field_70163_u < -10.0) {
            this.field_70181_x = 1.0;
        } else if (this.field_70163_u < 3.0) {
            this.field_70181_x = 0.3;
        }
        if (this.field_70173_aa % 5 == 0) {
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.5, 0.5, 0.5)));
        }
    }

    protected void attackEntitiesInList(List<Entity> targets) {
        for (Entity target : targets) {
            if (!(target instanceof EntityLivingBase) || !this.func_70686_a(target.getClass()) || target instanceof EntityWormBaseNT && ((EntityWormBaseNT)target).getHeadID() == this.getHeadID()) continue;
            this.func_70652_k(target);
        }
    }

    public boolean func_70686_a(Class clazz) {
        return true;
    }

    public boolean func_70652_k(Entity target) {
        boolean var2 = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.getAttackStrength(target));
        if (var2) {
            this.field_70708_bq = 0;
            double tx = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            double tz = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
            double ty = (this.field_70121_D.field_72338_b + this.field_70121_D.field_72337_e) / 2.0;
            double deltaX = target.field_70165_t - tx;
            double deltaZ = target.field_70161_v - tz;
            double deltaY = target.field_70163_u - ty;
            double knockback = this.knockbackDivider * (deltaX * deltaX + deltaZ * deltaZ + deltaY * deltaY + 0.1);
            target.func_70024_g(deltaX / knockback, deltaY / knockback, deltaZ / knockback);
        }
        return var2;
    }

    public abstract float getAttackStrength(Entity var1);

    public void func_70024_g(double x, double y, double z) {
    }

    public void func_70625_a(Entity entity, float yaw, float pitch) {
    }

    protected boolean isCourseTraversable() {
        return this.canFly || this.func_70094_T();
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    public void func_70106_y() {
        this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
        super.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("wormID", this.getHeadID());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setHeadID(nbt.func_74762_e("wormID"));
    }

    protected void updateMovement() {
        double targetingRange = 128.0;
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < targetingRange * targetingRange) {
            this.waypointX = this.targetedEntity.field_70165_t;
            this.waypointY = this.targetedEntity.field_70163_u;
            this.waypointZ = this.targetedEntity.field_70161_v;
        }
        if (!(this.field_70173_aa % 60 != 0 && this.field_70173_aa != 1 || this.targetedEntity != null && this.followed != null)) {
            this.findEntityToFollow(this.field_70170_p.func_82733_a(EntityLiving.class, this.field_70121_D.func_72314_b(this.rangeForParts, this.rangeForParts, this.rangeForParts), wormSelector));
        }
        double deltaX = this.waypointX - this.field_70165_t;
        double deltaY = this.waypointY - this.field_70163_u;
        double deltaZ = this.waypointZ - this.field_70161_v;
        double deltaDist = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        if (this.targetedEntity != null) {
            this.func_70625_a(this.targetedEntity, 180.0f, 180.0f);
        }
        double speed = Math.max(0.0, Math.min(deltaDist - this.segmentDistance, this.maxBodySpeed));
        if (deltaDist < this.segmentDistance * 0.895) {
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.8;
            this.field_70179_y *= 0.8;
        } else {
            this.field_70159_w = deltaX / deltaDist * speed;
            this.field_70181_x = deltaY / deltaDist * speed;
            this.field_70179_y = deltaZ / deltaDist * speed;
        }
    }

    protected void findEntityToFollow(List<EntityWormBaseNT> segments) {
        for (EntityWormBaseNT segment : segments) {
            if (segment.getHeadID() != this.getHeadID()) continue;
            if (segment.getIsHead()) {
                if (this.getPartNumber() == 0) {
                    this.targetedEntity = segment;
                }
                this.followed = segment;
                continue;
            }
            if (segment.getPartNumber() != this.getPartNumber() - 1) continue;
            this.targetedEntity = segment;
        }
        this.didCheck = true;
    }
}

