/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.glyphid;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.mob.glyphid.EntityGlyphid;
import com.hbm.entity.mob.glyphid.GlyphidStats;
import com.hbm.entity.projectile.EntityRubble;
import com.hbm.lib.Library;
import com.hbm.main.ResourceManager;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityGlyphidDigger
extends EntityGlyphid {
    protected Entity lastTarget;
    protected double lastX;
    protected double lastY;
    protected double lastZ;
    public int timer = 0;

    public EntityGlyphidDigger(World world) {
        super(world);
    }

    @Override
    public ResourceLocation getSkin() {
        return ResourceManager.glyphid_digger_tex;
    }

    @Override
    public double getScale() {
        return 1.3;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(GlyphidStats.getStats().getDigger().health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(GlyphidStats.getStats().getDigger().speed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(GlyphidStats.getStats().getDigger().damage);
    }

    @Override
    public GlyphidStats.StatBundle getStats() {
        return GlyphidStats.getStats().statsDigger;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Entity e = this.func_70777_m();
        if (e != null && this.func_70089_S()) {
            this.lastX = e.field_70165_t;
            this.lastY = e.field_70163_u;
            this.lastZ = e.field_70161_v;
            if (--this.timer <= 0) {
                this.groundSlam();
                this.timer = 120;
            }
        }
    }

    public void groundSlam() {
        if (!this.field_70170_p.field_72995_K && this.field_70789_a instanceof EntityLivingBase && this.func_70032_d(this.field_70789_a) < 30.0f) {
            int prediction;
            Vec3 delta;
            double len;
            Entity e = this.func_70777_m();
            boolean topAttack = false;
            int l = 6;
            float part = -0.0625f;
            int bugX = (int)this.field_70165_t;
            int bugY = (int)this.field_70163_u;
            int bugZ = (int)this.field_70161_v;
            Vec3 vec0 = this.func_70040_Z();
            List<int[]> list = Library.getBlockPosInPath(bugX, bugY, bugZ, l, vec0);
            for (int i = 0; i < 8; ++i) {
                vec0.func_72442_b(part);
                list.addAll(Library.getBlockPosInPath(bugX, bugY - 1, bugZ, l, vec0));
            }
            double velX = e.field_70165_t - this.lastX;
            double velY = e.field_70163_u - this.lastY;
            double velZ = e.field_70161_v - this.lastZ;
            if (this.lastTarget != e) {
                velZ = 0.0;
                velY = 0.0;
                velX = 0.0;
            }
            if (this.func_70032_d(e) > 20.0f) {
                topAttack = true;
            }
            if ((len = (delta = Vec3.func_72443_a((double)(e.field_70165_t - this.field_70165_t + velX * (double)(prediction = 60)), (double)(e.field_70163_u + (double)(e.field_70131_O / 2.0f) - (this.field_70163_u + 1.0) + velY * (double)prediction), (double)(e.field_70161_v - this.field_70161_v + velZ * (double)prediction))).func_72433_c()) < 3.0) {
                return;
            }
            double targetYaw = -Math.atan2(delta.field_72450_a, delta.field_72449_c);
            double x = Math.sqrt(delta.field_72450_a * delta.field_72450_a + delta.field_72449_c * delta.field_72449_c);
            double y = delta.field_72448_b;
            double v0 = 1.2;
            double v02 = v0 * v0;
            double g = 0.03;
            double upperLower = topAttack ? 1.0 : -1.0;
            double targetPitch = Math.atan((v02 + Math.sqrt(v02 * v02 - g * (g * x * x + 2.0 * y * v02)) * upperLower) / (g * x));
            Vec3 fireVec = null;
            if (!Double.isNaN(targetPitch)) {
                fireVec = Vec3.func_72443_a((double)v0, (double)0.0, (double)0.0);
                fireVec.func_72446_c((float)(-targetPitch));
                fireVec.func_72442_b((float)(-(targetYaw + 1.5707963267948966)));
            }
            for (int[] ints : list) {
                int z1;
                int y1;
                int x1 = ints[0];
                Block b = this.field_70170_p.func_147439_a(x1, y1 = ints[1], z1 = ints[2]);
                float k = b.getExplosionResistance((Entity)this, this.field_70170_p, x1, y1, z1, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (!(k < ModBlocks.concrete.func_149638_a((Entity)this)) || !b.func_149721_r() || b instanceof BlockDummyable || this.field_70170_p.func_147438_o(x1, y1, z1) != null) continue;
                EntityRubble rubble = new EntityRubble(this.field_70170_p);
                rubble.field_70165_t = (float)x1 + 0.5f;
                rubble.field_70163_u = y1 + 2;
                rubble.field_70161_v = (float)z1 + 0.5f;
                rubble.setMetaBasedOnBlock(b, this.field_70170_p.func_72805_g(x1, y1, z1));
                if (fireVec != null) {
                    rubble.func_70186_c(fireVec.field_72450_a, fireVec.field_72448_b, fireVec.field_72449_c, (float)v0, this.field_70146_Z.nextFloat());
                }
                this.field_70170_p.func_72838_d((Entity)rubble);
                this.field_70170_p.func_147449_b(x1, y1, z1, Blocks.field_150350_a);
            }
        }
    }

    @Override
    public boolean isArmorBroken(float amount) {
        return (double)this.field_70146_Z.nextInt(100) <= Math.min(Math.pow((double)amount * 0.25, 2.0), 100.0);
    }

    @Override
    protected boolean canDig() {
        return true;
    }
}

