/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import api.hbm.entity.IRadarDetectable;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.projectile.EntityThrowableNT;
import com.hbm.items.weapon.ItemAmmoArty;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityArtilleryShell
extends EntityThrowableNT
implements IChunkLoader,
IRadarDetectable {
    private ForgeChunkManager.Ticket loaderTicket;
    private int turnProgress;
    private double syncPosX;
    private double syncPosY;
    private double syncPosZ;
    private double syncYaw;
    private double syncPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private double targetX;
    private double targetY;
    private double targetZ;
    private boolean shouldWhistle = false;
    private boolean didWhistle = false;
    private ItemStack cargo = null;
    List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();

    public EntityArtilleryShell(World world) {
        super(world);
        this.field_70158_ak = true;
        this.func_70105_a(0.5f, 0.5f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_75682_a(10, (Object)new Integer(0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public EntityArtilleryShell setType(int type) {
        this.field_70180_af.func_75692_b(10, (Object)type);
        return this;
    }

    public ItemAmmoArty.ArtilleryShell getType() {
        try {
            return ItemAmmoArty.itemTypes[this.field_70180_af.func_75679_c(10)];
        }
        catch (Exception ex) {
            return ItemAmmoArty.itemTypes[0];
        }
    }

    public double[] getTarget() {
        return new double[]{this.targetX, this.targetY, this.targetZ};
    }

    public void setTarget(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public double getTargetHeight() {
        return this.targetY;
    }

    public void setWhistle(boolean whistle) {
        this.shouldWhistle = whistle;
    }

    public boolean getWhistle() {
        return this.shouldWhistle;
    }

    public boolean didWhistle() {
        return this.didWhistle;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            double deltaZ;
            double deltaX;
            double dist;
            double speed;
            super.func_70071_h_();
            if (!this.didWhistle && this.shouldWhistle && (speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 18.0 > (dist = Math.sqrt((deltaX = this.field_70165_t - this.targetX) * deltaX + (deltaZ = this.field_70161_v - this.targetZ) * deltaZ))) {
                this.field_70170_p.func_72908_a(this.targetX, this.targetY, this.targetZ, "hbm:turret.mortarWhistle", 15.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                this.didWhistle = true;
            }
            this.loadNeighboringChunks((int)Math.floor(this.field_70165_t / 16.0), (int)Math.floor(this.field_70161_v / 16.0));
            this.getType().onUpdate(this);
        } else {
            if (this.turnProgress > 0) {
                double interpX = this.field_70165_t + (this.syncPosX - this.field_70165_t) / (double)this.turnProgress;
                double interpY = this.field_70163_u + (this.syncPosY - this.field_70163_u) / (double)this.turnProgress;
                double interpZ = this.field_70161_v + (this.syncPosZ - this.field_70161_v) / (double)this.turnProgress;
                double d = MathHelper.func_76138_g((double)(this.syncYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d / (double)this.turnProgress);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.syncPitch - (double)this.field_70125_A) / (double)this.turnProgress);
                --this.turnProgress;
                this.func_70107_b(interpX, interpY, interpZ);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
            if (Vec3.func_72443_a((double)(this.syncPosX - this.field_70165_t), (double)(this.syncPosY - this.field_70163_u), (double)(this.syncPosZ - this.field_70161_v)).func_72433_c() < 0.2) {
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.1, 0.0);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.velocityX = this.field_70159_w = p_70016_1_;
        this.velocityY = this.field_70181_x = p_70016_3_;
        this.velocityZ = this.field_70179_y = p_70016_5_;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int theNumberThree) {
        this.syncPosX = x;
        this.syncPosY = y;
        this.syncPosZ = z;
        this.syncYaw = yaw;
        this.syncPitch = pitch;
        this.turnProgress = theNumberThree;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K) {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g instanceof EntityArtilleryShell) {
                return;
            }
            this.getType().onImpact(this, mop);
        }
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            this.clearChunkLoader();
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ));
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public void killAndClear() {
        this.func_70106_y();
        this.clearChunkLoader();
    }

    public void clearChunkLoader() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("type", this.field_70180_af.func_75679_c(10));
        nbt.func_74757_a("shouldWhistle", this.shouldWhistle);
        nbt.func_74757_a("didWhistle", this.didWhistle);
        nbt.func_74780_a("targetX", this.targetX);
        nbt.func_74780_a("targetY", this.targetY);
        nbt.func_74780_a("targetZ", this.targetZ);
        if (this.cargo != null) {
            nbt.func_74782_a("cargo", (NBTBase)this.cargo.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_75692_b(10, (Object)nbt.func_74762_e("type"));
        this.shouldWhistle = nbt.func_74767_n("shouldWhistle");
        this.didWhistle = nbt.func_74767_n("didWhistle");
        this.targetX = nbt.func_74769_h("targetX");
        this.targetY = nbt.func_74769_h("targetY");
        this.targetZ = nbt.func_74769_h("targetZ");
        NBTTagCompound compound = nbt.func_74775_l("cargo");
        this.setCargo(ItemStack.func_77949_a((NBTTagCompound)compound));
    }

    @Override
    protected float getAirDrag() {
        return 1.0f;
    }

    @Override
    public double getGravityVelocity() {
        return 0.49050000000000005;
    }

    @Override
    protected int groundDespawn() {
        return this.cargo != null ? 0 : 1200;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70075_an() {
        return true;
    }

    public void setCargo(ItemStack stack) {
        this.cargo = stack;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.cargo != null) {
                player.field_71071_by.func_70441_a(this.cargo.func_77946_l());
                player.field_71069_bz.func_75142_b();
            }
            this.func_70106_y();
        }
        return false;
    }

    @Override
    public IRadarDetectable.RadarTargetType getTargetType() {
        return IRadarDetectable.RadarTargetType.ARTILLERY;
    }
}

