/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.entity.projectile.EntityBulletBaseMK4;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.ICustomDamageHandler;
import com.hbm.explosion.vanillant.interfaces.IEntityProcessor;
import com.hbm.explosion.vanillant.interfaces.IEntityRangeMutator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityProcessorCross
implements IEntityProcessor {
    protected double nodeDist = 2.0;
    protected IEntityRangeMutator range;
    protected ICustomDamageHandler damage;
    protected double knockbackMult = 1.0;
    protected boolean allowSelfDamage = false;

    public EntityProcessorCross(double nodeDist) {
        this.nodeDist = nodeDist;
    }

    public EntityProcessorCross setAllowSelfDamage() {
        this.allowSelfDamage = true;
        return this;
    }

    public EntityProcessorCross setKnockback(double mult) {
        this.knockbackMult = mult;
        return this;
    }

    @Override
    public HashMap<EntityPlayer, Vec3> process(ExplosionVNT explosion, World world, double x, double y, double z, float size) {
        HashMap<EntityPlayer, Vec3> affectedPlayers = new HashMap<EntityPlayer, Vec3>();
        size *= 2.0f;
        if (this.range != null) {
            size = this.range.mutateRange(explosion, size);
        }
        double minX = x - (double)size - 1.0;
        double maxX = x + (double)size + 1.0;
        double minY = y - (double)size - 1.0;
        double maxY = y + (double)size + 1.0;
        double minZ = z - (double)size - 1.0;
        double maxZ = z + (double)size + 1.0;
        List list = world.func_72839_b(this.allowSelfDamage ? null : explosion.exploder, AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((World)world, (Explosion)explosion.compat, (List)list, (double)size);
        Vec3[] nodes = new Vec3[7];
        for (int i = 0; i < 7; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            nodes[i] = Vec3.func_72443_a((double)(x + (double)dir.offsetX * this.nodeDist), (double)(y + (double)dir.offsetY * this.nodeDist), (double)(z + (double)dir.offsetZ * this.nodeDist));
        }
        HashMap<Entity, Float> damageMap = new HashMap<Entity, Float>();
        for (int index = 0; index < list.size(); ++index) {
            double deltaZ;
            double deltaY;
            double deltaX;
            double distance;
            Entity entity = (Entity)list.get(index);
            double distanceScaled = entity.func_70011_f(x, y, z) / (double)size;
            if (!(distanceScaled <= 1.0) || (distance = Math.sqrt((deltaX = entity.field_70165_t - x) * deltaX + (deltaY = entity.field_70163_u + (double)entity.func_70047_e() - y) * deltaY + (deltaZ = entity.field_70161_v - z) * deltaZ)) == 0.0) continue;
            deltaX /= distance;
            deltaY /= distance;
            deltaZ /= distance;
            double density = 0.0;
            for (Vec3 vec : nodes) {
                double d = world.func_72842_a(vec, entity.field_70121_D);
                if (!(d > density)) continue;
                density = d;
            }
            double knockback = (1.0 - distanceScaled) * density;
            float dmg = this.calculateDamage(distanceScaled, density, knockback, size);
            if (!damageMap.containsKey(entity) || ((Float)damageMap.get(entity)).floatValue() < dmg) {
                damageMap.put(entity, Float.valueOf(dmg));
            }
            double enchKnockback = EnchantmentProtection.func_92092_a((Entity)entity, (double)knockback);
            if (!(entity instanceof EntityBulletBaseMK4)) {
                entity.field_70159_w += deltaX * enchKnockback * this.knockbackMult;
                entity.field_70181_x += deltaY * enchKnockback * this.knockbackMult;
                entity.field_70179_y += deltaZ * enchKnockback * this.knockbackMult;
            }
            if (!(entity instanceof EntityPlayer)) continue;
            affectedPlayers.put((EntityPlayer)entity, Vec3.func_72443_a((double)(deltaX * knockback * this.knockbackMult), (double)(deltaY * knockback * this.knockbackMult), (double)(deltaZ * knockback * this.knockbackMult)));
        }
        for (Map.Entry entry : damageMap.entrySet()) {
            Entity entity = (Entity)entry.getKey();
            this.attackEntity(entity, explosion, ((Float)entry.getValue()).floatValue());
            if (this.damage == null) continue;
            double distanceScaled = entity.func_70011_f(x, y, z) / (double)size;
            this.damage.handleAttack(explosion, entity, distanceScaled);
        }
        return affectedPlayers;
    }

    public void attackEntity(Entity entity, ExplosionVNT source, float amount) {
        entity.func_70097_a(EntityProcessorCross.setExplosionSource(source.compat), amount);
    }

    public float calculateDamage(double distanceScaled, double density, double knockback, float size) {
        return (int)((knockback * knockback + knockback) / 2.0 * 8.0 * (double)size + 1.0);
    }

    public static DamageSource setExplosionSource(Explosion explosion) {
        return explosion != null && explosion.func_94613_c() != null ? new EntityDamageSource("explosion.player", (Entity)explosion.func_94613_c()).func_94540_d() : new DamageSource("explosion").func_94540_d();
    }

    public EntityProcessorCross withRangeMod(final float mod) {
        this.range = new IEntityRangeMutator(){

            @Override
            public float mutateRange(ExplosionVNT explosion, float range) {
                return range * mod;
            }
        };
        return this;
    }

    public EntityProcessorCross withDamageMod(ICustomDamageHandler damage) {
        this.damage = damage;
        return this;
    }
}

