/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.EntityProcessorCross;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.factory.ConfettiUtil;
import com.hbm.util.DamageResistanceHandler;
import com.hbm.util.EntityDamageUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;

public class EntityProcessorCrossSmooth
extends EntityProcessorCross {
    protected float fixedDamage;
    protected float pierceDT = 0.0f;
    protected float pierceDR = 0.0f;
    protected DamageResistanceHandler.DamageClass clazz = DamageResistanceHandler.DamageClass.EXPLOSIVE;

    public EntityProcessorCrossSmooth(double nodeDist, float fixedDamage) {
        super(nodeDist);
        this.fixedDamage = fixedDamage;
        this.setAllowSelfDamage();
    }

    public EntityProcessorCrossSmooth setupPiercing(float pierceDT, float pierceDR) {
        this.pierceDT = pierceDT;
        this.pierceDR = pierceDR;
        return this;
    }

    public EntityProcessorCrossSmooth setDamageClass(DamageResistanceHandler.DamageClass clazz) {
        this.clazz = clazz;
        return this;
    }

    @Override
    public void attackEntity(Entity entity, ExplosionVNT source, float amount) {
        if (!entity.func_70089_S()) {
            return;
        }
        if (source.exploder == entity) {
            amount *= 0.5f;
        }
        DamageSource dmg = BulletConfig.getDamage(null, source.exploder instanceof EntityLivingBase ? (EntityLivingBase)source.exploder : null, this.clazz);
        if (!(entity instanceof EntityLivingBase)) {
            entity.func_70097_a(dmg, amount);
        } else {
            EntityDamageUtil.attackEntityFromNT((EntityLivingBase)entity, dmg, amount, true, false, 0.0, this.pierceDT, this.pierceDR);
            if (!entity.func_70089_S()) {
                ConfettiUtil.decideConfetti((EntityLivingBase)entity, dmg);
            }
        }
    }

    @Override
    public float calculateDamage(double distanceScaled, double density, double knockback, float size) {
        return (float)((double)this.fixedDamage * (1.0 - distanceScaled));
    }
}

