/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.main.CraftingManager;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import li.cil.oc.api.Items;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SidedComponent;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompatHandler {
    public static HashMap<String, FloppyDisk> disks = new HashMap();
    public static final String nullComponent = "ntm_null";

    public static Object[] steamTypeToInt(FluidType type) {
        switch (type.getID()) {
            case 4: {
                return new Object[]{1};
            }
            case 5: {
                return new Object[]{2};
            }
            case 6: {
                return new Object[]{3};
            }
        }
        return new Object[]{0};
    }

    public static FluidType intToSteamType(int arg) {
        switch (arg) {
            case 1: {
                return Fluids.HOTSTEAM;
            }
            case 2: {
                return Fluids.SUPERHOTSTEAM;
            }
            case 3: {
                return Fluids.ULTRAHOTSTEAM;
            }
        }
        return Fluids.STEAM;
    }

    public static void init() {
        if (Loader.isModLoaded((String)"OpenComputers")) {
            disks.put("PWRangler", new FloppyDisk("PWRangler", OCColors.CYAN.ordinal()));
            Logger logger = LogManager.getLogger((String)"HBM");
            logger.info("Loading OpenComputers disks...");
            if (disks.isEmpty()) {
                logger.info("No disks registered; see com.hbm.handler.CompatHandler.disks");
                return;
            }
            disks.forEach((s, disk) -> {
                FileSystem fs = li.cil.oc.api.FileSystem.fromClass(MainRegistry.class, (String)"hbm", (String)("disks/" + disk.fs.name));
                if (fs == null) {
                    logger.error("Error loading disk: {} at /assets/hbm/disks/{}", new Object[]{s, disk.fs.name});
                    logger.error("This is likely due to the path to the disk being non-existent.");
                } else {
                    disk.item = Items.registerFloppy((String)s, (int)disk.color.byteValue(), (Callable)disk.fs);
                    logger.info("Registered disk: {} at /assets/hbm/disks/{}", new Object[]{s, disk.fs.name});
                }
            });
            logger.info("OpenComputers disks registered.");
            List<ItemStack> floppyDisks = new RecipesCommon.OreDictStack("oc:floppy").toStacks();
            if (!floppyDisks.isEmpty()) {
                CraftingManager.addShapelessAuto(CompatHandler.disks.get((Object)"PWRangler").item, "oc:floppy", new ItemStack(ModBlocks.pwr_casing));
                logger.info("OpenComputers disk recipe added for PWRangler.");
            } else {
                logger.info("OpenComputers floppy disk oredict not found, recipes cannot be loaded!");
            }
            logger.info("OpenComputers disks loaded.");
        }
    }

    @Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.SidedComponent", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="OpenComputers")})
    @SimpleComponent.SkipInjection
    public static interface OCComponent
    extends SimpleComponent,
    SidedComponent,
    ManagedPeripheral {
        @Optional.Method(modid="OpenComputers")
        default public String getComponentName() {
            return CompatHandler.nullComponent;
        }

        @Optional.Method(modid="OpenComputers")
        default public boolean canConnectNode(ForgeDirection side) {
            return !this.getComponentName().equals(CompatHandler.nullComponent);
        }

        @Optional.Method(modid="OpenComputers")
        default public String[] methods() {
            return new String[0];
        }

        @Optional.Method(modid="OpenComputers")
        default public Object[] invoke(String method, Context context, Arguments args) throws Exception {
            return null;
        }
    }

    public static enum OCColors {
        BLACK,
        RED,
        GREEN,
        BROWN,
        BLUE,
        PURPLE,
        CYAN,
        LIGHTGRAY,
        GRAY,
        PINK,
        LIME,
        YELLOW,
        LIGHTBLUE,
        MAGENTA,
        ORANGE,
        WHITE;

    }

    public static class FloppyDisk {
        protected final ReadOnlyFileSystem fs;
        public final Byte color;
        public ItemStack item;

        FloppyDisk(String name, int color) {
            this.fs = new ReadOnlyFileSystem(FloppyDisk.sanitizeName(name));
            this.color = (byte)color;
        }

        public static String sanitizeName(String input) {
            return input.toLowerCase().replaceAll("\\W", "");
        }
    }

    protected static class ReadOnlyFileSystem
    implements Callable<FileSystem> {
        private final String name;

        ReadOnlyFileSystem(String name) {
            this.name = name;
        }

        @Override
        @Optional.Method(modid="OpenComputers")
        public FileSystem call() throws Exception {
            return li.cil.oc.api.FileSystem.asReadOnly((FileSystem)li.cil.oc.api.FileSystem.fromClass(MainRegistry.class, (String)"hbm", (String)("disks/" + FloppyDisk.sanitizeName(this.name))));
        }
    }
}

