/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.config.ToolConfig;
import com.hbm.explosion.ExplosionNT;
import com.hbm.handler.ThreeInts;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.CentrifugeRecipes;
import com.hbm.inventory.recipes.CrystallizerRecipes;
import com.hbm.inventory.recipes.ShredderRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.tool.IItemAbility;
import com.hbm.util.EnchantmentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class ToolAbility {
    public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
        return false;
    }

    public abstract String getName();

    public abstract String getFullName();

    public abstract String getExtension();

    public abstract boolean isAllowed();

    public static class ExplosionAbility
    extends ToolAbility {
        float strength;

        public ExplosionAbility(float strength) {
            this.strength = strength;
        }

        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            ExplosionNT ex = new ExplosionNT(player.field_70170_p, (Entity)player, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.strength);
            ex.addAttrib(ExplosionNT.ExAttrib.ALLDROP);
            ex.addAttrib(ExplosionNT.ExAttrib.NOHURT);
            ex.addAttrib(ExplosionNT.ExAttrib.NOPARTICLE);
            ex.func_77278_a();
            ex.func_77279_a(false);
            player.field_70170_p.func_72876_a((Entity)player, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.1f, false);
            return true;
        }

        @Override
        public String getExtension() {
            return " (" + this.strength + ")";
        }

        @Override
        public String getName() {
            return "tool.ability.explosion";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + this.getExtension();
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityExplosion;
        }
    }

    public static class MercuryAbility
    extends ToolAbility {
        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            int mercury = 0;
            if (block == Blocks.field_150450_ax) {
                mercury = player.func_70681_au().nextInt(5) + 4;
            }
            if (block == Blocks.field_150451_bX) {
                mercury = player.func_70681_au().nextInt(7) + 8;
            }
            if (mercury > 0) {
                world.func_147468_f(x, y, z);
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.ingot_mercury, mercury)));
                player.func_70694_bm().func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public String getName() {
            return "tool.ability.mercury";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityMercury;
        }
    }

    public static class CrystallizerAbility
    extends ToolAbility {
        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            ItemStack stack;
            CrystallizerRecipes.CrystallizerRecipe result;
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            if ((result = CrystallizerRecipes.getOutput(stack = new ItemStack(block, 1, meta), Fluids.PEROXIDE)) != null) {
                world.func_147468_f(x, y, z);
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, result.output.func_77946_l()));
                player.func_70694_bm().func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public String getName() {
            return "tool.ability.crystallizer";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityCrystallizer;
        }
    }

    public static class CentrifugeAbility
    extends ToolAbility {
        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            ItemStack stack;
            ItemStack[] result;
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            if ((result = CentrifugeRecipes.getOutput(stack = new ItemStack(block, 1, meta))) != null) {
                world.func_147468_f(x, y, z);
                player.func_70694_bm().func_77972_a(1, (EntityLivingBase)player);
                for (ItemStack st : result) {
                    if (st == null) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, st.func_77946_l()));
                }
            }
            return false;
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public String getName() {
            return "tool.ability.centrifuge";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityCentrifuge;
        }
    }

    public static class ShredderAbility
    extends ToolAbility {
        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            ItemStack stack;
            ItemStack result;
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            if ((result = ShredderRecipes.getShredderResult(stack = new ItemStack(block, 1, meta))) != null && result.func_77973_b() != ModItems.scrap) {
                world.func_147468_f(x, y, z);
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, result.func_77946_l()));
                player.func_70694_bm().func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }

        @Override
        public String getName() {
            return "tool.ability.shredder";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityShredder;
        }
    }

    public static class SmelterAbility
    extends ToolAbility {
        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            ArrayList drops = block.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            boolean doesSmelt = false;
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack stack = ((ItemStack)drops.get(i)).func_77946_l();
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                if (result == null) continue;
                result = result.func_77946_l();
                result.field_77994_a *= stack.field_77994_a;
                drops.set(i, result);
                doesSmelt = true;
            }
            if (doesSmelt) {
                world.func_147468_f(x, y, z);
                player.func_70694_bm().func_77972_a(1, (EntityLivingBase)player);
                for (ItemStack stack : drops) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack.func_77946_l()));
                }
            }
            return false;
        }

        @Override
        public String getName() {
            return "tool.ability.smelter";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityFurnace;
        }
    }

    public static class LuckAbility
    extends ToolAbility {
        int luck;

        public LuckAbility(int luck) {
            this.luck = luck;
        }

        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            if (EnchantmentHelper.func_77517_e((EntityLivingBase)player) > 0 || player.func_70694_bm() == null) {
                return false;
            }
            ItemStack stack = player.func_70694_bm();
            EnchantmentUtil.addEnchantment(stack, Enchantment.field_77346_s, this.luck);
            if (player instanceof EntityPlayerMP) {
                IItemAbility.standardDigPost(world, x, y, z, (EntityPlayerMP)player);
            }
            EnchantmentUtil.removeEnchantment(stack, Enchantment.field_77346_s);
            return true;
        }

        @Override
        public String getName() {
            return "tool.ability.luck";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + this.getExtension();
        }

        @Override
        public String getExtension() {
            return " (" + this.luck + ")";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityLuck;
        }
    }

    public static class SilkAbility
    extends ToolAbility {
        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            if (EnchantmentHelper.func_77502_d((EntityLivingBase)player) || player.func_70694_bm() == null) {
                return false;
            }
            ItemStack stack = player.func_70694_bm();
            EnchantmentUtil.addEnchantment(stack, Enchantment.field_77348_q, 1);
            if (player instanceof EntityPlayerMP) {
                IItemAbility.standardDigPost(world, x, y, z, (EntityPlayerMP)player);
            }
            EnchantmentUtil.removeEnchantment(stack, Enchantment.field_77348_q);
            return true;
        }

        @Override
        public String getName() {
            return "tool.ability.silktouch";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilitySilk;
        }
    }

    public static class HammerAbility
    extends ToolAbility {
        int range;

        public HammerAbility(int range) {
            this.range = range;
        }

        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            for (int a = x - this.range; a <= x + this.range; ++a) {
                for (int b = y - this.range; b <= y + this.range; ++b) {
                    for (int c = z - this.range; c <= z + this.range; ++c) {
                        if (a == x && b == y && c == z) continue;
                        tool.breakExtraBlock(world, a, b, c, player, x, y, z);
                    }
                }
            }
            return false;
        }

        @Override
        public String getName() {
            return "tool.ability.hammer";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + this.getExtension();
        }

        @Override
        public String getExtension() {
            return " (" + this.range + ")";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityHammer;
        }
    }

    public static class RecursionAbility
    extends ToolAbility {
        int radius;
        private Set<ThreeInts> pos = new HashSet<ThreeInts>();

        public RecursionAbility(int radius) {
            this.radius = radius;
        }

        @Override
        public boolean onDig(World world, int x, int y, int z, EntityPlayer player, Block block, int meta, IItemAbility tool) {
            Block b = world.func_147439_a(x, y, z);
            if (b == Blocks.field_150348_b && !ToolConfig.recursiveStone) {
                return false;
            }
            if (b == Blocks.field_150424_aL && !ToolConfig.recursiveNetherrack) {
                return false;
            }
            List<Integer> indices = Arrays.asList(0, 1, 2, 3, 4, 5);
            Collections.shuffle(indices);
            this.pos.clear();
            for (Integer i : indices) {
                switch (i) {
                    case 0: {
                        this.breakExtra(world, x + 1, y, z, x, y, z, player, tool, 0);
                        break;
                    }
                    case 1: {
                        this.breakExtra(world, x - 1, y, z, x, y, z, player, tool, 0);
                        break;
                    }
                    case 2: {
                        this.breakExtra(world, x, y + 1, z, x, y, z, player, tool, 0);
                        break;
                    }
                    case 3: {
                        this.breakExtra(world, x, y - 1, z, x, y, z, player, tool, 0);
                        break;
                    }
                    case 4: {
                        this.breakExtra(world, x, y, z + 1, x, y, z, player, tool, 0);
                        break;
                    }
                    case 5: {
                        this.breakExtra(world, x, y, z - 1, x, y, z, player, tool, 0);
                    }
                }
            }
            return false;
        }

        private void breakExtra(World world, int x, int y, int z, int refX, int refY, int refZ, EntityPlayer player, IItemAbility tool, int depth) {
            if (this.pos.contains(new ThreeInts(x, y, z))) {
                return;
            }
            if (++depth > ToolConfig.recursionDepth) {
                return;
            }
            this.pos.add(new ThreeInts(x, y, z));
            if (x == refX && y == refY && z == refZ) {
                return;
            }
            if (Vec3.func_72443_a((double)(x - refX), (double)(y - refY), (double)(z - refZ)).func_72433_c() > (double)this.radius) {
                return;
            }
            Block b = world.func_147439_a(x, y, z);
            Block ref = world.func_147439_a(refX, refY, refZ);
            int meta = world.func_72805_g(x, y, z);
            int refMeta = world.func_72805_g(refX, refY, refZ);
            if (!this.isSameBlock(b, ref)) {
                return;
            }
            if (meta != refMeta) {
                return;
            }
            if (player.func_70694_bm() == null) {
                return;
            }
            tool.breakExtraBlock(world, x, y, z, player, refX, refY, refZ);
            List<Integer> indices = Arrays.asList(0, 1, 2, 3, 4, 5);
            Collections.shuffle(indices);
            for (Integer i : indices) {
                switch (i) {
                    case 0: {
                        this.breakExtra(world, x + 1, y, z, refX, refY, refZ, player, tool, depth);
                        break;
                    }
                    case 1: {
                        this.breakExtra(world, x - 1, y, z, refX, refY, refZ, player, tool, depth);
                        break;
                    }
                    case 2: {
                        this.breakExtra(world, x, y + 1, z, refX, refY, refZ, player, tool, depth);
                        break;
                    }
                    case 3: {
                        this.breakExtra(world, x, y - 1, z, refX, refY, refZ, player, tool, depth);
                        break;
                    }
                    case 4: {
                        this.breakExtra(world, x, y, z + 1, refX, refY, refZ, player, tool, depth);
                        break;
                    }
                    case 5: {
                        this.breakExtra(world, x, y, z - 1, refX, refY, refZ, player, tool, depth);
                    }
                }
            }
        }

        private boolean isSameBlock(Block b1, Block b2) {
            if (b1 == b2) {
                return true;
            }
            return b1 == Blocks.field_150450_ax && b2 == Blocks.field_150439_ay || b1 == Blocks.field_150439_ay && b2 == Blocks.field_150450_ax;
        }

        @Override
        public String getName() {
            return "tool.ability.recursion";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + this.getExtension();
        }

        @Override
        public String getExtension() {
            return " (" + this.radius + ")";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityVein;
        }
    }
}

