/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.Crosshair;
import com.hbm.lib.HbmCollection;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IRepairable;
import com.hbm.util.CompatExternal;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class GunEnergyFactory {
    public static GunConfiguration getExtConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.reloadSoundEnd = false;
        config.firingDuration = 0;
        config.ammoCap = 300;
        config.durability = 10000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = Crosshair.L_CIRCLE;
        config.firingSound = "hbm:weapon.extinguisher";
        config.reloadSound = "hbm:weapon.flamerReload";
        config.name = "PROTEX Fire Exinguisher 6kg";
        config.manufacturer = HbmCollection.EnumGunManufacturer.GLORIA;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.FEXT_NORMAL);
        config.config.add(BulletConfigSyncingUtil.FEXT_FOAM);
        config.config.add(BulletConfigSyncingUtil.FEXT_SAND);
        return config;
    }

    public static GunConfiguration getCryoCannonConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.firingDuration = 0;
        config.ammoCap = 1000;
        config.durability = 10000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = Crosshair.L_CIRCLE;
        config.name = "Cryo Cannon";
        config.manufacturer = HbmCollection.EnumGunManufacturer.DRG;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.CRYO_NORMAL);
        return config;
    }

    public static BulletConfiguration getFextConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fireext.stackFromEnum(ItemAmmoEnums.AmmoFireExt.WATER));
        bullet.ammoCount = 300;
        bullet.velocity = 0.75f;
        bullet.spread = 0.025f;
        bullet.wear = 1;
        bullet.bulletsMin = 2;
        bullet.bulletsMax = 3;
        bullet.dmgMin = 0.0f;
        bullet.dmgMax = 0.0f;
        bullet.gravity = 0.04;
        bullet.maxAge = 100;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = -1;
        bullet.plink = 0;
        bullet.bntHurt = (bulletEntity, target) -> target.func_70066_B();
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    int ix = (int)Math.floor(bullet.field_70165_t);
                    int iy = (int)Math.floor(bullet.field_70163_u);
                    int iz = (int)Math.floor(bullet.field_70161_v);
                    boolean fizz = false;
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                if (bullet.field_70170_p.func_147439_a(ix + i, iy + j, iz + k) != Blocks.field_150480_ab) continue;
                                bullet.field_70170_p.func_147449_b(ix + i, iy + j, iz + k, Blocks.field_150350_a);
                                fizz = true;
                            }
                        }
                    }
                    TileEntity core = CompatExternal.getCoreFromPos(bullet.field_70170_p, ix, iy, iz);
                    if (core instanceof IRepairable) {
                        ((IRepairable)core).tryExtinguish(bullet.field_70170_p, ix, iy, iz, IRepairable.EnumExtinguishType.WATER);
                    }
                    if (fizz) {
                        bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "random.fizz", 1.0f, 1.5f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.5f);
                    }
                }
            }
        };
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150355_j));
                    data.func_74780_a("posX", bullet.field_70165_t);
                    data.func_74780_a("posY", bullet.field_70163_u);
                    data.func_74780_a("posZ", bullet.field_70161_v);
                    data.func_74780_a("mX", bullet.field_70159_w + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mY", bullet.field_70181_x - 0.2 + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mZ", bullet.field_70179_y + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    MainRegistry.proxy.effectNT(data);
                } else {
                    int z;
                    int y;
                    int x = (int)Math.floor(bullet.field_70165_t);
                    if (bullet.field_70170_p.func_147439_a(x, y = (int)Math.floor(bullet.field_70163_u), z = (int)Math.floor(bullet.field_70161_v)) == ModBlocks.volcanic_lava_block && bullet.field_70170_p.func_72805_g(x, y, z) == 0) {
                        bullet.field_70170_p.func_147449_b(x, y, z, Blocks.field_150343_Z);
                        bullet.func_70106_y();
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getFextFoamConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFextConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fireext.stackFromEnum(ItemAmmoEnums.AmmoFireExt.FOAM));
        bullet.spread = 0.05f;
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    int ix = (int)Math.floor(bullet.field_70165_t);
                    int iy = (int)Math.floor(bullet.field_70163_u);
                    int iz = (int)Math.floor(bullet.field_70161_v);
                    boolean fizz = false;
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                Block b = bullet.field_70170_p.func_147439_a(ix + i, iy + j, iz + k);
                                if (b.func_149688_o() != Material.field_151581_o) continue;
                                bullet.field_70170_p.func_147449_b(ix + i, iy + j, iz + k, Blocks.field_150350_a);
                                fizz = true;
                            }
                        }
                    }
                    Block b = bullet.field_70170_p.func_147439_a(ix, iy, iz);
                    TileEntity core = CompatExternal.getCoreFromPos(bullet.field_70170_p, ix, iy, iz);
                    if (core instanceof IRepairable) {
                        ((IRepairable)core).tryExtinguish(bullet.field_70170_p, ix, iy, iz, IRepairable.EnumExtinguishType.FOAM);
                        return;
                    }
                    if (b.isReplaceable((IBlockAccess)bullet.field_70170_p, ix, iy, iz) && ModBlocks.foam_layer.func_149742_c(bullet.field_70170_p, ix, iy, iz)) {
                        if (b != ModBlocks.foam_layer) {
                            bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.foam_layer);
                        } else {
                            int meta = bullet.field_70170_p.func_72805_g(ix, iy, iz);
                            if (meta < 6) {
                                bullet.field_70170_p.func_72921_c(ix, iy, iz, meta + 1, 3);
                            } else {
                                bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.block_foam);
                            }
                        }
                    }
                    if (fizz) {
                        bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "random.fizz", 1.0f, 1.5f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.5f);
                    }
                }
            }
        };
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)ModBlocks.block_foam));
                    data.func_74780_a("posX", bullet.field_70165_t);
                    data.func_74780_a("posY", bullet.field_70163_u);
                    data.func_74780_a("posZ", bullet.field_70161_v);
                    data.func_74780_a("mX", bullet.field_70159_w + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mY", bullet.field_70181_x - 0.2 + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mZ", bullet.field_70179_y + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    MainRegistry.proxy.effectNT(data);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getFextSandConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFextConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fireext.stackFromEnum(ItemAmmoEnums.AmmoFireExt.SAND));
        bullet.spread = 0.1f;
        bullet.bntHurt = null;
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    int ix = (int)Math.floor(bullet.field_70165_t);
                    int iy = (int)Math.floor(bullet.field_70163_u);
                    int iz = (int)Math.floor(bullet.field_70161_v);
                    Block b = bullet.field_70170_p.func_147439_a(ix, iy, iz);
                    TileEntity core = CompatExternal.getCoreFromPos(bullet.field_70170_p, ix, iy, iz);
                    if (core instanceof IRepairable) {
                        ((IRepairable)core).tryExtinguish(bullet.field_70170_p, ix, iy, iz, IRepairable.EnumExtinguishType.SAND);
                        return;
                    }
                    if ((b.isReplaceable((IBlockAccess)bullet.field_70170_p, ix, iy, iz) || b == ModBlocks.sand_boron_layer) && ModBlocks.sand_boron_layer.func_149742_c(bullet.field_70170_p, ix, iy, iz)) {
                        if (b != ModBlocks.sand_boron_layer) {
                            bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.sand_boron_layer);
                        } else {
                            int meta = bullet.field_70170_p.func_72805_g(ix, iy, iz);
                            if (meta < 6) {
                                bullet.field_70170_p.func_72921_c(ix, iy, iz, meta + 1, 3);
                            } else {
                                bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.sand_boron);
                            }
                        }
                        if (b.func_149688_o() == Material.field_151581_o) {
                            bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "random.fizz", 1.0f, 1.5f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.5f);
                        }
                    }
                }
            }
        };
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)ModBlocks.sand_boron));
                    data.func_74780_a("posX", bullet.field_70165_t);
                    data.func_74780_a("posY", bullet.field_70163_u);
                    data.func_74780_a("posZ", bullet.field_70161_v);
                    data.func_74780_a("mX", bullet.field_70159_w + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.1);
                    data.func_74780_a("mY", bullet.field_70181_x - 0.2 + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.1);
                    data.func_74780_a("mZ", bullet.field_70179_y + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.1);
                    MainRegistry.proxy.effectNT(data);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getCryoConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.gun_cryolator_ammo);
        bullet.ammoCount = 100;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        return bullet;
    }

    public static BulletConfiguration getTurbineConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.nothing);
        bullet.dmgMin = 100.0f;
        bullet.dmgMax = 150.0f;
        bullet.velocity = 1.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 200;
        bullet.style = 15;
        bullet.destroysBlocks = true;
        bullet.doesRicochet = false;
        return bullet;
    }
}

