/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.threading;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hbm.config.GeneralConfig;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.threading.PrecompiledPacket;
import com.hbm.packet.threading.ThreadedPacket;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketThreading {
    public static final String threadPrefix = "NTM-Packet-Thread-";
    public static final ThreadFactory packetThreadFactory = new ThreadFactoryBuilder().setNameFormat("NTM-Packet-Thread-%d").build();
    public static final ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(1, packetThreadFactory);
    public static int totalCnt = 0;
    public static long nanoTimeWaited = 0L;
    public static final List<Future<?>> futureList = new ArrayList();
    public static ReentrantLock lock = new ReentrantLock();
    public static int clearCnt = 0;
    public static boolean hasTriggered = false;

    public static void init() {
        threadPool.setKeepAliveTime(50L, TimeUnit.MILLISECONDS);
        if (GeneralConfig.enablePacketThreading) {
            if (GeneralConfig.packetThreadingCoreCount < 0 || GeneralConfig.packetThreadingMaxCount <= 0) {
                MainRegistry.logger.error("0.02_packetThreadingCoreCount < 0 or 0.03_packetThreadingMaxCount is <= 0, defaulting to 1 each.");
                threadPool.setCorePoolSize(1);
                threadPool.setMaximumPoolSize(1);
            } else if (GeneralConfig.packetThreadingMaxCount > GeneralConfig.packetThreadingCoreCount) {
                MainRegistry.logger.error("0.03_packetThreadingMaxCount is > 0.02_packetThreadingCoreCount, defaulting to 1 each.");
                threadPool.setCorePoolSize(1);
                threadPool.setMaximumPoolSize(1);
            } else {
                threadPool.setCorePoolSize(GeneralConfig.packetThreadingCoreCount);
                threadPool.setMaximumPoolSize(GeneralConfig.packetThreadingMaxCount);
            }
            threadPool.allowCoreThreadTimeOut(false);
        } else {
            threadPool.allowCoreThreadTimeOut(true);
            try {
                lock.lock();
                for (Runnable task : threadPool.getQueue()) {
                    task.run();
                }
                PacketThreading.clearThreadPoolTasks();
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static boolean preparePacket(IMessage message) {
        if (message instanceof PrecompiledPacket) {
            ((PrecompiledPacket)message).getCompiledBuffer();
        }
        ++totalCnt;
        if (!(message instanceof ThreadedPacket)) {
            MainRegistry.logger.error("Invalid packet class, expected ThreadedPacket, got {}.", new Object[]{message.getClass().getSimpleName()});
            return true;
        }
        return false;
    }

    public static void createAllAroundThreadedPacket(IMessage message, NetworkRegistry.TargetPoint target) {
        if (PacketThreading.preparePacket(message)) {
            return;
        }
        ThreadedPacket packet = (ThreadedPacket)message;
        Runnable task = () -> {
            try {
                lock.lock();
                PacketDispatcher.wrapper.sendToAllAround(message, target);
                packet.getCompiledBuffer().release();
            }
            finally {
                lock.unlock();
            }
        };
        PacketThreading.addTask(task);
    }

    public static void createSendToThreadedPacket(IMessage message, EntityPlayerMP player) {
        if (PacketThreading.preparePacket(message)) {
            return;
        }
        ThreadedPacket packet = (ThreadedPacket)message;
        Runnable task = () -> {
            try {
                lock.lock();
                PacketDispatcher.wrapper.sendTo(message, player);
                packet.getCompiledBuffer().release();
            }
            finally {
                lock.unlock();
            }
        };
        PacketThreading.addTask(task);
    }

    private static void addTask(Runnable task) {
        if (PacketThreading.isTriggered()) {
            task.run();
        } else if (GeneralConfig.enablePacketThreading) {
            futureList.add(threadPool.submit(task));
        } else {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void waitUntilThreadFinished() {
        long startTime = System.nanoTime();
        try {
            if (GeneralConfig.enablePacketThreading && !GeneralConfig.packetThreadingErrorBypass && !hasTriggered) {
                for (Future<?> future : futureList) {
                    nanoTimeWaited = System.nanoTime() - startTime;
                    future.get(50L, TimeUnit.MILLISECONDS);
                }
            }
            futureList.clear();
        }
        catch (ExecutionException executionException) {
            futureList.clear();
            if (!threadPool.getQueue().isEmpty()) {
                if (!GeneralConfig.packetThreadingErrorBypass && !hasTriggered) {
                    MainRegistry.logger.warn("Residual packets in packet threading queue detected, discarding {}/{} packets.", new Object[]{threadPool.getQueue().size(), totalCnt});
                }
                PacketThreading.clearThreadPoolTasks();
            }
            totalCnt = 0;
        }
        catch (TimeoutException e) {
            if (!GeneralConfig.packetThreadingErrorBypass && !hasTriggered) {
                MainRegistry.logger.warn("A packet has taken >50ms to process, discarding {}/{} packets to prevent pausing of main thread ({} total futures).", new Object[]{threadPool.getQueue().size(), totalCnt, futureList.size()});
            }
            PacketThreading.clearThreadPoolTasks();
            futureList.clear();
            if (!threadPool.getQueue().isEmpty()) {
                if (!GeneralConfig.packetThreadingErrorBypass && !hasTriggered) {
                    MainRegistry.logger.warn("Residual packets in packet threading queue detected, discarding {}/{} packets.", new Object[]{threadPool.getQueue().size(), totalCnt});
                }
                PacketThreading.clearThreadPoolTasks();
            }
            totalCnt = 0;
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            futureList.clear();
            {
                catch (Throwable throwable) {
                    futureList.clear();
                    if (!threadPool.getQueue().isEmpty()) {
                        if (!GeneralConfig.packetThreadingErrorBypass && !hasTriggered) {
                            MainRegistry.logger.warn("Residual packets in packet threading queue detected, discarding {}/{} packets.", new Object[]{threadPool.getQueue().size(), totalCnt});
                        }
                        PacketThreading.clearThreadPoolTasks();
                    }
                    totalCnt = 0;
                    throw throwable;
                }
            }
            if (!threadPool.getQueue().isEmpty()) {
                if (!GeneralConfig.packetThreadingErrorBypass && !hasTriggered) {
                    MainRegistry.logger.warn("Residual packets in packet threading queue detected, discarding {}/{} packets.", new Object[]{threadPool.getQueue().size(), totalCnt});
                }
                PacketThreading.clearThreadPoolTasks();
            }
            totalCnt = 0;
        }
        if (!threadPool.getQueue().isEmpty()) {
            if (!GeneralConfig.packetThreadingErrorBypass && !hasTriggered) {
                MainRegistry.logger.warn("Residual packets in packet threading queue detected, discarding {}/{} packets.", new Object[]{threadPool.getQueue().size(), totalCnt});
            }
            PacketThreading.clearThreadPoolTasks();
        }
        totalCnt = 0;
    }

    public static void clearThreadPoolTasks() {
        if (threadPool.getQueue().isEmpty()) {
            clearCnt = 0;
            return;
        }
        threadPool.getQueue().clear();
        if (!GeneralConfig.packetThreadingErrorBypass && !hasTriggered) {
            MainRegistry.logger.warn("Packet work queue cleared forcefully (clear count: {}).", new Object[]{clearCnt});
        }
        if (++clearCnt > 5 && !PacketThreading.isTriggered()) {
            MainRegistry.logger.error("Something has gone wrong and the packet pool has cleared 5 times (or more) in a row. This can indicate that the thread has been killed, suspended, or is otherwise non-functioning. This message will only be logged once, further packet operations will continue on the main thread. If this message is a common occurrence and is *completely expected*, then it can be bypassed permanently by setting the \"0.04_packetThreadingErrorBypass\" config option to true. This can lead to adverse effects, so do this at your own risk. Running \"/ntmpacket resetState\" resets this trigger as a temporary fix.");
            hasTriggered = true;
        }
    }

    public static boolean isTriggered() {
        return hasTriggered && !GeneralConfig.packetThreadingErrorBypass;
    }
}

