/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FluidTrait;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumChatFormatting;

public class FT_Heatable
extends FluidTrait {
    protected List<HeatingStep> steps = new ArrayList<HeatingStep>();
    protected HashMap<HeatingType, Double> efficiency = new HashMap();

    public FT_Heatable addStep(int heat, int req, FluidType type, int prod) {
        this.steps.add(new HeatingStep(req, heat, type, prod));
        return this;
    }

    public FT_Heatable setEff(HeatingType type, double eff) {
        this.efficiency.put(type, eff);
        return this;
    }

    public double getEfficiency(HeatingType type) {
        Double eff = this.efficiency.get((Object)type);
        return eff != null ? eff : 0.0;
    }

    public HeatingStep getFirstStep() {
        return this.steps.get(0);
    }

    @Override
    public void addInfoHidden(List<String> info) {
        info.add(EnumChatFormatting.RED + "Thermal capacity: " + this.getFirstStep().heatReq + " TU per " + this.getFirstStep().amountReq + "mB");
        for (HeatingType type : HeatingType.values()) {
            double eff = this.getEfficiency(type);
            if (!(eff > 0.0)) continue;
            info.add(EnumChatFormatting.YELLOW + "[" + type.name + "] " + EnumChatFormatting.AQUA + "Efficiency: " + (int)(eff * 100.0) + "%");
        }
    }

    @Override
    public void serializeJSON(JsonWriter writer) throws IOException {
        writer.name("steps").beginArray();
        for (HeatingStep heatingStep : this.steps) {
            writer.beginObject();
            writer.name("typeProduced").value(heatingStep.typeProduced.getName());
            writer.name("amountReq").value((long)heatingStep.amountReq);
            writer.name("amountProd").value((long)heatingStep.amountProduced);
            writer.name("heatReq").value((long)heatingStep.heatReq);
            writer.endObject();
        }
        writer.endArray();
        for (Map.Entry entry : this.efficiency.entrySet()) {
            writer.name(((HeatingType)((Object)entry.getKey())).name()).value((Number)entry.getValue());
        }
    }

    @Override
    public void deserializeJSON(JsonObject obj) {
        JsonArray steps = obj.get("steps").getAsJsonArray();
        for (int i = 0; i < steps.size(); ++i) {
            JsonObject step = steps.get(i).getAsJsonObject();
            this.steps.add(new HeatingStep(step.get("amountReq").getAsInt(), step.get("heatReq").getAsInt(), Fluids.fromName(step.get("typeProduced").getAsString()), step.get("amountProd").getAsInt()));
        }
        for (HeatingType type : HeatingType.values()) {
            if (!obj.has(type.name())) continue;
            this.efficiency.put(type, obj.get(type.name()).getAsDouble());
        }
    }

    public static enum HeatingType {
        BOILER("Boilable"),
        HEATEXCHANGER("Heatable"),
        PWR("PWR Coolant"),
        ICF("ICF Coolant"),
        PA("Particle Accelerator Coolant");

        public String name;

        private HeatingType(String name) {
            this.name = name;
        }
    }

    public static class HeatingStep {
        public final int amountReq;
        public final int heatReq;
        public final FluidType typeProduced;
        public final int amountProduced;

        public HeatingStep(int req, int heat, FluidType type, int prod) {
            this.amountReq = req;
            this.heatReq = heat;
            this.typeProduced = type;
            this.amountProduced = prod;
        }
    }
}

