/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ArmorUtil;
import com.hbm.util.I18nUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;

public class FT_Toxin
extends FluidTrait {
    public List<ToxinEntry> entries = new ArrayList<ToxinEntry>();

    public FT_Toxin addEntry(ToxinEntry entry) {
        this.entries.add(entry);
        return this;
    }

    @Override
    public void addInfoHidden(List<String> info) {
        info.add(EnumChatFormatting.LIGHT_PURPLE + "[Toxin]");
        for (ToxinEntry entry : this.entries) {
            entry.addInfo(info);
        }
    }

    public void affect(EntityLivingBase entity, double intensity) {
        for (ToxinEntry entry : this.entries) {
            entry.poison(entity, intensity);
        }
    }

    @Override
    public void serializeJSON(JsonWriter writer) throws IOException {
        writer.name("entries").beginArray();
        for (ToxinEntry entry : this.entries) {
            ToxinEntry e;
            writer.beginObject();
            if (entry instanceof ToxinDirectDamage) {
                e = (ToxinDirectDamage)entry;
                writer.name("type").value("directdamage");
                writer.name("amount").value((double)e.amount);
                writer.name("source").value(e.damage.field_76373_n);
                writer.name("delay").value((long)e.delay);
                writer.name("hazmat").value(e.fullBody);
                writer.name("masktype").value(e.clazz.name());
            }
            if (entry instanceof ToxinEffects) {
                e = (ToxinEffects)entry;
                writer.name("type").value("effects");
                writer.name("effects").beginArray();
                writer.setIndent("");
                for (PotionEffect effect : ((ToxinEffects)e).effects) {
                    writer.beginArray();
                    writer.value((long)effect.func_76456_a()).value((long)effect.func_76459_b()).value((long)effect.func_76458_c()).value(effect.func_82720_e());
                    writer.endArray();
                }
                writer.endArray();
                writer.setIndent("  ");
                writer.name("hazmat").value(((ToxinEffects)e).fullBody);
                writer.name("masktype").value(((ToxinEffects)e).clazz.name());
            }
            writer.endObject();
        }
        writer.endArray();
    }

    @Override
    public void deserializeJSON(JsonObject obj) {
        JsonArray array = obj.get("entries").getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            ToxinEntry e;
            JsonObject entry = array.get(i).getAsJsonObject();
            String name = entry.get("type").getAsString();
            if (name.equals("directdamage")) {
                e = new ToxinDirectDamage(new DamageSource(entry.get("source").getAsString()), entry.get("amount").getAsFloat(), entry.get("delay").getAsInt(), ArmorRegistry.HazardClass.valueOf(entry.get("masktype").getAsString()), entry.get("hazmat").getAsBoolean());
                this.entries.add(e);
            }
            if (!name.equals("effects")) continue;
            e = new ToxinEffects(ArmorRegistry.HazardClass.valueOf(entry.get("masktype").getAsString()), entry.get("hazmat").getAsBoolean());
            JsonArray effects = entry.get("effects").getAsJsonArray();
            for (int j = 0; j < effects.size(); ++j) {
                JsonArray effect = effects.get(j).getAsJsonArray();
                PotionEffect potion = new PotionEffect(effect.get(0).getAsInt(), effect.get(1).getAsInt(), effect.get(2).getAsInt(), effect.get(3).getAsBoolean());
                e.effects.add(potion);
            }
            this.entries.add(e);
        }
    }

    public static class ToxinEffects
    extends ToxinEntry {
        public List<PotionEffect> effects = new ArrayList<PotionEffect>();

        public ToxinEffects(ArmorRegistry.HazardClass clazz, boolean fullBody) {
            super(clazz, fullBody);
        }

        public ToxinEffects add(PotionEffect ... effs) {
            for (PotionEffect eff : effs) {
                this.effects.add(eff);
            }
            return this;
        }

        @Override
        public void poison(EntityLivingBase entity, double intensity) {
            if (this.isProtected(entity)) {
                return;
            }
            for (PotionEffect eff : this.effects) {
                entity.func_70690_d(new PotionEffect(eff.func_76456_a(), (int)((double)eff.func_76459_b() * intensity), eff.func_76458_c()));
            }
        }

        @Override
        public void addInfo(List<String> info) {
            info.add(EnumChatFormatting.YELLOW + "- " + I18nUtil.resolveKey(this.clazz.lang, new Object[0]) + (this.fullBody ? EnumChatFormatting.RED + " (requires hazmat suit)" + EnumChatFormatting.YELLOW : "") + ":");
            for (PotionEffect eff : this.effects) {
                info.add(EnumChatFormatting.YELLOW + "   - " + I18nUtil.resolveKey(eff.func_76453_d(), new Object[0]) + (eff.func_76458_c() > 0 ? " " + StatCollector.func_74838_a((String)("potion.potency." + eff.func_76458_c())).trim() : "") + " " + StringUtils.func_76337_a((int)eff.func_76459_b()));
            }
        }
    }

    public static class ToxinDirectDamage
    extends ToxinEntry {
        public DamageSource damage;
        public float amount;
        public int delay;

        public ToxinDirectDamage(DamageSource damage, float amount, int delay, ArmorRegistry.HazardClass clazz, boolean fullBody) {
            super(clazz, fullBody);
            this.damage = damage;
            this.amount = amount;
            this.delay = delay;
        }

        @Override
        public void poison(EntityLivingBase entity, double intensity) {
            if (this.isProtected(entity)) {
                return;
            }
            if (this.delay == 0 || entity.field_70170_p.func_82737_E() % (long)this.delay == 0L) {
                entity.func_70097_a(this.damage, (float)((double)this.amount * intensity));
            }
        }

        @Override
        public void addInfo(List<String> info) {
            info.add(EnumChatFormatting.YELLOW + "- " + I18nUtil.resolveKey(this.clazz.lang, new Object[0]) + (this.fullBody ? EnumChatFormatting.RED + " (requires hazmat suit)" : "") + ": " + EnumChatFormatting.YELLOW + String.format(Locale.US, "%,.1f", Float.valueOf(this.amount * 20.0f / (float)this.delay)) + " DPS");
        }
    }

    public static abstract class ToxinEntry {
        public ArmorRegistry.HazardClass clazz;
        public boolean fullBody = false;

        public ToxinEntry(ArmorRegistry.HazardClass clazz, boolean fullBody) {
            this.clazz = clazz;
            this.fullBody = fullBody;
        }

        public boolean isProtected(EntityLivingBase entity) {
            boolean hasSuit;
            boolean hasMask = this.clazz == null;
            boolean bl = hasSuit = !this.fullBody;
            if (this.clazz != null && ArmorRegistry.hasAllProtection(entity, 3, this.clazz)) {
                ArmorUtil.damageGasMaskFilter(entity, 1);
                hasMask = true;
            }
            if (this.fullBody && ArmorUtil.checkForHazmat(entity)) {
                hasSuit = true;
            }
            return hasMask && hasSuit;
        }

        public abstract void poison(EntityLivingBase var1, double var2);

        public abstract void addInfo(List<String> var1);
    }
}

