/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerCombustionEngine;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemPistons;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.machine.TileEntityMachineCombustionEngine;
import com.hbm.util.EnumUtil;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUICombustionEngine
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/generators/gui_combustion.png");
    private TileEntityMachineCombustionEngine engine;
    private int setting = 0;
    private boolean isMouseLocked = false;

    public GUICombustionEngine(InventoryPlayer invPlayer, TileEntityMachineCombustionEngine tedf) {
        super(new ContainerCombustionEngine(invPlayer, tedf));
        this.engine = tedf;
        this.setting = this.engine.setting;
        this.field_146999_f = 176;
        this.field_147000_g = 203;
    }

    public void func_73863_a(int x, int y, float interp) {
        super.func_73863_a(x, y, interp);
        if (!this.isMouseLocked) {
            this.drawElectricityInfo(this, x, y, this.field_147003_i + 143, this.field_147009_r + 17, 16, 52, this.engine.getPower(), TileEntityMachineCombustionEngine.maxPower);
            this.engine.tank.renderTankInfo(this, x, y, this.field_147003_i + 35, this.field_147009_r + 17, 16, 52);
        }
        if (this.isMouseLocked || this.field_147003_i + 80 <= x && this.field_147003_i + 80 + 34 > x && this.field_147009_r + 38 < y && this.field_147009_r + 38 + 8 >= y) {
            this.func_146279_a((double)(this.setting * 2) / 10.0 + "mB/t", MathHelper.func_76125_a((int)x, (int)(this.field_147003_i + 80), (int)(this.field_147003_i + 114)), MathHelper.func_76125_a((int)y, (int)(this.field_147009_r + 38), (int)(this.field_147009_r + 46)));
        }
        if (this.engine.slots[2] != null && this.engine.slots[2].func_77973_b() == ModItems.piston_set) {
            double power = 0.0;
            if (this.engine.tank.getTankType().hasTrait(FT_Combustible.class)) {
                FT_Combustible trait = this.engine.tank.getTankType().getTrait(FT_Combustible.class);
                int i = this.engine.slots[2].func_77960_j();
                ItemPistons.EnumPistonType piston = (ItemPistons.EnumPistonType)((Object)EnumUtil.grabEnumSafely(ItemPistons.EnumPistonType.class, i));
                power = (double)this.setting * 0.2 * (double)trait.getCombustionEnergy() / 1000.0 * piston.eff[trait.getGrade().ordinal()];
            }
            String c = EnumChatFormatting.YELLOW + "";
            this.drawCustomInfoStat(x, y, this.field_147003_i + 79, this.field_147009_r + 50, 35, 14, x, y, c + String.format(Locale.US, "%,d", (int)power) + " HE/t", c + String.format(Locale.US, "%,d", (int)(power * 20.0)) + " HE/s");
        }
        this.drawCustomInfoStat(x, y, this.field_147003_i + 79, this.field_147009_r + 13, 35, 15, x, y, "Ignition");
        if (this.isMouseLocked) {
            int setting = (x - this.field_147003_i - 81) * 30 / 32;
            if (this.setting != (setting = MathHelper.func_76125_a((int)setting, (int)0, (int)30))) {
                this.setting = setting;
                NBTTagCompound data = new NBTTagCompound();
                data.func_74768_a("setting", setting);
                PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.engine.field_145851_c, this.engine.field_145848_d, this.engine.field_145849_e));
            }
        }
    }

    protected void func_73864_a(int x, int y, int i) {
        super.func_73864_a(x, y, i);
        if (this.field_147003_i + 89 <= x && this.field_147003_i + 89 + 16 > x && this.field_147009_r + 13 < y && this.field_147009_r + 13 + 14 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("turnOn", true);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.engine.field_145851_c, this.engine.field_145848_d, this.engine.field_145849_e));
        }
        if (this.field_147003_i + 79 <= x && this.field_147003_i + 79 + 36 > x && this.field_147009_r + 38 < y && this.field_147009_r + 38 + 8 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            this.isMouseLocked = true;
        }
    }

    protected void func_146286_b(int x, int y, int i) {
        super.func_146286_b(x, y, i);
        if (this.isMouseLocked && (i == 0 || i == 1)) {
            this.isMouseLocked = false;
        }
    }

    protected void func_146979_b(int i, int j) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float interp, int x, int y) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.engine.slots[2] != null && this.engine.slots[2].func_77973_b() == ModItems.piston_set) {
            i = this.engine.slots[2].func_77960_j();
            this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 51, 176, 52 + i * 12, 25, 12);
        }
        this.func_73729_b(this.field_147003_i + 79 + this.setting * 32 / 30, this.field_147009_r + 38, 192, 15, 4, 8);
        if (this.engine.isOn) {
            this.func_73729_b(this.field_147003_i + 79, this.field_147009_r + 13, 192, 0, 35, 15);
        }
        i = (int)(this.engine.power * 53L / TileEntityMachineCombustionEngine.maxPower);
        this.func_73729_b(this.field_147003_i + 143, this.field_147009_r + 69 - i, 176, 52 - i, 16, i);
        this.engine.tank.renderTank(this.field_147003_i + 35, this.field_147009_r + 69, this.field_73735_i, 16, 52);
    }
}

