/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.network.TileEntityRadioTorchLogic;
import com.hbm.util.I18nUtil;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GUIScreenRadioTorchLogic
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/machine/gui_rtty_logic_receiver.png");
    protected TileEntityRadioTorchLogic logic;
    protected GuiTextField frequency;
    protected GuiTextField[] map;
    protected int[] conditions;
    protected static final int xSize = 256;
    protected static final int ySize = 204;
    protected int guiLeft;
    protected int guiTop;

    public GUIScreenRadioTorchLogic(TileEntityRadioTorchLogic logic) {
        this.logic = logic;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 204) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        int oX = 4;
        int oY = 4;
        this.frequency = new GuiTextField(this.field_146289_q, this.guiLeft + 25 + oX, this.guiTop + 17 + oY, 90 - oX * 2, 14);
        this.frequency.func_146193_g(65280);
        this.frequency.func_146204_h(65280);
        this.frequency.func_146185_a(false);
        this.frequency.func_146203_f(10);
        this.frequency.func_146180_a(this.logic.channel == null ? "" : this.logic.channel);
        this.map = new GuiTextField[16];
        this.conditions = new int[16];
        for (int i = 0; i < 16; ++i) {
            this.map[i] = new GuiTextField(this.field_146289_q, this.guiLeft + 7 + 130 * (i / 8) + oX + 18, this.guiTop + 53 + 18 * (i % 8) + oY, 54 - oX * 2, 14);
            this.map[i].func_146193_g(65280);
            this.map[i].func_146204_h(65280);
            this.map[i].func_146185_a(false);
            this.map[i].func_146203_f(15);
            this.map[i].func_146180_a(this.logic.mapping[i] == null ? "" : this.logic.mapping[i]);
            this.conditions[i] = this.logic.conditions[i];
        }
    }

    public void func_73863_a(int x, int y, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, x, y);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(x, y);
        GL11.glEnable((int)2896);
        if (this.guiLeft > x && this.guiLeft + 256 <= x && this.guiTop > y && this.guiTop + 204 <= y) {
            return;
        }
        if (!Mouse.isButtonDown((int)0) && !Mouse.isButtonDown((int)1) && Mouse.next()) {
            for (int j = 0; j < 16; ++j) {
                if (this.guiLeft + 7 + 130 * (j / 8) > x || this.guiLeft + 7 + 18 + 130 * (j / 8) <= x || this.guiTop + 53 + 18 * (j % 8) > y || this.guiTop + 53 + 18 + 18 * (j % 8) <= y) continue;
                int scroll = Mouse.getEventDWheel();
                if (scroll > 0) {
                    this.conditions[j] = (this.conditions[j] + 1) % 10;
                }
                if (scroll < 0) {
                    this.conditions[j] = (this.conditions[j] + 9) % 10;
                }
                return;
            }
        }
    }

    private void drawGuiContainerForegroundLayer(int x, int y) {
        String name = I18nUtil.resolveKey("container.rttyLogic", new Object[0]);
        this.field_146289_q.func_78276_b(name, this.guiLeft + 256 / 2 - this.field_146289_q.func_78256_a(name) / 2, this.guiTop + 6, 0x404040);
        if (this.guiLeft + 137 <= x && this.guiLeft + 137 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            this.func_146283_a(Arrays.asList(this.logic.descending ? "Descending Order" : "Ascending Order"), x, y);
        }
        if (this.guiLeft + 173 <= x && this.guiLeft + 173 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            this.func_146283_a(Arrays.asList(this.logic.polling ? "Polling" : "State Change"), x, y);
        }
        if (this.guiLeft + 209 <= x && this.guiLeft + 209 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            this.func_146283_a(Arrays.asList("Save Settings"), x, y);
        }
        for (int j = 0; j < 16; ++j) {
            if (this.guiLeft + 7 + 130 * (j / 8) > x || this.guiLeft + 7 + 18 + 130 * (j / 8) <= x || this.guiTop + 53 + 18 * (j % 8) > y || this.guiTop + 53 + 18 + 18 * (j % 8) <= y) continue;
            this.func_146283_a(Arrays.asList(I18nUtil.resolveKey("desc.gui.rttyLogic.cond" + this.conditions[j], new Object[0])), x, y);
            break;
        }
    }

    private void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 204);
        if (this.logic.descending) {
            this.func_73729_b(this.guiLeft + 137, this.guiTop + 17, 0, 204, 18, 18);
        }
        if (this.logic.polling) {
            this.func_73729_b(this.guiLeft + 173, this.guiTop + 17, 0, 222, 18, 18);
        }
        for (i = 0; i < 16; ++i) {
            if (this.logic.mapping[i].isEmpty()) {
                if (this.conditions[i] == 0) continue;
                this.func_73729_b(this.guiLeft + 7 + 130 * (i / 8), this.guiTop + 53 + 18 * (i % 8), 18 + this.conditions[i] * 18, 222, 18, 18);
                continue;
            }
            this.func_73729_b(this.guiLeft + 7 + 130 * (i / 8), this.guiTop + 53 + 18 * (i % 8), 18 + this.conditions[i] * 18, 204, 18, 18);
            this.func_73729_b(this.guiLeft + 85 + 130 * (i / 8), this.guiTop + 57 + 18 * (i % 8), 198, 204, 14, 10);
        }
        for (i = 0; i < 16; ++i) {
            this.map[i].func_146194_f();
        }
        this.frequency.func_146194_f();
    }

    protected void func_73864_a(int x, int y, int i) {
        int j;
        super.func_73864_a(x, y, i);
        this.frequency.func_146192_a(x, y, i);
        for (j = 0; j < 16; ++j) {
            this.map[j].func_146192_a(x, y, i);
        }
        if (this.guiLeft + 137 <= x && this.guiLeft + 137 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("d", !this.logic.descending);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.logic.field_145851_c, this.logic.field_145848_d, this.logic.field_145849_e));
        }
        if (this.guiLeft + 173 <= x && this.guiLeft + 173 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("p", !this.logic.polling);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.logic.field_145851_c, this.logic.field_145848_d, this.logic.field_145849_e));
        }
        if (this.guiLeft + 209 <= x && this.guiLeft + 209 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            int j2;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("c", this.frequency.func_146179_b());
            for (j2 = 0; j2 < 16; ++j2) {
                data.func_74778_a("m" + j2, this.map[j2].func_146179_b().isEmpty() ? "" : this.map[j2].func_146179_b());
            }
            for (j2 = 0; j2 < 16; ++j2) {
                data.func_74768_a("c" + j2, this.conditions[j2]);
            }
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.logic.field_145851_c, this.logic.field_145848_d, this.logic.field_145849_e));
        }
        for (j = 0; j < 16; ++j) {
            if (this.guiLeft + 7 + 130 * (j / 8) > x || this.guiLeft + 7 + 18 + 130 * (j / 8) <= x || this.guiTop + 53 + 18 * (j % 8) > y || this.guiTop + 53 + 18 + 18 * (j % 8) <= y) continue;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            this.conditions[j] = (this.conditions[j] + 1) % 10;
        }
    }

    protected void func_73869_a(char c, int i) {
        if (this.frequency.func_146201_a(c, i)) {
            return;
        }
        for (int j = 0; j < 16; ++j) {
            if (!this.map[j].func_146201_a(c, i)) continue;
            return;
        }
        if (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }
}

