/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes.loader;

import api.hbm.recipe.IRecipeRegisterListener;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.material.MatDistribution;
import com.hbm.inventory.recipes.AmmoPressRecipes;
import com.hbm.inventory.recipes.ArcFurnaceRecipes;
import com.hbm.inventory.recipes.ArcWelderRecipes;
import com.hbm.inventory.recipes.AssemblerRecipes;
import com.hbm.inventory.recipes.BlastFurnaceRecipes;
import com.hbm.inventory.recipes.BreederRecipes;
import com.hbm.inventory.recipes.CentrifugeRecipes;
import com.hbm.inventory.recipes.ChemplantRecipes;
import com.hbm.inventory.recipes.CokerRecipes;
import com.hbm.inventory.recipes.CombinationRecipes;
import com.hbm.inventory.recipes.CompressorRecipes;
import com.hbm.inventory.recipes.CrackingRecipes;
import com.hbm.inventory.recipes.CrucibleRecipes;
import com.hbm.inventory.recipes.CrystallizerRecipes;
import com.hbm.inventory.recipes.CustomMachineRecipes;
import com.hbm.inventory.recipes.CyclotronRecipes;
import com.hbm.inventory.recipes.ElectrolyserFluidRecipes;
import com.hbm.inventory.recipes.ElectrolyserMetalRecipes;
import com.hbm.inventory.recipes.ExposureChamberRecipes;
import com.hbm.inventory.recipes.FractionRecipes;
import com.hbm.inventory.recipes.FuelPoolRecipes;
import com.hbm.inventory.recipes.HadronRecipes;
import com.hbm.inventory.recipes.HydrotreatingRecipes;
import com.hbm.inventory.recipes.LiquefactionRecipes;
import com.hbm.inventory.recipes.MixerRecipes;
import com.hbm.inventory.recipes.OutgasserRecipes;
import com.hbm.inventory.recipes.ParticleAcceleratorRecipes;
import com.hbm.inventory.recipes.PedestalRecipes;
import com.hbm.inventory.recipes.PressRecipes;
import com.hbm.inventory.recipes.PyroOvenRecipes;
import com.hbm.inventory.recipes.ReformingRecipes;
import com.hbm.inventory.recipes.RotaryFurnaceRecipes;
import com.hbm.inventory.recipes.ShredderRecipes;
import com.hbm.inventory.recipes.SolderingRecipes;
import com.hbm.inventory.recipes.SolidificationRecipes;
import com.hbm.inventory.recipes.anvil.AnvilRecipes;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.util.Tuple;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class SerializableRecipe {
    public static final Gson gson = new Gson();
    public static List<SerializableRecipe> recipeHandlers = new ArrayList<SerializableRecipe>();
    public static List<IRecipeRegisterListener> additionalListeners = new ArrayList<IRecipeRegisterListener>();
    public boolean modified = false;

    public static void registerAllHandlers() {
        recipeHandlers.add(new PressRecipes());
        recipeHandlers.add(new BlastFurnaceRecipes());
        recipeHandlers.add(new ShredderRecipes());
        recipeHandlers.add(new SolderingRecipes());
        recipeHandlers.add(new ChemplantRecipes());
        recipeHandlers.add(new CombinationRecipes());
        recipeHandlers.add(new CrucibleRecipes());
        recipeHandlers.add(new CentrifugeRecipes());
        recipeHandlers.add(new CrystallizerRecipes());
        recipeHandlers.add(new FractionRecipes());
        recipeHandlers.add(new CrackingRecipes());
        recipeHandlers.add(new ReformingRecipes());
        recipeHandlers.add(new HydrotreatingRecipes());
        recipeHandlers.add(new LiquefactionRecipes());
        recipeHandlers.add(new SolidificationRecipes());
        recipeHandlers.add(new CokerRecipes());
        recipeHandlers.add(new PyroOvenRecipes());
        recipeHandlers.add(new BreederRecipes());
        recipeHandlers.add(new CyclotronRecipes());
        recipeHandlers.add(new HadronRecipes());
        recipeHandlers.add(new FuelPoolRecipes());
        recipeHandlers.add(new MixerRecipes());
        recipeHandlers.add(new OutgasserRecipes());
        recipeHandlers.add(new CompressorRecipes());
        recipeHandlers.add(new ElectrolyserFluidRecipes());
        recipeHandlers.add(new ElectrolyserMetalRecipes());
        recipeHandlers.add(new ArcWelderRecipes());
        recipeHandlers.add(new RotaryFurnaceRecipes());
        recipeHandlers.add(new ExposureChamberRecipes());
        recipeHandlers.add(new ParticleAcceleratorRecipes());
        recipeHandlers.add(new AmmoPressRecipes());
        recipeHandlers.add(new AssemblerRecipes());
        recipeHandlers.add(new AnvilRecipes());
        recipeHandlers.add(new PedestalRecipes());
        recipeHandlers.add(new MatDistribution());
        recipeHandlers.add(new CustomMachineRecipes());
        recipeHandlers.add(new ArcFurnaceRecipes());
    }

    public static void initialize() {
        File recDir = new File(MainRegistry.configDir.getAbsolutePath() + File.separatorChar + "hbmRecipes");
        if (!recDir.exists() && !recDir.mkdir()) {
            throw new IllegalStateException("Unable to make recipe directory " + recDir.getAbsolutePath());
        }
        File info = new File(recDir.getAbsolutePath() + File.separatorChar + "REMOVE UNDERSCORE TO ENABLE RECIPE LOADING - RECIPES WILL RESET TO DEFAULT OTHERWISE");
        try {
            info.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MainRegistry.logger.info("Starting recipe init!");
        for (SerializableRecipe recipe : recipeHandlers) {
            recipe.deleteRecipes();
            File recFile = new File(recDir.getAbsolutePath() + File.separatorChar + recipe.getFileName());
            if (recFile.exists() && recFile.isFile()) {
                MainRegistry.logger.info("Reading recipe file " + recFile.getName());
                recipe.readRecipeFile(recFile);
                recipe.modified = true;
            } else {
                MainRegistry.logger.info("No recipe file found, registering defaults for " + recipe.getFileName());
                recipe.registerDefaults();
                for (IRecipeRegisterListener listener : additionalListeners) {
                    listener.onRecipeLoad(recipe.getClass().getSimpleName());
                }
                File recTemplate = new File(recDir.getAbsolutePath() + File.separatorChar + "_" + recipe.getFileName());
                MainRegistry.logger.info("Writing template file " + recTemplate.getName());
                recipe.writeTemplateFile(recTemplate);
                recipe.modified = false;
            }
            recipe.registerPost();
        }
        MainRegistry.logger.info("Finished recipe init!");
    }

    public abstract String getFileName();

    public abstract Object getRecipeObject();

    public abstract void readRecipe(JsonElement var1);

    public abstract void writeRecipe(Object var1, JsonWriter var2) throws IOException;

    public abstract void registerDefaults();

    public abstract void deleteRecipes();

    public void registerPost() {
    }

    public String getComment() {
        return null;
    }

    public void writeTemplateFile(File template) {
        try {
            Object recipeObject = this.getRecipeObject();
            ArrayList recipeList = new ArrayList();
            if (recipeObject instanceof Collection) {
                recipeList.addAll((Collection)recipeObject);
            } else if (recipeObject instanceof HashMap) {
                recipeList.addAll(((HashMap)recipeObject).entrySet());
            }
            if (recipeList.isEmpty()) {
                throw new IllegalStateException("Error while writing recipes for " + this.getClass().getSimpleName() + ": Recipe list is either empty or in an unsupported format!");
            }
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(template));
            writer.setIndent("  ");
            writer.beginObject();
            if (this.getComment() != null) {
                writer.name("comment").value(this.getComment());
            }
            writer.name("recipes").beginArray();
            for (Object e : recipeList) {
                writer.beginObject();
                this.writeRecipe(e, writer);
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readRecipeFile(File file) {
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
            JsonArray recipes = json.get("recipes").getAsJsonArray();
            for (JsonElement recipe : recipes) {
                this.readRecipe(recipe);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static RecipesCommon.AStack readAStack(JsonArray array) {
        try {
            int stacksize;
            String type = array.get(0).getAsString();
            int n = stacksize = array.size() > 2 ? array.get(2).getAsInt() : 1;
            if ("item".equals(type)) {
                Item item = (Item)Item.field_150901_e.func_82594_a(array.get(1).getAsString());
                int meta = array.size() > 3 ? array.get(3).getAsInt() : 0;
                return new RecipesCommon.ComparableStack(item, stacksize, meta);
            }
            if ("dict".equals(type)) {
                String dict = array.get(1).getAsString();
                return new RecipesCommon.OreDictStack(dict, stacksize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MainRegistry.logger.error("Error reading stack array " + array.toString());
        return new RecipesCommon.ComparableStack(ModItems.nothing);
    }

    public static RecipesCommon.AStack[] readAStackArray(JsonArray array) {
        try {
            RecipesCommon.AStack[] items = new RecipesCommon.AStack[array.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = SerializableRecipe.readAStack((JsonArray)array.get(i));
            }
            return items;
        }
        catch (Exception exception) {
            MainRegistry.logger.error("Error reading stack array " + array.toString());
            return new RecipesCommon.AStack[0];
        }
    }

    public static void writeAStack(RecipesCommon.AStack astack, JsonWriter writer) throws IOException {
        writer.beginArray();
        writer.setIndent("");
        if (astack instanceof RecipesCommon.ComparableStack) {
            RecipesCommon.ComparableStack comp = (RecipesCommon.ComparableStack)astack;
            writer.value("item");
            writer.value(Item.field_150901_e.func_148750_c((Object)comp.toStack().func_77973_b()));
            if (comp.stacksize != 1 || comp.meta > 0) {
                writer.value((long)comp.stacksize);
            }
            if (comp.meta > 0) {
                writer.value((long)comp.meta);
            }
        }
        if (astack instanceof RecipesCommon.OreDictStack) {
            RecipesCommon.OreDictStack ore = (RecipesCommon.OreDictStack)astack;
            writer.value("dict");
            writer.value(ore.name);
            if (ore.stacksize != 1) {
                writer.value((long)ore.stacksize);
            }
        }
        writer.endArray();
        writer.setIndent("  ");
    }

    public static ItemStack readItemStack(JsonArray array) {
        try {
            int meta;
            Item item = (Item)Item.field_150901_e.func_82594_a(array.get(0).getAsString());
            int stacksize = array.size() > 1 ? array.get(1).getAsInt() : 1;
            int n = meta = array.size() > 2 ? array.get(2).getAsInt() : 0;
            if (item != null) {
                return new ItemStack(item, stacksize, meta);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MainRegistry.logger.error("Error reading stack array " + array.toString() + " - defaulting to NOTHING item!");
        return new ItemStack(ModItems.nothing);
    }

    public static Tuple.Pair<ItemStack, Float> readItemStackChance(JsonArray array) {
        try {
            Item item = (Item)Item.field_150901_e.func_82594_a(array.get(0).getAsString());
            int stacksize = array.size() > 2 ? array.get(1).getAsInt() : 1;
            int meta = array.size() > 3 ? array.get(2).getAsInt() : 0;
            float chance = array.get(array.size() - 1).getAsFloat();
            if (item != null) {
                return new Tuple.Pair<ItemStack, Float>(new ItemStack(item, stacksize, meta), Float.valueOf(chance));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MainRegistry.logger.error("Error reading stack array " + array.toString() + " - defaulting to NOTHING item!");
        return new Tuple.Pair<ItemStack, Float>(new ItemStack(ModItems.nothing), Float.valueOf(1.0f));
    }

    public static ItemStack[] readItemStackArray(JsonArray array) {
        try {
            ItemStack[] items = new ItemStack[array.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = SerializableRecipe.readItemStack((JsonArray)array.get(i));
            }
            return items;
        }
        catch (Exception exception) {
            MainRegistry.logger.error("Error reading stack array " + array.toString());
            return new ItemStack[0];
        }
    }

    public static Tuple.Pair<ItemStack, Float>[] readItemStackArrayChance(JsonArray array) {
        try {
            Tuple.Pair[] items = new Tuple.Pair[array.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = SerializableRecipe.readItemStackChance((JsonArray)array.get(i));
            }
            return items;
        }
        catch (Exception exception) {
            MainRegistry.logger.error("Error reading stack array " + array.toString());
            return new Tuple.Pair[0];
        }
    }

    public static void writeItemStack(ItemStack stack, JsonWriter writer) throws IOException {
        writer.beginArray();
        writer.setIndent("");
        writer.value(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        if (stack.field_77994_a != 1 || stack.func_77960_j() != 0) {
            writer.value((long)stack.field_77994_a);
        }
        if (stack.func_77960_j() != 0) {
            writer.value((long)stack.func_77960_j());
        }
        writer.endArray();
        writer.setIndent("  ");
    }

    public static void writeItemStackChance(Tuple.Pair<ItemStack, Float> stack, JsonWriter writer) throws IOException {
        writer.beginArray();
        writer.setIndent("");
        writer.value(Item.field_150901_e.func_148750_c((Object)stack.getKey().func_77973_b()));
        if (stack.getKey().field_77994_a != 1 || stack.getKey().func_77960_j() != 0) {
            writer.value((long)stack.getKey().field_77994_a);
        }
        if (stack.getKey().func_77960_j() != 0) {
            writer.value((long)stack.getKey().func_77960_j());
        }
        writer.value((Number)stack.value);
        writer.endArray();
        writer.setIndent("  ");
    }

    public static FluidStack readFluidStack(JsonArray array) {
        try {
            FluidType type = Fluids.fromName(array.get(0).getAsString());
            int fill = array.get(1).getAsInt();
            int pressure = array.size() < 3 ? 0 : array.get(2).getAsInt();
            return new FluidStack(type, fill, pressure);
        }
        catch (Exception exception) {
            MainRegistry.logger.error("Error reading fluid array " + array.toString());
            return new FluidStack(Fluids.NONE, 0);
        }
    }

    public static FluidStack[] readFluidArray(JsonArray array) {
        try {
            FluidStack[] fluids = new FluidStack[array.size()];
            for (int i = 0; i < fluids.length; ++i) {
                fluids[i] = SerializableRecipe.readFluidStack((JsonArray)array.get(i));
            }
            return fluids;
        }
        catch (Exception exception) {
            MainRegistry.logger.error("Error reading fluid array " + array.toString());
            return new FluidStack[0];
        }
    }

    public static void writeFluidStack(FluidStack stack, JsonWriter writer) throws IOException {
        writer.beginArray();
        writer.setIndent("");
        writer.value(stack.type.getName());
        writer.value((long)stack.fill);
        if (stack.pressure != 0) {
            writer.value((long)stack.pressure);
        }
        writer.endArray();
        writer.setIndent("  ");
    }

    public static boolean matchesIngredients(ItemStack[] inputs, RecipesCommon.AStack[] recipe) {
        ArrayList<RecipesCommon.AStack> recipeList = new ArrayList<RecipesCommon.AStack>();
        for (RecipesCommon.AStack ingredient : recipe) {
            recipeList.add(ingredient);
        }
        for (int i = 0; i < inputs.length; ++i) {
            ItemStack inputStack = inputs[i];
            if (inputStack == null) continue;
            boolean hasMatch = false;
            for (RecipesCommon.AStack recipeStack : recipeList) {
                if (!recipeStack.matchesRecipe(inputStack, true) || inputStack.field_77994_a < recipeStack.stacksize) continue;
                hasMatch = true;
                recipeList.remove(recipeStack);
                break;
            }
            if (hasMatch) continue;
            return false;
        }
        return recipeList.isEmpty();
    }
}

