/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.util.BobMathUtil;
import com.hbm.util.EnumUtil;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public class ItemICFPellet
extends Item {
    protected IIcon iconBG;
    public static HashMap<FluidType, EnumICFFuel> fluidMap = new HashMap();
    public static HashMap<NTMMaterial, EnumICFFuel> materialMap = new HashMap();

    public static void init() {
        if (!fluidMap.isEmpty() && !materialMap.isEmpty()) {
            return;
        }
        fluidMap.put(Fluids.HYDROGEN, EnumICFFuel.HYDROGEN);
        fluidMap.put(Fluids.DEUTERIUM, EnumICFFuel.DEUTERIUM);
        fluidMap.put(Fluids.TRITIUM, EnumICFFuel.TRITIUM);
        fluidMap.put(Fluids.HELIUM3, EnumICFFuel.HELIUM3);
        fluidMap.put(Fluids.HELIUM4, EnumICFFuel.HELIUM4);
        materialMap.put(Mats.MAT_LITHIUM, EnumICFFuel.LITHIUM);
        materialMap.put(Mats.MAT_BERYLLIUM, EnumICFFuel.BERYLLIUM);
        materialMap.put(Mats.MAT_BORON, EnumICFFuel.BORON);
        materialMap.put(Mats.MAT_GRAPHITE, EnumICFFuel.CARBON);
        fluidMap.put(Fluids.OXYGEN, EnumICFFuel.OXYGEN);
        materialMap.put(Mats.MAT_SODIUM, EnumICFFuel.SODIUM);
        fluidMap.put(Fluids.CHLORINE, EnumICFFuel.CHLORINE);
        materialMap.put(Mats.MAT_CALCIUM, EnumICFFuel.CALCIUM);
    }

    public ItemICFPellet() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(ItemICFPellet.setup(EnumICFFuel.DEUTERIUM, EnumICFFuel.TRITIUM, false));
        list.add(ItemICFPellet.setup(EnumICFFuel.HELIUM3, EnumICFFuel.HELIUM4, false));
        list.add(ItemICFPellet.setup(EnumICFFuel.LITHIUM, EnumICFFuel.OXYGEN, false));
        list.add(ItemICFPellet.setup(EnumICFFuel.SODIUM, EnumICFFuel.CHLORINE, true));
        list.add(ItemICFPellet.setup(EnumICFFuel.BERYLLIUM, EnumICFFuel.CALCIUM, true));
    }

    public static long getMaxDepletion(ItemStack stack) {
        long base = 50000000000L;
        base = (long)((double)base / ItemICFPellet.getType((ItemStack)stack, (boolean)true).depletionSpeed);
        base = (long)((double)base / ItemICFPellet.getType((ItemStack)stack, (boolean)false).depletionSpeed);
        return base;
    }

    public static long getFusingDifficulty(ItemStack stack) {
        long base = 10000000L;
        base = (long)((double)base * (ItemICFPellet.getType((ItemStack)stack, (boolean)true).fusingDifficulty * ItemICFPellet.getType((ItemStack)stack, (boolean)false).fusingDifficulty));
        if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("muon")) {
            base /= 4L;
        }
        return base;
    }

    public static long getDepletion(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0L;
        }
        return stack.field_77990_d.func_74763_f("depletion");
    }

    public static long react(ItemStack stack, long heat) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74772_a("depletion", stack.field_77990_d.func_74763_f("depletion") + heat);
        return (long)((double)heat * ItemICFPellet.getType((ItemStack)stack, (boolean)true).reactionMult * ItemICFPellet.getType((ItemStack)stack, (boolean)false).reactionMult);
    }

    public static ItemStack setup(EnumICFFuel type1, EnumICFFuel type2, boolean muon) {
        return ItemICFPellet.setup(new ItemStack(ModItems.icf_pellet), type1, type2, muon);
    }

    public static ItemStack setup(ItemStack stack, EnumICFFuel type1, EnumICFFuel type2, boolean muon) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74774_a("type1", (byte)type1.ordinal());
        stack.field_77990_d.func_74774_a("type2", (byte)type2.ordinal());
        stack.field_77990_d.func_74757_a("muon", muon);
        return stack;
    }

    public static EnumICFFuel getType(ItemStack stack, boolean first) {
        if (!stack.func_77942_o()) {
            return first ? EnumICFFuel.DEUTERIUM : EnumICFFuel.TRITIUM;
        }
        return (EnumICFFuel)((Object)EnumUtil.grabEnumSafely(EnumICFFuel.class, stack.field_77990_d.func_74771_c("type" + (first ? 1 : 2))));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemICFPellet.getDepletion(stack) / (double)ItemICFPellet.getMaxDepletion(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.iconBG = reg.func_94245_a("hbm:icf_pellet_bg");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        return pass == 1 ? super.func_77618_c(meta, pass) : this.iconBG;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass == 0) {
            EnumICFFuel type1 = ItemICFPellet.getType(stack, true);
            EnumICFFuel type2 = ItemICFPellet.getType(stack, false);
            int r = (((type1.color & 0xFF0000) >> 16) + ((type2.color & 0xFF0000) >> 16)) / 2;
            int g = (((type1.color & 0xFF00) >> 8) + ((type2.color & 0xFF00) >> 8)) / 2;
            int b = ((type1.color & 0xFF) + (type2.color & 0xFF)) / 2;
            return r << 16 | g << 8 | b;
        }
        return 0xFFFFFF;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        boolean muon = stack.func_77942_o() && stack.field_77990_d.func_74767_n("muon");
        list.add(EnumChatFormatting.GREEN + "Depletion: " + String.format(Locale.US, "%.1f", this.getDurabilityForDisplay(stack) * 100.0) + "%");
        list.add(EnumChatFormatting.YELLOW + "Fuel: " + I18nUtil.resolveKey("icffuel." + ItemICFPellet.getType(stack, true).name().toLowerCase(Locale.US), new Object[0]) + " / " + I18nUtil.resolveKey("icffuel." + ItemICFPellet.getType(stack, false).name().toLowerCase(Locale.US), new Object[0]));
        list.add(EnumChatFormatting.YELLOW + "Heat required: " + BobMathUtil.getShortNumber(ItemICFPellet.getFusingDifficulty(stack)) + "TU");
        list.add(EnumChatFormatting.YELLOW + "Reactivity multiplier: x" + (double)((int)(ItemICFPellet.getType((ItemStack)stack, (boolean)true).reactionMult * ItemICFPellet.getType((ItemStack)stack, (boolean)false).reactionMult * 100.0)) / 100.0);
        if (muon) {
            list.add(EnumChatFormatting.DARK_AQUA + "Muon catalyzed!");
        }
    }

    public static enum EnumICFFuel {
        HYDROGEN(0x4040FF, 1.0, 0.85, 1.0),
        DEUTERIUM(2631883, 1.25, 1.0, 1.0),
        TRITIUM(146, 1.5, 1.0, 1.05),
        HELIUM3(0xFFF09F, 1.75, 1.0, 1.25),
        HELIUM4(16751456, 2.0, 1.0, 1.5),
        LITHIUM(0xE9E9E9, 1.25, 0.85, 2.0),
        BERYLLIUM(10984832, 2.0, 1.0, 2.5),
        BORON(6913929, 3.0, 0.5, 3.5),
        CARBON(0x454545, 2.0, 1.0, 5.0),
        OXYGEN(11854591, 1.25, 1.5, 7.5),
        SODIUM(14673127, 3.0, 0.75, 8.75),
        CHLORINE(14345624, 2.5, 1.0, 10.0),
        CALCIUM(13813673, 3.0, 1.0, 12.5);

        public int color;
        public double reactionMult;
        public double depletionSpeed;
        public double fusingDifficulty;

        private EnumICFFuel(int color, double react, double depl, double laser) {
            this.color = color;
            this.reactionMult = react;
            this.depletionSpeed = depl;
            this.fusingDifficulty = laser;
        }
    }
}

