/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.network.BlockConveyorBase;
import com.hbm.blocks.network.BlockConveyorBendable;
import com.hbm.blocks.network.BlockCraneBase;
import com.hbm.main.MainRegistry;
import com.hbm.render.util.RenderOverhead;
import com.hbm.util.I18nUtil;
import com.hbm.wiaj.WorldInAJar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import org.lwjgl.input.Keyboard;

public class ItemConveyorWand
extends Item
implements ILookOverlay {
    private static MovingObjectPosition lastMop;
    private static int lastSide;
    private static float lastYaw;

    public ItemConveyorWand() {
        this.func_77627_a(true);
    }

    public static ConveyorType getType(ItemStack stack) {
        if (stack == null) {
            return ConveyorType.REGULAR;
        }
        return ConveyorType.values()[stack.func_77960_j()];
    }

    public static Block getConveyorBlock(ConveyorType type) {
        switch (type) {
            case EXPRESS: {
                return ModBlocks.conveyor_express;
            }
            case DOUBLE: {
                return ModBlocks.conveyor_double;
            }
            case TRIPLE: {
                return ModBlocks.conveyor_triple;
            }
        }
        return ModBlocks.conveyor;
    }

    public static boolean hasSnakesAndLadders(ConveyorType type) {
        return type == ConveyorType.REGULAR;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (ConveyorType type : ConveyorType.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + ItemConveyorWand.getType(stack).name().toLowerCase(Locale.US);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        if (Keyboard.isKeyDown((int)42)) {
            for (String s : I18nUtil.resolveKeyArray(super.func_77667_c(stack) + ".desc", new Object[0])) {
                list.add(EnumChatFormatting.YELLOW + s);
            }
            if (ItemConveyorWand.hasSnakesAndLadders(ItemConveyorWand.getType(stack))) {
                list.add(EnumChatFormatting.AQUA + I18nUtil.resolveKey(super.func_77667_c(stack) + ".vertical.desc", new Object[0]));
            }
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "Hold <" + EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + "LSHIFT" + EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "> to display more info");
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float fx, float fy, float fz) {
        NBTTagCompound nbt;
        if (player.func_70093_af() && !stack.func_77942_o()) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            Block onBlock = world.func_147439_a(x, y, z);
            int onMeta = world.func_72805_g(x, y, z);
            ConveyorType type = ItemConveyorWand.getType(stack);
            if (ItemConveyorWand.hasSnakesAndLadders(type) && onBlock == ModBlocks.conveyor && onMeta < 6) {
                if (dir == ForgeDirection.UP) {
                    onBlock = ModBlocks.conveyor_lift;
                    world.func_147465_d(x, y, z, onBlock, onMeta, 3);
                } else if (dir == ForgeDirection.DOWN) {
                    onBlock = ModBlocks.conveyor_chute;
                    world.func_147465_d(x, y, z, onBlock, onMeta, 3);
                }
            }
            Block toPlace = ItemConveyorWand.getConveyorBlock(type);
            if (ItemConveyorWand.hasSnakesAndLadders(type)) {
                if (onBlock == ModBlocks.conveyor_lift && dir == ForgeDirection.UP) {
                    toPlace = ModBlocks.conveyor_lift;
                }
                if (onBlock == ModBlocks.conveyor_chute && dir == ForgeDirection.DOWN) {
                    toPlace = ModBlocks.conveyor_chute;
                }
            }
            if (world.func_147439_a(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ).isReplaceable((IBlockAccess)world, x, y, z)) {
                world.func_147449_b(x, y, z, toPlace);
                toPlace.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
                --stack.field_77994_a;
            }
            return true;
        }
        Block onBlock = world.func_147439_a(x, y, z);
        if (onBlock instanceof BlockConveyorBendable) {
            BlockConveyorBase bendable = (BlockConveyorBase)onBlock;
            ForgeDirection moveDir = stack.func_77942_o() ? bendable.getInputDirection(world, x, y, z) : bendable.getOutputDirection(world, x, y, z);
            int ox = x + moveDir.offsetX;
            int oy = y + moveDir.offsetY;
            int oz = z + moveDir.offsetZ;
            if (world.func_147439_a(ox, oy, oz).isReplaceable((IBlockAccess)world, ox, oy, oz)) {
                side = moveDir.ordinal();
            }
        }
        if (!stack.func_77942_o()) {
            nbt = stack.field_77990_d = new NBTTagCompound();
            nbt.func_74768_a("x", x);
            nbt.func_74768_a("y", y);
            nbt.func_74768_a("z", z);
            nbt.func_74768_a("side", side);
            int count = 0;
            if (player.field_71075_bZ.field_75098_d) {
                count = 256;
            } else {
                for (ItemStack inventoryStack : player.field_71071_by.field_70462_a) {
                    if (inventoryStack == null || inventoryStack.func_77973_b() != this || inventoryStack.func_77960_j() != stack.func_77960_j()) continue;
                    count += inventoryStack.field_77994_a;
                }
            }
            nbt.func_74768_a("count", count);
        } else {
            nbt = stack.field_77990_d;
            int sx = nbt.func_74762_e("x");
            int sy = nbt.func_74762_e("y");
            int sz = nbt.func_74762_e("z");
            int sSide = nbt.func_74762_e("side");
            int count = nbt.func_74762_e("count");
            if (!world.field_72995_K) {
                ConveyorType type = ItemConveyorWand.getType(stack);
                int constructCount = ItemConveyorWand.construct(world, null, type, player, sx, sy, sz, sSide, x, y, z, side, 0, 0, 0, count);
                if (constructCount > 0) {
                    int toRemove = ItemConveyorWand.construct(world, (IBlockAccess)world, type, player, sx, sy, sz, sSide, x, y, z, side, 0, 0, 0, count);
                    if (!player.field_71075_bZ.field_75098_d) {
                        for (ItemStack inventoryStack : player.field_71071_by.field_70462_a) {
                            if (inventoryStack != null && inventoryStack.func_77973_b() == this && inventoryStack.func_77960_j() == stack.func_77960_j()) {
                                int removing = Math.min(toRemove, inventoryStack.field_77994_a);
                                inventoryStack.field_77994_a -= removing;
                                toRemove -= removing;
                            }
                            if (toRemove <= 0) break;
                        }
                        player.field_71069_bz.func_75142_b();
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText("Conveyor built!"));
                } else if (constructCount == 0) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Not enough conveyors, build cancelled"));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Conveyor obstructed, build cancelled"));
                }
            } else {
                RenderOverhead.clearActionPreview();
                lastMop = null;
            }
            stack.field_77990_d = null;
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean inHand) {
        ItemStack held;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!inHand && stack.func_77942_o() && ((held = player.func_70694_bm()) == null || held.func_77973_b() != this || held.func_77960_j() != stack.func_77960_j())) {
            stack.field_77990_d = null;
            if (world.field_72995_K) {
                RenderOverhead.clearActionPreview();
                lastMop = null;
            }
        }
        if (world.field_72995_K && inHand) {
            if (!stack.func_77942_o()) {
                RenderOverhead.clearActionPreview();
                lastMop = null;
                return;
            }
            MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
            if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                RenderOverhead.clearActionPreview();
                lastMop = null;
                return;
            }
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            int side = mop.field_72310_e;
            Block onBlock = world.func_147439_a(x, y, z);
            if (onBlock instanceof BlockConveyorBendable) {
                BlockConveyorBase bendable = (BlockConveyorBase)onBlock;
                ForgeDirection moveDir = bendable.getInputDirection(world, x, y, z);
                int ox = x + moveDir.offsetX;
                int oy = y + moveDir.offsetY;
                int oz = z + moveDir.offsetZ;
                if (world.func_147439_a(ox, oy, oz).isReplaceable((IBlockAccess)world, ox, oy, oz)) {
                    side = moveDir.ordinal();
                }
            }
            if (lastMop != null && mop.field_72311_b == ItemConveyorWand.lastMop.field_72311_b && mop.field_72312_c == ItemConveyorWand.lastMop.field_72312_c && mop.field_72309_d == ItemConveyorWand.lastMop.field_72309_d && side == lastSide && Math.abs(lastYaw - player.field_70177_z) < 15.0f) {
                return;
            }
            lastMop = mop;
            lastYaw = player.field_70177_z;
            lastSide = side;
            NBTTagCompound nbt = stack.field_77990_d;
            int sx = nbt.func_74762_e("x");
            int sy = nbt.func_74762_e("y");
            int sz = nbt.func_74762_e("z");
            int sSide = nbt.func_74762_e("side");
            int count = nbt.func_74762_e("count");
            int sizeX = Math.abs(sx - x) + 3;
            int sizeY = Math.abs(sy - y) + 3;
            int sizeZ = Math.abs(sz - z) + 3;
            int minX = Math.min(sx, x) - 1;
            int minY = Math.min(sy, y) - 1;
            int minZ = Math.min(sz, z) - 1;
            WorldInAJar wiaj = new WorldInAJar(sizeX, sizeY, sizeZ);
            boolean pathSuccess = ItemConveyorWand.construct(world, wiaj, ItemConveyorWand.getType(stack), player, sx, sy, sz, sSide, x, y, z, side, minX, minY, minZ, count) > 0;
            RenderOverhead.setActionPreview(wiaj, minX, minY, minZ, pathSuccess);
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer playerEntity) {
        if (!playerEntity.func_70093_af()) {
            return false;
        }
        World world = playerEntity.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        if (!playerEntity.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        if (!world.field_72995_K && block instanceof BlockConveyorBase) {
            BlockConveyorBase conveyor = (BlockConveyorBase)block;
            ForgeDirection input = conveyor.getInputDirection(world, x, y, z);
            ForgeDirection output = conveyor.getOutputDirection(world, x, y, z);
            this.breakExtra(world, player, x + input.offsetX, y + input.offsetY, z + input.offsetZ, 32);
            this.breakExtra(world, player, x + output.offsetX, y + output.offsetY, z + output.offsetZ, 32);
        }
        return false;
    }

    private void breakExtra(World world, EntityPlayerMP player, int x, int y, int z, int depth) {
        if (--depth <= 0) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!(block instanceof BlockConveyorBase)) {
            return;
        }
        BlockConveyorBase conveyor = (BlockConveyorBase)block;
        ForgeDirection input = conveyor.getInputDirection(world, x, y, z);
        ForgeDirection output = conveyor.getOutputDirection(world, x, y, z);
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
        if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, false)) {
            block.func_149664_b(world, x, y, z, meta);
        }
        player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        this.breakExtra(world, player, x + input.offsetX, y + input.offsetY, z + input.offsetZ, depth);
        this.breakExtra(world, player, x + output.offsetX, y + output.offsetY, z + output.offsetZ, depth);
    }

    private static int construct(World routeWorld, IBlockAccess buildWorld, ConveyorType type, EntityPlayer player, int x1, int y1, int z1, int side1, int x2, int y2, int z2, int side2, int box, int boy, int boz, int max) {
        ForgeDirection horDir;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side1);
        ForgeDirection targetDir = ForgeDirection.getOrientation((int)side2);
        if (x1 == x2 && y1 == y2 && z1 == z2 && side1 == side2 && (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN)) {
            int meta = ItemConveyorWand.getFacingMeta(player);
            if (!routeWorld.func_147439_a(x1, y1 += dir.offsetY, z1).isReplaceable((IBlockAccess)routeWorld, x1, y1, z1)) {
                return -1;
            }
            Block block = ItemConveyorWand.getConveyorBlock(type);
            if (buildWorld instanceof World) {
                ((World)buildWorld).func_147465_d(x1 - box, y1 - boy, z1 - boz, block, meta, 3);
            } else if (buildWorld instanceof WorldInAJar) {
                ((WorldInAJar)buildWorld).setBlock(x1 - box, y1 - boy, z1 - boz, block, meta);
            }
            return 1;
        }
        boolean hasVertical = ItemConveyorWand.hasSnakesAndLadders(type);
        int tx = x2 + targetDir.offsetX;
        int ty = y2 + targetDir.offsetY;
        int tz = z2 + targetDir.offsetZ;
        int x = x1 + dir.offsetX;
        int y = y1 + dir.offsetY;
        int z = z1 + dir.offsetZ;
        if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) {
            dir = ItemConveyorWand.getTargetDirection(x, y, z, x2, y2, z2, hasVertical);
        }
        Block targetBlock = routeWorld.func_147439_a(x2, y2, z2);
        boolean isTargetHorizontal = targetDir != ForgeDirection.UP && targetDir != ForgeDirection.DOWN;
        boolean shouldTurnToTarget = isTargetHorizontal || targetBlock instanceof BlockCraneBase || targetBlock == ModBlocks.conveyor_lift || targetBlock == ModBlocks.conveyor_chute;
        ForgeDirection forgeDirection = horDir = dir == ForgeDirection.UP || dir == ForgeDirection.DOWN ? ForgeDirection.getOrientation((int)ItemConveyorWand.getFacingMeta(player)).getOpposite() : dir;
        if (hasVertical && y > ty && routeWorld.func_147439_a(x, y - 1, z).isReplaceable((IBlockAccess)routeWorld, x, y - 1, z)) {
            dir = ForgeDirection.DOWN;
        }
        for (int loopDepth = 1; loopDepth <= max; ++loopDepth) {
            boolean shouldTurn;
            if (!routeWorld.func_147439_a(x, y, z).isReplaceable((IBlockAccess)routeWorld, x, y, z)) {
                return -1;
            }
            Block block = ItemConveyorWand.getConveyorForDirection(type, dir);
            int meta = ItemConveyorWand.getConveyorMetaForDirection(block, dir, targetDir, horDir);
            int ox = x + dir.offsetX;
            int oy = y + dir.offsetY;
            int oz = z + dir.offsetZ;
            int fromDistance = ItemConveyorWand.taxiDistance(x, y, z, tx, ty, tz);
            int toDistance = ItemConveyorWand.taxiDistance(ox, oy, oz, tx, ty, tz);
            int finalDistance = ItemConveyorWand.taxiDistance(ox, oy, oz, x2, y2, z2);
            boolean notAtTarget = (shouldTurnToTarget ? finalDistance : fromDistance) > 0;
            boolean willBeObstructed = notAtTarget && !routeWorld.func_147439_a(ox, oy, oz).isReplaceable((IBlockAccess)routeWorld, ox, oy, oz);
            boolean bl = shouldTurn = toDistance >= fromDistance && notAtTarget || willBeObstructed;
            if (shouldTurn) {
                ForgeDirection newDir = ItemConveyorWand.getTargetDirection(x, y, z, shouldTurnToTarget ? x2 : tx, shouldTurnToTarget ? y2 : ty, shouldTurnToTarget ? z2 : tz, tx, ty, tz, dir, willBeObstructed, hasVertical);
                if (newDir == ForgeDirection.UP) {
                    block = ModBlocks.conveyor_lift;
                } else if (newDir == ForgeDirection.DOWN) {
                    block = ModBlocks.conveyor_chute;
                } else if (dir.getRotation(ForgeDirection.UP) == newDir) {
                    meta += 8;
                } else if (dir.getRotation(ForgeDirection.DOWN) == newDir) {
                    meta += 4;
                }
                dir = newDir;
                if (dir != ForgeDirection.UP && dir != ForgeDirection.DOWN) {
                    horDir = dir;
                }
            }
            if (buildWorld instanceof World) {
                ((World)buildWorld).func_147465_d(x - box, y - boy, z - boz, block, meta, 3);
            } else if (buildWorld instanceof WorldInAJar) {
                ((WorldInAJar)buildWorld).setBlock(x - box, y - boy, z - boz, block, meta);
            }
            if (x == tx && y == ty && z == tz) {
                return loopDepth;
            }
            x += dir.offsetX;
            y += dir.offsetY;
            z += dir.offsetZ;
        }
        return 0;
    }

    private static int getFacingMeta(EntityPlayer player) {
        int meta = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (meta) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 2;
    }

    private static int getConveyorMetaForDirection(Block block, ForgeDirection dir, ForgeDirection targetDir, ForgeDirection horDir) {
        if (block != ModBlocks.conveyor_chute && block != ModBlocks.conveyor_lift) {
            return dir.getOpposite().ordinal();
        }
        if (targetDir == ForgeDirection.UP || targetDir == ForgeDirection.DOWN) {
            return horDir.getOpposite().ordinal();
        }
        return targetDir.ordinal();
    }

    private static Block getConveyorForDirection(ConveyorType type, ForgeDirection dir) {
        if (dir == ForgeDirection.UP) {
            return ModBlocks.conveyor_lift;
        }
        if (dir == ForgeDirection.DOWN) {
            return ModBlocks.conveyor_chute;
        }
        return ItemConveyorWand.getConveyorBlock(type);
    }

    private static ForgeDirection getTargetDirection(int x1, int y1, int z1, int x2, int y2, int z2, boolean hasVertical) {
        return ItemConveyorWand.getTargetDirection(x1, y1, z1, x2, y2, z2, x2, y2, z2, null, false, hasVertical);
    }

    private static ForgeDirection getTargetDirection(int x1, int y1, int z1, int x2, int y2, int z2, int tx, int ty, int tz, ForgeDirection heading, boolean willBeObstructed, boolean hasVertical) {
        if (hasVertical && (y1 != y2 || y1 != ty) && (willBeObstructed || x1 == x2 && z1 == z2 || x1 == tx && z1 == tz)) {
            return y1 > y2 ? ForgeDirection.DOWN : ForgeDirection.UP;
        }
        if (Math.abs(x1 - x2) > Math.abs(z1 - z2)) {
            if (heading == ForgeDirection.EAST || heading == ForgeDirection.WEST) {
                return z1 > z2 ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
            }
            return x1 > x2 ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        if (heading == ForgeDirection.NORTH || heading == ForgeDirection.SOUTH) {
            return x1 > x2 ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        return z1 > z2 ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
    }

    private static int taxiDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        return Math.abs(x1 - x2) + Math.abs(y1 - y2) + Math.abs(z1 - z2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        EntityPlayer player = MainRegistry.proxy.me();
        if (player == null || !player.func_70093_af() || !player.field_71075_bZ.field_75098_d) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockConveyorBase) {
            ArrayList<String> text = new ArrayList<String>();
            text.add("Break whole conveyor line");
            ILookOverlay.printGeneric(event, I18nUtil.resolveKey(block.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
        }
    }

    public static enum ConveyorType {
        REGULAR,
        EXPRESS,
        DOUBLE,
        TRIPLE;

    }
}

