/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.entity.projectile.EntityChemical;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.GunAnimationPacket;
import com.hbm.render.anim.HbmAnimations;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemCryoCannon
extends ItemGunBase {
    public ItemCryoCannon(GunConfiguration config) {
        super(config);
    }

    @Override
    protected void fire(ItemStack stack, World world, EntityPlayer player) {
        if (ItemCryoCannon.getPressure(stack) >= 1000) {
            return;
        }
        if (ItemCryoCannon.getTurbine(stack) < 100) {
            return;
        }
        BulletConfiguration config = null;
        config = this.mainConfig.reloadType == 0 ? ItemCryoCannon.getBeltCfg(player, stack, true) : BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemCryoCannon.getMagType(stack)));
        int bullets = config.bulletsMin;
        for (int k = 0; k < this.mainConfig.roundsPerCycle && this.hasAmmo(stack, player, true); ++k) {
            if (config.bulletsMax > config.bulletsMin) {
                bullets += world.field_73012_v.nextInt(config.bulletsMax - config.bulletsMin);
            }
            for (int i = 0; i < bullets; ++i) {
                this.spawnProjectile(world, player, stack, BulletConfigSyncingUtil.getKey(config));
            }
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.wrapper.sendTo(new GunAnimationPacket(HbmAnimations.AnimType.CYCLE.ordinal()), (EntityPlayerMP)player);
            }
            this.useUpAmmo(player, stack, true);
            player.field_71069_bz.func_75142_b();
            int wear = (int)Math.ceil((float)config.wear / (1.0f + (float)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack)));
            ItemCryoCannon.setItemWear(stack, ItemCryoCannon.getItemWear(stack) + wear);
        }
        world.func_72956_a((Entity)player, this.mainConfig.firingSound, this.mainConfig.firingVolume, this.mainConfig.firingPitch);
        if (this.mainConfig.ejector != null && !this.mainConfig.ejector.getAfterReload()) {
            ItemCryoCannon.queueCasing((Entity)player, this.mainConfig.ejector, config, stack);
        }
    }

    @Override
    protected void spawnProjectile(World world, EntityPlayer player, ItemStack stack, int config) {
        EntityChemical chem = new EntityChemical(world, (EntityLivingBase)player, 0.0, 0.0, 0.0);
        chem.setFluid(Fluids.OXYGEN);
        world.func_72838_d((Entity)chem);
        int pressure = ItemCryoCannon.getPressure(stack);
        pressure += 5;
        pressure = MathHelper.func_76125_a((int)pressure, (int)0, (int)1000);
        ItemCryoCannon.setPressure(stack, pressure);
    }

    @Override
    protected void updateServer(ItemStack stack, World world, EntityPlayer player, int slot, boolean isCurrentItem) {
        int turbine = ItemCryoCannon.getTurbine(stack);
        int pressure = ItemCryoCannon.getPressure(stack);
        if (ItemCryoCannon.getIsMouseDown(stack)) {
            turbine += 10;
        } else {
            turbine -= 5;
            pressure -= 5;
        }
        turbine = MathHelper.func_76125_a((int)turbine, (int)0, (int)100);
        pressure = MathHelper.func_76125_a((int)pressure, (int)0, (int)1000);
        ItemCryoCannon.setTurbine(stack, turbine);
        ItemCryoCannon.setPressure(stack, pressure);
        super.updateServer(stack, world, player, slot, isCurrentItem);
    }

    public static void setTurbine(ItemStack stack, int i) {
        ItemCryoCannon.writeNBT(stack, "turbine", i);
    }

    public static int getTurbine(ItemStack stack) {
        return ItemCryoCannon.readNBT(stack, "turbine");
    }

    public static void setPressure(ItemStack stack, int i) {
        ItemCryoCannon.writeNBT(stack, "pressure", i);
    }

    public static int getPressure(ItemStack stack) {
        return ItemCryoCannon.readNBT(stack, "pressure");
    }
}

