/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.bomb.BlockDetonatable;
import com.hbm.entity.projectile.EntityBulletBaseMK4;
import com.hbm.entity.projectile.EntityBulletBeamBase;
import com.hbm.interfaces.NotableComments;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.DamageSourceSednaNoAttacker;
import com.hbm.items.weapon.sedna.DamageSourceSednaWithAttacker;
import com.hbm.items.weapon.sedna.factory.ConfettiUtil;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import com.hbm.particle.SpentCasing;
import com.hbm.util.BobMathUtil;
import com.hbm.util.DamageResistanceHandler;
import com.hbm.util.EntityDamageUtil;
import com.hbm.util.TrackerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

@NotableComments
public class BulletConfig
implements Cloneable {
    public static List<BulletConfig> configs = new ArrayList<BulletConfig>();
    public int id;
    public RecipesCommon.ComparableStack ammo;
    public ItemStack casingItem;
    public int casingAmount;
    public int ammoReloadCount = 1;
    public float velocity = 10.0f;
    public float spread = 0.0f;
    public float wear = 1.0f;
    public int projectilesMin = 1;
    public int projectilesMax = 1;
    public ProjectileType pType = ProjectileType.BULLET;
    public float damageMult = 1.0f;
    public float armorThresholdNegation = 0.0f;
    public float armorPiercingPercent = 0.0f;
    public float knockbackMult = 0.1f;
    public float headshotMult = 1.25f;
    public DamageResistanceHandler.DamageClass dmgClass = DamageResistanceHandler.DamageClass.PHYSICAL;
    public float ricochetAngle = 5.0f;
    public int maxRicochetCount = 2;
    public boolean damageFalloffByPen = true;
    public Consumer<Entity> onUpdate;
    public BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> onImpact;
    public BiConsumer<EntityBulletBeamBase, MovingObjectPosition> onImpactBeam;
    public BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> onRicochet = LAMBDA_STANDARD_RICOCHET;
    public BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> onEntityHit = LAMBDA_STANDARD_ENTITY_HIT;
    public double gravity = 0.0;
    public int expires = 30;
    public boolean impactsEntities = true;
    public boolean doesPenetrate = false;
    public boolean isSpectral = false;
    public int selfDamageDelay = 2;
    public boolean blackPowder = false;
    public boolean renderRotations = true;
    public SpentCasing casing;
    public BiConsumer<EntityBulletBaseMK4, Float> renderer;
    public BiConsumer<EntityBulletBeamBase, Float> rendererBeam;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_RICOCHET = (bullet, mop) -> {
        MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block b = bullet.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (b.func_149688_o() == Material.field_151592_s) {
                bullet.field_70170_p.func_147480_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, false);
                bullet.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
                return;
            }
            if (b instanceof BlockDetonatable) {
                ((BlockDetonatable)b).onShot(bullet.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            }
            if (b == ModBlocks.deco_crt) {
                int meta = bullet.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                bullet.field_70170_p.func_72921_c(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, meta % 4 + 4, 3);
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
            Vec3 face = Vec3.func_72443_a((double)dir.offsetX, (double)dir.offsetY, (double)dir.offsetZ);
            Vec3 vel = Vec3.func_72443_a((double)bullet.field_70159_w, (double)bullet.field_70181_x, (double)bullet.field_70179_y).func_72432_b();
            double angle = Math.abs(BobMathUtil.getCrossAngle(vel, face) - 90.0);
            if (angle <= (double)bullet.config.ricochetAngle) {
                ++bullet.ricochets;
                if (bullet.ricochets > bullet.config.maxRicochetCount) {
                    bullet.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
                    bullet.func_70106_y();
                }
                switch (mop.field_72310_e) {
                    case 0: 
                    case 1: {
                        bullet.field_70181_x *= -1.0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        bullet.field_70179_y *= -1.0;
                        break;
                    }
                    case 4: 
                    case 5: {
                        bullet.field_70159_w *= -1.0;
                    }
                }
                bullet.field_70170_p.func_72956_a((Entity)bullet, "hbm:weapon.ricochet", 0.25f, 1.0f);
                bullet.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
                if (bullet.field_70170_p instanceof WorldServer) {
                    TrackerUtil.sendTeleport((World)((WorldServer)bullet.field_70170_p), bullet);
                }
                return;
            }
            bullet.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
            bullet.func_70106_y();
        }
    };
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_ENTITY_HIT = (bullet, mop) -> {
        MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            EntityLivingBase living;
            Entity entity = mop.field_72308_g;
            if (entity == bullet.getThrower() && bullet.field_70173_aa < bullet.selfDamageDelay()) {
                return;
            }
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110143_aJ() <= 0.0f) {
                return;
            }
            BulletConfig cfr_ignored_1 = bullet.config;
            DamageSource source = BulletConfig.getDamage(bullet, bullet.getThrower(), bullet.config.dmgClass);
            float intendedDamage = bullet.damage;
            if (!(entity instanceof EntityLivingBase)) {
                EntityDamageUtil.attackEntityFromIgnoreIFrame(entity, source, bullet.damage);
                return;
            }
            if (bullet.config.headshotMult > 1.0f) {
                living = (EntityLivingBase)entity;
                double head = living.field_70131_O - living.func_70047_e();
                if (living.func_70089_S() && mop.field_72307_f != null && mop.field_72307_f.field_72448_b > living.field_70163_u + (double)living.field_70131_O - head * 2.0) {
                    intendedDamage *= bullet.config.headshotMult;
                }
            }
            living = (EntityLivingBase)entity;
            float prevHealth = living.func_110143_aJ();
            EntityDamageUtil.attackEntityFromNT(living, source, intendedDamage, true, true, bullet.config.knockbackMult, bullet.config.armorThresholdNegation, bullet.config.armorPiercingPercent);
            float newHealth = living.func_110143_aJ();
            if (bullet.config.damageFalloffByPen) {
                bullet.damage = (float)((double)bullet.damage - (double)Math.max(prevHealth - newHealth, 0.0f) * 0.5);
            }
            if (!bullet.doesPenetrate() || bullet.damage < 0.0f) {
                bullet.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
                bullet.func_70106_y();
            }
            if (!living.func_70089_S()) {
                ConfettiUtil.decideConfetti(living, source);
            }
        }
    };
    public static BiConsumer<EntityBulletBeamBase, MovingObjectPosition> LAMBDA_STANDARD_BEAM_HIT = (bullet, mop) -> {
        MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            Entity entity = mop.field_72308_g;
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110143_aJ() <= 0.0f) {
                return;
            }
            BulletConfig cfr_ignored_1 = bullet.config;
            DamageSource source = BulletConfig.getDamage(bullet, bullet.getThrower(), bullet.config.dmgClass);
            if (!(entity instanceof EntityLivingBase)) {
                EntityDamageUtil.attackEntityFromIgnoreIFrame(entity, source, bullet.damage);
                return;
            }
            EntityLivingBase living = (EntityLivingBase)entity;
            EntityDamageUtil.attackEntityFromNT(living, source, bullet.damage, true, true, bullet.config.knockbackMult, bullet.config.armorThresholdNegation, bullet.config.armorPiercingPercent);
            if (!living.func_70089_S()) {
                ConfettiUtil.decideConfetti(living, source);
            }
        }
    };
    public static BiConsumer<EntityBulletBeamBase, MovingObjectPosition> LAMBDA_BEAM_HIT = (beam, mop) -> {
        MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            Entity entity = mop.field_72308_g;
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110143_aJ() <= 0.0f) {
                return;
            }
            BulletConfig cfr_ignored_1 = beam.config;
            DamageSource source = BulletConfig.getDamage(beam, beam.thrower, beam.config.dmgClass);
            if (!(entity instanceof EntityLivingBase)) {
                EntityDamageUtil.attackEntityFromIgnoreIFrame(entity, source, beam.damage);
                return;
            }
            EntityLivingBase living = (EntityLivingBase)entity;
            EntityDamageUtil.attackEntityFromNT(living, source, beam.damage, true, false, beam.config.knockbackMult, beam.config.armorThresholdNegation, beam.config.armorPiercingPercent);
        }
    };

    public BulletConfig() {
        this.id = configs.size();
        configs.add(this);
    }

    public BulletConfig forceReRegister() {
        this.id = configs.size();
        configs.add(this);
        return this;
    }

    public BulletConfig setBeam() {
        this.pType = ProjectileType.BEAM;
        return this;
    }

    public BulletConfig setChunkloading() {
        this.pType = ProjectileType.BULLET_CHUNKLOADING;
        return this;
    }

    public BulletConfig setItem(Item ammo) {
        this.ammo = new RecipesCommon.ComparableStack(ammo);
        return this;
    }

    public BulletConfig setItem(ItemStack ammo) {
        this.ammo = new RecipesCommon.ComparableStack(ammo);
        return this;
    }

    public BulletConfig setItem(RecipesCommon.ComparableStack ammo) {
        this.ammo = ammo;
        return this;
    }

    public BulletConfig setItem(GunFactory.EnumAmmo ammo) {
        this.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_standard, 1, ammo.ordinal());
        return this;
    }

    public BulletConfig setItem(GunFactory.EnumAmmoSecret ammo) {
        this.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_secret, 1, ammo.ordinal());
        return this;
    }

    public BulletConfig setCasing(ItemStack item, int amount) {
        this.casingItem = item;
        this.casingAmount = amount;
        return this;
    }

    public BulletConfig setCasing(ItemEnums.EnumCasingType item, int amount) {
        this.casingItem = OreDictManager.DictFrame.fromOne(ModItems.casing, (Enum)item);
        this.casingAmount = amount;
        return this;
    }

    public BulletConfig setReloadCount(int ammoReloadCount) {
        this.ammoReloadCount = ammoReloadCount;
        return this;
    }

    public BulletConfig setVel(float velocity) {
        this.velocity = velocity;
        return this;
    }

    public BulletConfig setSpread(float spread) {
        this.spread = spread;
        return this;
    }

    public BulletConfig setWear(float wear) {
        this.wear = wear;
        return this;
    }

    public BulletConfig setProjectiles(int amount) {
        this.projectilesMin = this.projectilesMax = amount;
        return this;
    }

    public BulletConfig setProjectiles(int min, int max) {
        this.projectilesMin = min;
        this.projectilesMax = max;
        return this;
    }

    public BulletConfig setDamage(float damageMult) {
        this.damageMult = damageMult;
        return this;
    }

    public BulletConfig setThresholdNegation(float armorThresholdNegation) {
        this.armorThresholdNegation = armorThresholdNegation;
        return this;
    }

    public BulletConfig setArmorPiercing(float armorPiercingPercent) {
        this.armorPiercingPercent = armorPiercingPercent;
        return this;
    }

    public BulletConfig setKnockback(float knockbackMult) {
        this.knockbackMult = knockbackMult;
        return this;
    }

    public BulletConfig setHeadshot(float headshotMult) {
        this.headshotMult = headshotMult;
        return this;
    }

    public BulletConfig setupDamageClass(DamageResistanceHandler.DamageClass clazz) {
        this.dmgClass = clazz;
        return this;
    }

    public BulletConfig setRicochetAngle(float angle) {
        this.ricochetAngle = angle;
        return this;
    }

    public BulletConfig setRicochetCount(int count) {
        this.maxRicochetCount = count;
        return this;
    }

    public BulletConfig setDamageFalloutByPen(boolean falloff) {
        this.damageFalloffByPen = falloff;
        return this;
    }

    public BulletConfig setGrav(double gravity) {
        this.gravity = gravity;
        return this;
    }

    public BulletConfig setLife(int expires) {
        this.expires = expires;
        return this;
    }

    public BulletConfig setImpactsEntities(boolean impact) {
        this.impactsEntities = impact;
        return this;
    }

    public BulletConfig setDoesPenetrate(boolean pen) {
        this.doesPenetrate = pen;
        return this;
    }

    public BulletConfig setSpectral(boolean spectral) {
        this.isSpectral = spectral;
        return this;
    }

    public BulletConfig setSelfDamageDelay(int delay) {
        this.selfDamageDelay = delay;
        return this;
    }

    public BulletConfig setBlackPowder(boolean bp) {
        this.blackPowder = bp;
        return this;
    }

    public BulletConfig setRenderRotations(boolean rot) {
        this.renderRotations = rot;
        return this;
    }

    public BulletConfig setCasing(SpentCasing casing) {
        this.casing = casing;
        return this;
    }

    public BulletConfig setRenderer(BiConsumer<EntityBulletBaseMK4, Float> renderer) {
        this.renderer = renderer;
        return this;
    }

    public BulletConfig setRendererBeam(BiConsumer<EntityBulletBeamBase, Float> renderer) {
        this.rendererBeam = renderer;
        return this;
    }

    public BulletConfig setOnUpdate(Consumer<Entity> lambda) {
        this.onUpdate = lambda;
        return this;
    }

    public BulletConfig setOnRicochet(BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> lambda) {
        this.onRicochet = lambda;
        return this;
    }

    public BulletConfig setOnImpact(BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> lambda) {
        this.onImpact = lambda;
        return this;
    }

    public BulletConfig setOnBeamImpact(BiConsumer<EntityBulletBeamBase, MovingObjectPosition> lambda) {
        this.onImpactBeam = lambda;
        return this;
    }

    public BulletConfig setOnEntityHit(BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> lambda) {
        this.onEntityHit = lambda;
        return this;
    }

    public static DamageSource getDamage(Entity projectile, EntityLivingBase shooter, DamageResistanceHandler.DamageClass dmgClass) {
        DamageSourceSednaNoAttacker dmg = shooter != null ? new DamageSourceSednaWithAttacker(dmgClass.name(), projectile, (Entity)shooter) : new DamageSourceSednaNoAttacker(dmgClass.name());
        switch (dmgClass) {
            case PHYSICAL: {
                dmg.func_76349_b();
                break;
            }
            case FIRE: {
                dmg.func_76361_j();
                break;
            }
            case EXPLOSIVE: {
                dmg.func_94540_d();
                break;
            }
            case ELECTRIC: {
                break;
            }
            case LASER: {
                break;
            }
        }
        return dmg;
    }

    public BulletConfig clone() {
        try {
            BulletConfig clone = (BulletConfig)super.clone();
            clone.forceReRegister();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static enum ProjectileType {
        BULLET,
        BULLET_CHUNKLOADING,
        BEAM;

    }
}

