/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.impl;

import api.hbm.fluidmk2.IFillableItem;
import com.hbm.entity.projectile.EntityChemical;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.Receiver;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.render.anim.HbmAnimations;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;

public class ItemGunChemthrower
extends ItemGunBaseNT
implements IFillableItem {
    public static final int CONSUMPTION = 3;
    public static final int transferSpeed = 50;
    public static BiFunction<ItemStack, ItemGunBaseNT.LambdaContext, Boolean> LAMBDA_CAN_FIRE = (stack, ctx) -> ctx.config.getReceivers((ItemStack)stack)[0].getMagazine((ItemStack)stack).getAmount((ItemStack)stack, ctx.inventory) >= 3;
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_FIRE = (stack, ctx) -> {
        EntityLivingBase entity = ctx.entity;
        EntityPlayer player = ctx.getPlayer();
        int index = ctx.configIndex;
        ItemGunBaseNT.playAnimation(player, stack, HbmAnimations.AnimType.CYCLE, ctx.configIndex);
        Receiver primary = ctx.config.getReceivers((ItemStack)stack)[0];
        IMagazine mag = primary.getMagazine((ItemStack)stack);
        Vec3 offset = primary.getProjectileOffset((ItemStack)stack);
        double forwardOffset = offset.field_72450_a;
        double heightOffset = offset.field_72448_b;
        double sideOffset = offset.field_72449_c;
        EntityChemical chem = new EntityChemical(entity.field_70170_p, entity, sideOffset, heightOffset, forwardOffset);
        chem.setFluid((FluidType)mag.getType((ItemStack)stack, ctx.inventory));
        entity.field_70170_p.func_72838_d((Entity)chem);
        mag.useUpAmmo((ItemStack)stack, ctx.inventory, 3);
        ItemGunBaseNT.setWear(stack, index, Math.min(ItemGunBaseNT.getWear(stack, index) + 1.0f, ctx.config.getDurability((ItemStack)stack)));
    };

    public ItemGunChemthrower(ItemGunBaseNT.WeaponQuality quality, GunConfig ... cfg) {
        super(quality, cfg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        if (this.getFluidType(stack) == type) return true;
        if (ItemGunChemthrower.getMagCount(stack) != 0) return false;
        return true;
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        if (!this.acceptsFluid(type, stack)) {
            return amount;
        }
        if (ItemGunChemthrower.getMagCount(stack) == 0) {
            ItemGunChemthrower.setMagType(stack, type.getID());
        }
        int fill = ItemGunChemthrower.getMagCount(stack);
        int req = this.getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack).getCapacity(stack) - fill;
        int toFill = Math.min(amount, req);
        toFill = Math.min(toFill, 50);
        ItemGunChemthrower.setMagCount(stack, fill + toFill);
        return amount - toFill;
    }

    public FluidType getFluidType(ItemStack stack) {
        return Fluids.fromID(ItemGunChemthrower.getMagType(stack));
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return this.getFluidType(stack) == type;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        int fill = ItemGunChemthrower.getMagCount(stack);
        int toUnload = Math.min(fill, amount);
        toUnload = Math.min(toUnload, 50);
        ItemGunChemthrower.setMagCount(stack, fill - toUnload);
        return toUnload;
    }

    @Override
    public FluidType getFirstFluidType(ItemStack stack) {
        return Fluids.fromID(ItemGunChemthrower.getMagType(stack));
    }

    @Override
    public int getFill(ItemStack stack) {
        return ItemGunChemthrower.getMagCount(stack);
    }

    public static int getMagType(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, "magtype0");
    }

    public static void setMagType(ItemStack stack, int value) {
        ItemGunBaseNT.setValueInt(stack, "magtype0", value);
    }

    public static int getMagCount(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, "magcount0");
    }

    public static void setMagCount(ItemStack stack, int value) {
        ItemGunBaseNT.setValueInt(stack, "magcount0", value);
    }
}

