/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.mags;

import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.mags.MagazineSingleTypeBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class MagazineFullReload
extends MagazineSingleTypeBase {
    public MagazineFullReload(int index, int capacity) {
        super(index, capacity);
    }

    @Override
    public boolean canReload(ItemStack stack, IInventory inventory) {
        if (this.getAmount(stack, inventory) >= this.getCapacity(stack)) {
            return false;
        }
        if (inventory == null) {
            return true;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            if (this.getAmount(stack, inventory) == 0) {
                for (BulletConfig config : this.acceptedBullets) {
                    if (!config.ammo.matchesRecipe(slot, true)) continue;
                    return true;
                }
                continue;
            }
            BulletConfig config = this.getType(stack, inventory);
            if (config == null) {
                config = (BulletConfig)this.acceptedBullets.get(0);
                this.setType(stack, config);
            }
            if (!config.ammo.matchesRecipe(slot, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reloadAction(ItemStack stack, IInventory inventory) {
        if (inventory == null) {
            BulletConfig config = this.getType(stack, inventory);
            if (config == null) {
                config = (BulletConfig)this.acceptedBullets.get(0);
                this.setType(stack, config);
            }
            this.setAmount(stack, this.capacity);
            return;
        }
        block0: for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int toLoad;
            int wantsToLoad;
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            if (this.getAmount(stack, inventory) == 0) {
                for (BulletConfig config : this.acceptedBullets) {
                    if (!config.ammo.matchesRecipe(slot, true)) continue;
                    this.setType(stack, config);
                    wantsToLoad = (int)Math.ceil((double)this.getCapacity(stack) / (double)config.ammoReloadCount);
                    toLoad = Math.min(wantsToLoad, slot.field_77994_a);
                    this.setAmount(stack, Math.min(toLoad * config.ammoReloadCount, this.capacity));
                    inventory.func_70298_a(i, toLoad);
                    continue block0;
                }
                continue;
            }
            BulletConfig config = this.getType(stack, inventory);
            if (config == null) {
                config = (BulletConfig)this.acceptedBullets.get(0);
                this.setType(stack, config);
            }
            if (!config.ammo.matchesRecipe(slot, true)) continue;
            int alreadyLoaded = this.getAmount(stack, inventory);
            wantsToLoad = (int)Math.ceil((double)(this.getCapacity(stack) - alreadyLoaded) / (double)config.ammoReloadCount);
            toLoad = Math.min(wantsToLoad, slot.field_77994_a);
            this.setAmount(stack, Math.min(toLoad * config.ammoReloadCount + alreadyLoaded, this.capacity));
            inventory.func_70298_a(i, toLoad);
        }
    }
}

