/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.mags;

import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.particle.SpentCasing;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class MagazineSingleTypeBase
implements IMagazine<BulletConfig> {
    public static final String KEY_MAG_COUNT = "magcount";
    public static final String KEY_MAG_TYPE = "magtype";
    public static final String KEY_MAG_PREV = "magprev";
    public static final String KEY_MAG_AFTER = "magafter";
    public List<BulletConfig> acceptedBullets = new ArrayList<BulletConfig>();
    public int index;
    public int capacity;

    public MagazineSingleTypeBase(int index, int capacity) {
        this.index = index;
        this.capacity = capacity;
    }

    public MagazineSingleTypeBase addConfigs(BulletConfig ... cfgs) {
        for (BulletConfig cfg : cfgs) {
            this.acceptedBullets.add(cfg);
        }
        return this;
    }

    @Override
    public BulletConfig getType(ItemStack stack, IInventory inventory) {
        int type = MagazineSingleTypeBase.getMagType(stack, this.index);
        if (type >= 0 && type < BulletConfig.configs.size()) {
            BulletConfig cfg = BulletConfig.configs.get(type);
            if (this.acceptedBullets.contains(cfg)) {
                return cfg;
            }
            return this.acceptedBullets.get(0);
        }
        return null;
    }

    @Override
    public void setType(ItemStack stack, BulletConfig type) {
        int i = BulletConfig.configs.indexOf(type);
        if (i >= 0) {
            MagazineSingleTypeBase.setMagType(stack, this.index, i);
        }
    }

    @Override
    public ItemStack getIconForHUD(ItemStack stack, EntityPlayer player) {
        BulletConfig config = this.getType(stack, (IInventory)player.field_71071_by);
        if (config != null) {
            return config.ammo.toStack();
        }
        return null;
    }

    @Override
    public String reportAmmoStateForHUD(ItemStack stack, EntityPlayer player) {
        return this.getAmount(stack, (IInventory)player.field_71071_by) + " / " + this.getCapacity(stack);
    }

    @Override
    public SpentCasing getCasing(ItemStack stack, IInventory inventory) {
        return this.getType((ItemStack)stack, (IInventory)inventory).casing;
    }

    @Override
    public void useUpAmmo(ItemStack stack, IInventory inventory, int amount) {
        if (!IMagazine.shouldUseUpTrenchie(inventory) && this.getCapacity(stack) != 1) {
            return;
        }
        this.setAmount(stack, this.getAmount(stack, inventory) - amount);
        IMagazine.handleAmmoBag(inventory, this.getType(stack, inventory), amount);
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return this.capacity;
    }

    @Override
    public int getAmount(ItemStack stack, IInventory inventory) {
        return MagazineSingleTypeBase.getMagCount(stack, this.index);
    }

    @Override
    public void setAmount(ItemStack stack, int amount) {
        MagazineSingleTypeBase.setMagCount(stack, this.index, amount);
    }

    @Override
    public void setAmountBeforeReload(ItemStack stack, int amount) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_PREV + this.index, amount);
    }

    @Override
    public int getAmountBeforeReload(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_PREV + this.index);
    }

    @Override
    public void setAmountAfterReload(ItemStack stack, int amount) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_AFTER + this.index, amount);
    }

    @Override
    public int getAmountAfterReload(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_AFTER + this.index);
    }

    public static int getMagType(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_TYPE + index);
    }

    public static void setMagType(ItemStack stack, int index, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_TYPE + index, value);
    }

    public static int getMagCount(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_COUNT + index);
    }

    public static void setMagCount(ItemStack stack, int index, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_COUNT + index, value);
    }
}

