/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet.toclient;

import com.hbm.items.armor.ArmorTrenchmaster;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.Receiver;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.HbmAnimations;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class GunAnimationPacket
implements IMessage {
    public short type;
    public int receiverIndex;
    public int gunIndex;

    public GunAnimationPacket() {
    }

    public GunAnimationPacket(int type) {
        this.type = (short)type;
        this.receiverIndex = 0;
        this.gunIndex = 0;
    }

    public GunAnimationPacket(int type, int rec) {
        this.type = (short)type;
        this.receiverIndex = rec;
        this.gunIndex = 0;
    }

    public GunAnimationPacket(int type, int rec, int gun) {
        this.type = (short)type;
        this.receiverIndex = rec;
        this.gunIndex = gun;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readShort();
        this.receiverIndex = buf.readInt();
        this.gunIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.type);
        buf.writeInt(this.receiverIndex);
        buf.writeInt(this.gunIndex);
    }

    public static class Handler
    implements IMessageHandler<GunAnimationPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(GunAnimationPacket m, MessageContext ctx) {
            try {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                ItemStack stack = player.func_70694_bm();
                int slot = player.field_71071_by.field_70461_c;
                if (stack == null) {
                    return null;
                }
                if (stack.func_77973_b() instanceof ItemGunBaseNT) {
                    Handler.handleSedna((EntityPlayer)player, stack, slot, HbmAnimations.AnimType.values()[m.type], m.receiverIndex, m.gunIndex);
                }
                if (!(stack.func_77973_b() instanceof ItemGunBase)) {
                    return null;
                }
                if (m.type < 0 || m.type >= HbmAnimations.AnimType.values().length) {
                    return null;
                }
                HbmAnimations.AnimType type = HbmAnimations.AnimType.values()[m.type];
                ItemGunBase base = (ItemGunBase)stack.func_77973_b();
                BusAnimation animation = base.getAnimation(stack, type);
                if (animation == null && type == HbmAnimations.AnimType.RELOAD_EMPTY) {
                    animation = base.getAnimation(stack, HbmAnimations.AnimType.RELOAD);
                }
                if (animation == null && (type == HbmAnimations.AnimType.ALT_CYCLE || type == HbmAnimations.AnimType.CYCLE_EMPTY)) {
                    animation = base.getAnimation(stack, HbmAnimations.AnimType.CYCLE);
                }
                if (animation != null) {
                    boolean isReloadAnimation;
                    boolean bl = isReloadAnimation = type == HbmAnimations.AnimType.RELOAD || type == HbmAnimations.AnimType.RELOAD_CYCLE || type == HbmAnimations.AnimType.RELOAD_EMPTY;
                    if (isReloadAnimation && ArmorTrenchmaster.isTrenchMaster((EntityPlayer)player)) {
                        animation.setTimeMult(0.5);
                    }
                    HbmAnimations.hotbar[slot][0] = new HbmAnimations.Animation(stack.func_77973_b().func_77658_a(), System.currentTimeMillis(), animation, type, isReloadAnimation && base.mainConfig.reloadAnimationsSequential);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public static void handleSedna(EntityPlayer player, ItemStack stack, int slot, HbmAnimations.AnimType type, int receiverIndex, int gunIndex) {
            BiFunction<ItemStack, HbmAnimations.AnimType, BusAnimation> anims;
            BusAnimation animation;
            ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
            GunConfig config = gun.getConfig(stack, gunIndex);
            if (type == HbmAnimations.AnimType.CYCLE) {
                Receiver rec;
                BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> onRecoil;
                if (gunIndex < gun.lastShot.length) {
                    gun.lastShot[gunIndex] = System.currentTimeMillis();
                }
                gun.shotRand = player.field_70170_p.field_73012_v.nextDouble();
                Receiver[] receivers = config.getReceivers(stack);
                if (receiverIndex >= 0 && receiverIndex < receivers.length && (onRecoil = (rec = receivers[receiverIndex]).getRecoil(stack)) != null) {
                    onRecoil.accept(stack, new ItemGunBaseNT.LambdaContext(config, (EntityLivingBase)player, (IInventory)player.field_71071_by, receiverIndex));
                }
            }
            if ((animation = (anims = config.getAnims(stack)).apply(stack, type)) == null && type == HbmAnimations.AnimType.RELOAD_EMPTY) {
                animation = anims.apply(stack, HbmAnimations.AnimType.RELOAD);
            }
            if (animation == null && (type == HbmAnimations.AnimType.ALT_CYCLE || type == HbmAnimations.AnimType.CYCLE_EMPTY)) {
                animation = anims.apply(stack, HbmAnimations.AnimType.CYCLE);
            }
            if (animation != null) {
                boolean isReloadAnimation;
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78444_b();
                Minecraft.func_71410_x().field_71460_t.field_78516_c.field_78453_b = stack;
                boolean bl = isReloadAnimation = type == HbmAnimations.AnimType.RELOAD || type == HbmAnimations.AnimType.RELOAD_CYCLE || type == HbmAnimations.AnimType.RELOAD_EMPTY;
                if (isReloadAnimation && ArmorTrenchmaster.isTrenchMaster(player)) {
                    animation.setTimeMult(0.5);
                }
                HbmAnimations.hotbar[slot][gunIndex] = new HbmAnimations.Animation(stack.func_77973_b().func_77658_a(), System.currentTimeMillis(), animation, type, isReloadAnimation && config.getReloadAnimSequential(stack));
            }
        }
    }
}

