/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.psys.engine;

import com.hbm.lib.Library;
import com.hbm.particle.psys.engine.PSysFX;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public abstract class PSysFXMoving
extends PSysFX {
    public double motionX;
    public double motionY;
    public double motionZ;
    boolean noClip = false;
    public boolean[] collisionData = new boolean[6];

    public PSysFXMoving(World world, double x, double y, double z, double mX, double mY, double mZ) {
        super(world, x, y, z);
        this.motionX = mX;
        this.motionY = mY;
        this.motionZ = mZ;
    }

    public double getParticleGravity() {
        return 0.04;
    }

    public double getParticleDrag() {
        return 0.98;
    }

    @Override
    public void updateParticle() {
        super.updateParticle();
        if (!this.isUnloaded) {
            this.motionX -= this.getParticleGravity();
            this.motionX *= this.getParticleDrag();
            this.motionY *= this.getParticleDrag();
            this.motionZ *= this.getParticleDrag();
            this.move(this.motionX, this.motionY, this.motionZ);
        }
    }

    public void move(double x, double y, double z) {
        double x0 = x;
        double y0 = y;
        double z0 = z;
        this.collisionData = new boolean[6];
        if (!this.noClip) {
            List list = this.world.func_72945_a(null, this.getBoundingBox().func_72314_b(x, y, z));
            for (AxisAlignedBB aabb : list) {
                y = aabb.func_72323_b(this.getBoundingBox(), y);
            }
            this.setBoundingBox(this.getBoundingBox().func_72317_d(0.0, y, 0.0));
            for (AxisAlignedBB aabb : list) {
                x = aabb.func_72316_a(this.getBoundingBox(), x);
            }
            this.setBoundingBox(this.getBoundingBox().func_72317_d(x, 0.0, 0.0));
            for (AxisAlignedBB aabb : list) {
                z = aabb.func_72322_c(this.getBoundingBox(), z);
            }
            this.setBoundingBox(this.getBoundingBox().func_72317_d(0.0, 0.0, z));
        } else {
            this.setBoundingBox(this.getBoundingBox().func_72317_d(x, y, z));
        }
        this.setPosToAABB();
        if (x0 != x && x > 0.0) {
            this.collisionData[Library.NEG_X.ordinal()] = true;
        }
        if (x0 != x && x < 0.0) {
            this.collisionData[Library.POS_X.ordinal()] = true;
        }
        if (y0 != y && y > 0.0) {
            this.collisionData[Library.NEG_Y.ordinal()] = true;
        }
        if (y0 != y && y < 0.0) {
            this.collisionData[Library.POS_Y.ordinal()] = true;
        }
        if (z0 != z && z > 0.0) {
            this.collisionData[Library.NEG_Z.ordinal()] = true;
        }
        if (z0 != z && z < 0.0) {
            this.collisionData[Library.POS_Z.ordinal()] = true;
        }
        if (x0 != x) {
            this.motionX = 0.0;
        }
        if (y0 != y) {
            this.motionY = 0.0;
        }
        if (z0 != z) {
            this.motionZ = 0.0;
        }
    }
}

