/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.block;

import com.hbm.blocks.network.FluidDuctStandard;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.lib.Library;
import com.hbm.main.ResourceManager;
import com.hbm.render.util.ObjUtil;
import com.hbm.tileentity.network.TileEntityPipeBaseNT;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class RenderTestPipe
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon iicon = block.func_149691_a(0, metadata);
        IIcon overlay = block.func_149691_a(1, metadata);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        if (renderer.func_147744_b()) {
            iicon = renderer.field_147840_d;
        }
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)1.25, (double)1.25, (double)1.25);
        tessellator.func_78382_b();
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, "pX", iicon, tessellator, 0.0f, false);
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, "nX", iicon, tessellator, 0.0f, false);
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, "pZ", iicon, tessellator, 0.0f, false);
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, "nZ", iicon, tessellator, 0.0f, false);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        ObjUtil.setColor(Fluids.NONE.getColor());
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, "pX", overlay, tessellator, 0.0f, false);
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, "nX", overlay, tessellator, 0.0f, false);
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, "pZ", overlay, tessellator, 0.0f, false);
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, "nZ", overlay, tessellator, 0.0f, false);
        ObjUtil.clearColor();
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int meta = world.func_72805_g(x, y, z);
        IIcon iicon = block.func_149691_a(0, meta);
        IIcon overlay = block.func_149691_a(1, meta);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        if (renderer.func_147744_b()) {
            iicon = renderer.field_147840_d;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        int color = 0xFF00FF;
        FluidType type = Fluids.NONE;
        if (te instanceof TileEntityPipeBaseNT) {
            TileEntityPipeBaseNT pipe = (TileEntityPipeBaseNT)te;
            color = pipe.getType().getColor();
            type = pipe.getType();
        }
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        boolean pX = Library.canConnectFluid(world, x + 1, y, z, Library.POS_X, type);
        boolean nX = Library.canConnectFluid(world, x - 1, y, z, Library.NEG_X, type);
        boolean pY = Library.canConnectFluid(world, x, y + 1, z, Library.POS_Y, type);
        boolean nY = Library.canConnectFluid(world, x, y - 1, z, Library.NEG_Y, type);
        boolean pZ = Library.canConnectFluid(world, x, y, z + 1, Library.POS_Z, type);
        boolean nZ = Library.canConnectFluid(world, x, y, z - 1, Library.NEG_Z, type);
        int mask = 0 + (pX ? 32 : 0) + (nX ? 16 : 0) + (pY ? 8 : 0) + (nY ? 4 : 0) + (pZ ? 2 : 0) + (nZ ? 1 : 0);
        tessellator.func_78372_c((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        if (mask == 0) {
            this.renderDuct(iicon, overlay, color, tessellator, "pX");
            this.renderDuct(iicon, overlay, color, tessellator, "nX");
            this.renderDuct(iicon, overlay, color, tessellator, "pY");
            this.renderDuct(iicon, overlay, color, tessellator, "nY");
            this.renderDuct(iicon, overlay, color, tessellator, "pZ");
            this.renderDuct(iicon, overlay, color, tessellator, "nZ");
        } else if (mask == 32 || mask == 16) {
            this.renderDuct(iicon, overlay, color, tessellator, "pX");
            this.renderDuct(iicon, overlay, color, tessellator, "nX");
        } else if (mask == 8 || mask == 4) {
            this.renderDuct(iicon, overlay, color, tessellator, "pY");
            this.renderDuct(iicon, overlay, color, tessellator, "nY");
        } else if (mask == 2 || mask == 1) {
            this.renderDuct(iicon, overlay, color, tessellator, "pZ");
            this.renderDuct(iicon, overlay, color, tessellator, "nZ");
        } else {
            if (pX) {
                this.renderDuct(iicon, overlay, color, tessellator, "pX");
            }
            if (nX) {
                this.renderDuct(iicon, overlay, color, tessellator, "nX");
            }
            if (pY) {
                this.renderDuct(iicon, overlay, color, tessellator, "pY");
            }
            if (nY) {
                this.renderDuct(iicon, overlay, color, tessellator, "nY");
            }
            if (pZ) {
                this.renderDuct(iicon, overlay, color, tessellator, "nZ");
            }
            if (nZ) {
                this.renderDuct(iicon, overlay, color, tessellator, "pZ");
            }
            if (!(pX || pY || pZ)) {
                this.renderDuct(iicon, overlay, color, tessellator, "ppn");
            }
            if (!(pX || pY || nZ)) {
                this.renderDuct(iicon, overlay, color, tessellator, "ppp");
            }
            if (!(nX || pY || pZ)) {
                this.renderDuct(iicon, overlay, color, tessellator, "npn");
            }
            if (!(nX || pY || nZ)) {
                this.renderDuct(iicon, overlay, color, tessellator, "npp");
            }
            if (!(pX || nY || pZ)) {
                this.renderDuct(iicon, overlay, color, tessellator, "pnn");
            }
            if (!(pX || nY || nZ)) {
                this.renderDuct(iicon, overlay, color, tessellator, "pnp");
            }
            if (!(nX || nY || pZ)) {
                this.renderDuct(iicon, overlay, color, tessellator, "nnn");
            }
            if (!(nX || nY || nZ)) {
                this.renderDuct(iicon, overlay, color, tessellator, "nnp");
            }
        }
        tessellator.func_78372_c((float)(-x) - 0.5f, (float)(-y) - 0.5f, (float)(-z) - 0.5f);
        return true;
    }

    private void renderDuct(IIcon iicon, IIcon overlay, int color, Tessellator tessellator, String part) {
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, part, iicon, tessellator, 0.0f, true);
        ObjUtil.setColor(color);
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.pipe_neo, part, overlay, tessellator, 0.0f, true);
        ObjUtil.clearColor();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return FluidDuctStandard.renderID;
    }
}

