/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon;

import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.main.ResourceManager;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderFireExt
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case ENTITY: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && (helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION || helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        ResourceLocation tex;
        GL11.glPushMatrix();
        GL11.glEnable((int)2884);
        int magType = ItemGunBase.getMagType(item);
        int config = ((ItemGunBase)ModItems.gun_fireext).mainConfig.config.get(magType);
        int ammo = BulletConfigSyncingUtil.pullConfig((int)config).ammo.meta;
        switch (ammo) {
            case 0: {
                tex = ResourceManager.fireext_foam_tex;
                break;
            }
            case 1: {
                tex = ResourceManager.fireext_sand_tex;
                break;
            }
            default: {
                tex = ResourceManager.fireext_tex;
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(tex);
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                double s0 = 0.35;
                GL11.glRotated((double)25.0, (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)0.5, (double)-0.5, (double)-0.5);
                GL11.glRotated((double)80.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)s0, (double)s0, (double)s0);
                break;
            }
            case EQUIPPED: {
                double scale = 0.5;
                GL11.glScaled((double)scale, (double)scale, (double)scale);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.75f, (float)-2.75f, (float)0.5f);
                break;
            }
            case ENTITY: {
                double s1 = 0.3;
                GL11.glScaled((double)s1, (double)s1, (double)s1);
                break;
            }
            case INVENTORY: {
                GL11.glEnable((int)2896);
                double s = 4.5;
                GL11.glTranslated((double)2.0, (double)14.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)-135.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)(System.currentTimeMillis() / 10L % 360L), (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)s, (double)s, (double)(-s));
                break;
            }
        }
        GL11.glShadeModel((int)7425);
        ResourceManager.fireext.renderAll();
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }
}

