/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.shader;

import com.hbm.main.MainRegistry;
import com.hbm.render.shader.Shader;
import com.hbm.render.shader.Uniform;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public class ShaderManager {
    public static boolean enableShaders = true;
    public static final Uniform LIGHTMAP = shader -> GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"lightmap"), (int)1);

    public static Shader loadShader(ResourceLocation file) {
        if (!enableShaders) {
            return new Shader(0);
        }
        int vertexShader = 0;
        int fragmentShader = 0;
        try {
            int program = GL20.glCreateProgram();
            vertexShader = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)vertexShader, (ByteBuffer)ShaderManager.readFileToBuf(new ResourceLocation(file.func_110624_b(), file.func_110623_a() + ".vert")));
            GL20.glCompileShader((int)vertexShader);
            if (GL20.glGetShaderi((int)vertexShader, (int)35713) == 0) {
                MainRegistry.logger.error(GL20.glGetShaderInfoLog((int)vertexShader, (int)35716));
                throw new RuntimeException("Error creating vertex shader: " + file);
            }
            fragmentShader = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)fragmentShader, (ByteBuffer)ShaderManager.readFileToBuf(new ResourceLocation(file.func_110624_b(), file.func_110623_a() + ".frag")));
            GL20.glCompileShader((int)fragmentShader);
            if (GL20.glGetShaderi((int)fragmentShader, (int)35713) == 0) {
                MainRegistry.logger.error(GL20.glGetShaderInfoLog((int)fragmentShader, (int)35716));
                throw new RuntimeException("Error creating fragment shader: " + file);
            }
            GL20.glAttachShader((int)program, (int)vertexShader);
            GL20.glAttachShader((int)program, (int)fragmentShader);
            GL20.glLinkProgram((int)program);
            if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
                MainRegistry.logger.error(GL20.glGetProgramInfoLog((int)program, (int)35716));
                throw new RuntimeException("Error creating fragment shader: " + file);
            }
            GL20.glDeleteShader((int)vertexShader);
            GL20.glDeleteShader((int)fragmentShader);
            return new Shader(program);
        }
        catch (Exception x) {
            GL20.glDeleteShader((int)vertexShader);
            GL20.glDeleteShader((int)fragmentShader);
            x.printStackTrace();
            return new Shader(0);
        }
    }

    private static ByteBuffer readFileToBuf(ResourceLocation file) throws IOException {
        InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(file).func_110527_b();
        byte[] bytes = IOUtils.toByteArray((InputStream)in);
        IOUtils.closeQuietly((InputStream)in);
        ByteBuffer buf = BufferUtils.createByteBuffer((int)bytes.length);
        buf.put(bytes);
        buf.rewind();
        return buf;
    }
}

