/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.render.util.DiamondPronter;
import com.hbm.tileentity.machine.storage.TileEntityMachineFluidTank;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderFluidTank
extends TileEntitySpecialRenderer
implements IItemRendererProvider {
    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2884);
        switch (tileEntity.func_145832_p() - 10) {
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        TileEntityMachineFluidTank tank = (TileEntityMachineFluidTank)tileEntity;
        FluidType type = tank.tank.getTankType();
        GL11.glShadeModel((int)7425);
        this.func_147499_a(ResourceManager.tank_tex);
        if (!tank.hasExploded) {
            ResourceManager.fluidtank.renderPart("Frame");
            this.func_147499_a(new ResourceLocation("hbm", this.getTextureFromType(tank.tank.getTankType())));
            ResourceManager.fluidtank.renderPart("Tank");
        } else {
            ResourceManager.fluidtank_exploded.renderPart("Frame");
            this.func_147499_a(ResourceManager.tank_inner_tex);
            ResourceManager.fluidtank_exploded.renderPart("TankInner");
            this.func_147499_a(new ResourceLocation("hbm", this.getTextureFromType(tank.tank.getTankType())));
            ResourceManager.fluidtank_exploded.renderPart("Tank");
        }
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glShadeModel((int)7424);
        if (type != null && type != Fluids.NONE) {
            RenderHelper.func_74518_a();
            GL11.glPushMatrix();
            GL11.glTranslated((double)-0.25, (double)0.5, (double)-1.501);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glScalef((float)1.0f, (float)0.375f, (float)0.375f);
            DiamondPronter.pront(type.poison, type.flammability, type.reactivity, type.symbol);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.25, (double)0.5, (double)1.501);
            GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glScalef((float)1.0f, (float)0.375f, (float)0.375f);
            DiamondPronter.pront(type.poison, type.flammability, type.reactivity, type.symbol);
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
    }

    public String getTextureFromType(FluidType type) {
        if (type.customFluid) {
            int color = type.getTint();
            double r = (double)((color & 0xFF0000) >> 16) / 255.0;
            double g = (double)((color & 0xFF00) >> 8) / 255.0;
            double b = (double)((color & 0xFF) >> 0) / 255.0;
            GL11.glColor3d((double)r, (double)g, (double)b);
            return "textures/models/tank/tank_NONE.png";
        }
        String s = type.getName();
        if (type.isAntimatter() || type.hasTrait(FT_Corrosive.class) && type.getTrait(FT_Corrosive.class).isHighlyCorrosive()) {
            s = "DANGER";
        }
        return "textures/models/tank/tank_" + s + ".png";
    }

    @Override
    public Item getItemForRenderer() {
        return Item.func_150898_a((Block)ModBlocks.machine_fluidtank);
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                GL11.glTranslated((double)0.0, (double)-2.0, (double)0.0);
                GL11.glScaled((double)3.5, (double)3.5, (double)3.5);
            }

            @Override
            public void renderCommonWithStack(ItemStack item) {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
                GL11.glShadeModel((int)7425);
                GL11.glDisable((int)2884);
                FluidTank tank = new FluidTank(Fluids.NONE, 0);
                boolean exploded = false;
                if (item.func_77942_o() && item.func_77978_p().func_74764_b("persistent")) {
                    tank.readFromNBT(item.func_77978_p().func_74775_l("persistent"), "tank");
                    exploded = item.func_77978_p().func_74775_l("persistent").func_74767_n("hasExploded");
                }
                if (!exploded) {
                    RenderFluidTank.this.func_147499_a(ResourceManager.tank_tex);
                    ResourceManager.fluidtank.renderPart("Frame");
                    RenderFluidTank.this.func_147499_a(new ResourceLocation("hbm", RenderFluidTank.this.getTextureFromType(tank.getTankType())));
                    ResourceManager.fluidtank.renderPart("Tank");
                } else {
                    RenderFluidTank.this.func_147499_a(ResourceManager.tank_tex);
                    ResourceManager.fluidtank_exploded.renderPart("Frame");
                    RenderFluidTank.this.func_147499_a(ResourceManager.tank_inner_tex);
                    ResourceManager.fluidtank_exploded.renderPart("TankInner");
                    RenderFluidTank.this.func_147499_a(new ResourceLocation("hbm", RenderFluidTank.this.getTextureFromType(tank.getTankType())));
                    ResourceManager.fluidtank_exploded.renderPart("Tank");
                }
                GL11.glEnable((int)2884);
                GL11.glShadeModel((int)7424);
            }
        };
    }
}

