/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.main.ResourceManager;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.util.I18nUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class RenderRBMKConsole
extends TileEntitySpecialRenderer {
    public void func_147500_a(TileEntity te, double x, double y, double z, float interp) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        switch (te.func_145832_p() - 10) {
            case 2: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
        GL11.glShadeModel((int)7425);
        this.func_147499_a(ResourceManager.rbmk_console_tex);
        ResourceManager.rbmk_console.renderAll();
        GL11.glShadeModel((int)7424);
        TileEntityRBMKConsole console = (TileEntityRBMKConsole)te;
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tess.func_78382_b();
        tess.func_78380_c(240);
        tess.func_78375_b(1.0f, 0.0f, 0.0f);
        block11: for (int i = 0; i < console.columns.length; ++i) {
            TileEntityRBMKConsole.RBMKColumn col = console.columns[i];
            if (col == null) continue;
            double kx = -0.3725;
            double ky = (double)(-(i / 15)) * 0.125 + 3.625;
            double kz = (double)(-(i % 15)) * 0.125 + 0.875;
            this.drawColumn(tess, kx, ky, kz, (float)(0.65 + (double)(i % 2) * 0.05), col.data.func_74769_h("heat") / col.data.func_74769_h("maxHeat"));
            switch (col.type) {
                case FUEL: 
                case FUEL_SIM: {
                    this.drawFuel(tess, kx + 0.01, ky, kz, col.data.func_74769_h("enrichment"));
                    continue block11;
                }
                case CONTROL: {
                    this.drawControl(tess, kx + 0.01, ky, kz, col.data.func_74769_h("level"));
                    continue block11;
                }
                case CONTROL_AUTO: {
                    this.drawControlAuto(tess, kx + 0.01, ky, kz, col.data.func_74769_h("level"));
                    continue block11;
                }
            }
        }
        tess.func_78381_a();
        GL11.glEnable((int)3553);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslatef((float)-0.42f, (float)3.5f, (float)1.75f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)32826);
        for (int i = 0; i < console.screens.length; ++i) {
            GL11.glPushMatrix();
            if (i % 2 == 1) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-3.5f);
            }
            GL11.glTranslatef((float)0.0f, (float)(-0.75f * (float)(i / 2)), (float)0.0f);
            TileEntityRBMKConsole.RBMKScreen screen = console.screens[i];
            String text = screen.display;
            if (text != null && !text.isEmpty()) {
                String[] parts = text.split("=");
                if (parts.length == 2) {
                    text = I18nUtil.resolveKey(parts[0], parts[1]);
                }
                int width = font.func_78256_a(text);
                int height = font.field_78288_b;
                float f3 = Math.min(0.03f, 0.8f / (float)Math.max(width, 1));
                GL11.glScalef((float)f3, (float)(-f3), (float)f3);
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                font.func_78276_b(text, -width / 2, -height / 2, 65280);
            }
            GL11.glPopMatrix();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void drawColumn(Tessellator tess, double x, double y, double z, float color, double heat) {
        double width = 0.046875;
        tess.func_78386_a((float)((double)color + (double)(1.0f - color) * heat), color, color);
        tess.func_78377_a(x, y + width, z - width);
        tess.func_78377_a(x, y + width, z + width);
        tess.func_78377_a(x, y - width, z + width);
        tess.func_78377_a(x, y - width, z - width);
    }

    private void drawFuel(Tessellator tess, double x, double y, double z, double enrichment) {
        this.drawDot(tess, x, y, z, 0.0f, 0.25f + (float)(enrichment * 0.75), 0.0f);
    }

    private void drawControl(Tessellator tess, double x, double y, double z, double level) {
        this.drawDot(tess, x, y, z, (float)level, (float)level, 0.0f);
    }

    private void drawControlAuto(Tessellator tess, double x, double y, double z, double level) {
        this.drawDot(tess, x, y, z, (float)level, 0.0f, (float)level);
    }

    private void drawDot(Tessellator tess, double x, double y, double z, float r, float g, float b) {
        double width = 0.03125;
        double edge = 0.022097;
        tess.func_78386_a(r, g, b);
        tess.func_78377_a(x, y + width, z);
        tess.func_78377_a(x, y + edge, z + edge);
        tess.func_78377_a(x, y, z + width);
        tess.func_78377_a(x, y - edge, z + edge);
        tess.func_78377_a(x, y + edge, z - edge);
        tess.func_78377_a(x, y + width, z);
        tess.func_78377_a(x, y - edge, z - edge);
        tess.func_78377_a(x, y, z - width);
        tess.func_78377_a(x, y + width, z);
        tess.func_78377_a(x, y - edge, z + edge);
        tess.func_78377_a(x, y - width, z);
        tess.func_78377_a(x, y - edge, z - edge);
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
    }
}

