/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.config.ClientConfig;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.interfaces.Spaghetti;
import com.hbm.interfaces.Untested;
import com.hbm.items.weapon.sedna.Crosshair;
import com.hbm.items.weapon.sedna.impl.ItemGunStinger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import org.lwjgl.opengl.GL11;

public class RenderScreenOverlay {
    public static final ResourceLocation misc = new ResourceLocation("hbm:textures/misc/overlay_misc.png");
    public static final RenderItem itemRenderer = RenderItem.getInstance();
    private static long lastSurvey;
    private static float prevResult;
    private static float lastResult;
    private static float fadeOut;

    public static void renderRadCounter(ScaledResolution resolution, float in, Gui gui) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        float radiation = 0.0f;
        radiation = lastResult - prevResult;
        if (System.currentTimeMillis() >= lastSurvey + 1000L) {
            lastSurvey = System.currentTimeMillis();
            prevResult = lastResult;
            lastResult = in;
        }
        int length = 74;
        int maxRad = 1000;
        int bar = RenderScreenOverlay.getScaled(in, maxRad, 74.0);
        int posX = 16 + ClientConfig.GEIGER_OFFSET_HORIZONTAL.get();
        int posY = resolution.func_78328_b() - 20 - ClientConfig.GEIGER_OFFSET_VERTICAL.get();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        gui.func_73729_b(posX, posY, 0, 0, 94, 18);
        gui.func_73729_b(posX + 1, posY + 1, 1, 19, bar, 16);
        if (radiation >= 25.0f) {
            gui.func_73729_b(posX + length + 2, posY - 18, 36, 36, 18, 18);
        } else if (radiation >= 10.0f) {
            gui.func_73729_b(posX + length + 2, posY - 18, 18, 36, 18, 18);
        } else if ((double)radiation >= 2.5) {
            gui.func_73729_b(posX + length + 2, posY - 18, 0, 36, 18, 18);
        }
        if (radiation > 1000.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(">1000 RAD/s", posX, posY - 8, 0xFF0000);
        } else if (radiation >= 1.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(Math.round(radiation) + " RAD/s", posX, posY - 8, 0xFF0000);
        } else if (radiation > 0.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b("<1 RAD/s", posX, posY - 8, 0xFF0000);
        }
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    private static int getScaled(double cur, double max, double scale) {
        return (int)Math.min(cur / max * scale, scale);
    }

    public static void renderCustomCrosshairs(ScaledResolution resolution, Gui gui, Crosshair cross) {
        if (cross == Crosshair.NONE) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
            return;
        }
        int size = cross.size;
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)775, (int)769, (int)1, (int)0);
        gui.func_73729_b(resolution.func_78326_a() / 2 - size / 2, resolution.func_78328_b() / 2 - size / 2, cross.x, cross.y, size, size);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void renderStingerLockon(ScaledResolution resolution, Gui gui) {
        int progress = (int)(ItemGunStinger.lockon * 28.0f);
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        GL11.glDisable((int)3042);
        gui.func_73729_b(resolution.func_78326_a() / 2 - 15, resolution.func_78328_b() / 2 + 18, 146, 18, 30, 10);
        gui.func_73729_b(resolution.func_78326_a() / 2 - 14, resolution.func_78328_b() / 2 + 19, 147, 29, progress, 8);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void renderAmmo(ScaledResolution resolution, Gui gui, ItemStack ammo, int count, int max, int dura, boolean renderCount) {
        String cap;
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        int pX = resolution.func_78326_a() / 2 + 62 + 36;
        int pZ = resolution.func_78328_b() - 21;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        gui.func_73729_b(pX, pZ + 16, 94, 0, 52, 3);
        gui.func_73729_b(pX + 1, pZ + 16, 95, 3, 50 - dura, 3);
        String string = cap = max == -1 ? "\u221e" : "" + max;
        if (renderCount) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(count + " / " + cap, pX + 16, pZ + 6, 0xFFFFFF);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        itemRenderer.func_82406_b(mc.field_71466_p, mc.func_110434_K(), ammo, pX, pZ);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void renderAmmoAlt(ScaledResolution resolution, Gui gui, ItemStack ammo, int count) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        int pX = resolution.func_78326_a() / 2 + 62 + 36 + 18;
        int pZ = resolution.func_78328_b() - 21 - 16;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(count + "x", pX + 16, pZ + 6, 0xFFFFFF);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        itemRenderer.func_82406_b(mc.field_71466_p, mc.func_110434_K(), ammo, pX, pZ);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    @Spaghetti(value="like a fella once said, aint that a kick in the head")
    public static void renderDashBar(ScaledResolution resolution, Gui gui, HbmPlayerProps props) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        Minecraft mc = Minecraft.func_71410_x();
        int width = 30;
        int posX = 16;
        int posY = resolution.func_78328_b() - 40 - 2;
        mc.field_71446_o.func_110577_a(misc);
        gui.func_73729_b(posX - 10, posY, 107, 18, 7, 10);
        int stamina = props.getStamina();
        int dashes = props.getDashCount();
        int rows = dashes / 3;
        int finalColumns = dashes % 3;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < 3 && (y != rows || x <= finalColumns); ++x) {
                gui.func_73729_b(posX + (width + 2) * x, posY - 12 * y, 76, 48, width, 10);
                int staminaDiv = stamina / 30;
                int staminaMod = stamina % 30;
                int barID = 3 * y + x;
                int barStatus = 1;
                int barSize = width;
                if (staminaDiv < barID) {
                    barStatus = 3;
                } else if (staminaDiv == barID) {
                    barStatus = 2;
                    barSize = (int)((float)(stamina % 30) * ((float)width / 30.0f));
                    if (barID == 0) {
                        barStatus = 0;
                    }
                }
                gui.func_73729_b(posX + (width + 2) * x, posY - 12 * y, 76, 18 + 10 * barStatus, barSize, 10);
                if (staminaDiv == barID && staminaMod >= 27) {
                    fadeOut = 1.0f;
                }
                if (!(fadeOut > 0.0f) || staminaDiv - 1 != barID) continue;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)fadeOut);
                int bar = barID;
                if (stamina % 30 >= 25) {
                    ++bar;
                }
                if (bar / 3 != y) {
                    ++y;
                }
                gui.func_73729_b(posX + (width + 2) * (bar %= 3), posY - 12 * y, 76, 58, width, 10);
                fadeOut -= 0.04f;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void renderShieldBar(ScaledResolution resolution, Gui gui) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        HbmPlayerProps props = HbmPlayerProps.getData((EntityPlayer)player);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.left_height;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        gui.func_73729_b(left, top, 146, 0, 81, 9);
        int i = (int)Math.ceil(props.shield * 79.0f / props.getEffectiveMaxShield());
        gui.func_73729_b(left + 1, top, 147, 9, i, 9);
        String label = "" + (double)((int)(props.shield * 10.0f)) / 10.0;
        font.func_78276_b(label, left + 41 - font.func_78256_a(label) / 2, top + 1, 0);
        font.func_78276_b(label, left + 39 - font.func_78256_a(label) / 2, top + 1, 0);
        font.func_78276_b(label, left + 40 - font.func_78256_a(label) / 2, top, 0);
        font.func_78276_b(label, left + 40 - font.func_78256_a(label) / 2, top + 2, 0);
        font.func_78276_b(label, left + 40 - font.func_78256_a(label) / 2, top + 1, 0xFFFF80);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiIngameForge.left_height += 10;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    @Untested
    public static void renderScope(ScaledResolution res, ResourceLocation tex) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(tex);
        Tessellator tess = Tessellator.field_78398_a;
        double w = res.func_78326_a();
        double h = res.func_78328_b();
        double smallest = Math.min(w, h);
        double divisor = smallest / 0.5625;
        smallest = 0.5625;
        double largest = Math.max(w, h) / divisor;
        double hMin = h < w ? 0.5 - smallest / 2.0 : 0.5 - largest / 2.0;
        double hMax = h < w ? 0.5 + smallest / 2.0 : 0.5 + largest / 2.0;
        double wMin = w < h ? 0.5 - smallest / 2.0 : 0.5 - largest / 2.0;
        double wMax = w < h ? 0.5 + smallest / 2.0 : 0.5 + largest / 2.0;
        double depth = -300.0;
        tess.func_78382_b();
        tess.func_78374_a(0.0, h, depth, wMin, hMax);
        tess.func_78374_a(w, h, depth, wMax, hMax);
        tess.func_78374_a(w, 0.0, depth, wMax, hMin);
        tess.func_78374_a(0.0, 0.0, depth, wMin, hMin);
        tess.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        fadeOut = 0.0f;
    }
}

