/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.test;

import com.hbm.test.ExplosionWorld;
import com.hbm.test.MK5Frame;
import com.hbm.util.TimeAnalyzer;
import cpw.mods.fml.common.FMLCommonHandler;

public class ExplosionTests {
    private static ExplosionWorld world = new ExplosionWorld();
    public static double BUFFER_THRESHOLD = 0.25;

    public static void runTest() {
        int standardSpeed = (int)Math.ceil(333.0);
        double[] thresholds = new double[]{0.25, 0.5};
        int[] radii = new int[]{100, 250};
        int x = 200;
        int y = 70;
        int z = 200;
        long mem = 0L;
        for (int radius : radii) {
            int strength = radius * 2;
            int length = radius;
            System.gc();
            mem = ExplosionTests.getMem();
            System.out.println("#### STARTING TEST WITH NO PROXIMITY BUFFER " + radius + " ####");
            MK5Frame noBuf = new MK5Frame(world, x, y, z, strength, length).setBuffer(new MK5Frame.BufferNone());
            while (!noBuf.isCollectionComplete) {
                noBuf.collectTip(standardSpeed * 10);
            }
            while (noBuf.perChunk.size() > 0) {
                noBuf.processChunk();
            }
            TimeAnalyzer.endCount();
            TimeAnalyzer.dump();
            System.out.println("Mem diff: " + (ExplosionTests.getMem() - mem) / 0x100000L + "MB");
            double[] dArray = thresholds;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double threshold;
                BUFFER_THRESHOLD = threshold = dArray[i];
                System.gc();
                mem = ExplosionTests.getMem();
                System.out.println("#### STARTING TEST WITH MAP-BASED PROXIMITY BUFFER " + radius + " / " + threshold + " ####");
                MK5Frame mapBuf = new MK5Frame(world, x, y, z, strength, length).setBuffer(new MK5Frame.BufferMap());
                while (!mapBuf.isCollectionComplete) {
                    mapBuf.collectTip(standardSpeed * 10);
                }
                while (mapBuf.perChunk.size() > 0) {
                    mapBuf.processChunk();
                }
                TimeAnalyzer.endCount();
                TimeAnalyzer.dump();
                System.out.println("Mem diff: " + (ExplosionTests.getMem() - mem) / 0x100000L + "MB");
                System.gc();
                mem = ExplosionTests.getMem();
                System.out.println("#### STARTING TEST WITH ARRAY PROXIMITY BUFFER " + radius + " / " + threshold + " ####");
                MK5Frame arrayBuf = new MK5Frame(world, x, y, z, strength, length).setBuffer(new MK5Frame.BufferArray(x, y, z, length));
                while (!arrayBuf.isCollectionComplete) {
                    arrayBuf.collectTip(standardSpeed * 10);
                }
                while (arrayBuf.perChunk.size() > 0) {
                    arrayBuf.processChunk();
                }
                TimeAnalyzer.endCount();
                TimeAnalyzer.dump();
                System.out.println("Mem diff: " + (ExplosionTests.getMem() - mem) / 0x100000L + "MB");
            }
        }
        FMLCommonHandler.instance().exitJava(0, true);
    }

    public static long getMem() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }
}

