/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.test;

import com.hbm.test.ExplosionTests;
import com.hbm.test.ExplosionWorld;
import com.hbm.util.TimeAnalyzer;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;

public class MK5Frame {
    public HashMap<ChunkCoordIntPair, List<FloatTriplet>> perChunk = new HashMap();
    public List<ChunkCoordIntPair> orderedChunks = new ArrayList<ChunkCoordIntPair>();
    private CoordComparator comparator = new CoordComparator();
    int posX;
    int posY;
    int posZ;
    ExplosionWorld world;
    int strength;
    int length;
    int gspNumMax;
    int gspNum;
    double gspX;
    double gspY;
    public boolean isCollectionComplete = false;
    private ResultBuffer buffer;

    public MK5Frame(ExplosionWorld world, int x, int y, int z, int strength, int length) {
        this.world = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.strength = strength;
        this.length = length;
        this.gspNumMax = (int)(7.853981633974483 * Math.pow(this.strength, 2.0));
        this.gspNum = 1;
        this.gspX = Math.PI;
        this.gspY = 0.0;
    }

    private void generateGspUp() {
        if (this.gspNum < this.gspNumMax) {
            int k = this.gspNum + 1;
            double hk = -1.0 + 2.0 * ((double)k - 1.0) / ((double)this.gspNumMax - 1.0);
            this.gspX = Math.acos(hk);
            double prev_lon = this.gspY;
            double lon = prev_lon + 3.6 / Math.sqrt(this.gspNumMax) / Math.sqrt(1.0 - hk * hk);
            this.gspY = lon % (Math.PI * 2);
        } else {
            this.gspX = 0.0;
            this.gspY = 0.0;
        }
        ++this.gspNum;
    }

    private Vec3 getSpherical2cartesian() {
        double dx = Math.sin(this.gspX) * Math.cos(this.gspY);
        double dz = Math.sin(this.gspX) * Math.sin(this.gspY);
        double dy = Math.cos(this.gspX);
        return Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
    }

    public void collectTip(int count) {
        TimeAnalyzer.startCount("collect");
        int amountProcessed = 0;
        while (this.gspNumMax >= this.gspNum) {
            Vec3 vec = this.getSpherical2cartesian();
            int length = (int)Math.ceil(this.strength);
            float res = this.strength;
            FloatTriplet lastPos = null;
            HashSet<ChunkCoordIntPair> chunkCoords = new HashSet<ChunkCoordIntPair>();
            for (int i = 0; i < length && i <= this.length; ++i) {
                float x0 = (float)((double)this.posX + vec.field_72450_a * (double)i);
                float y0 = (float)((double)this.posY + vec.field_72448_b * (double)i);
                float z0 = (float)((double)this.posZ + vec.field_72449_c * (double)i);
                int iX = (int)Math.floor(x0);
                int iY = (int)Math.floor(y0);
                int iZ = (int)Math.floor(z0);
                double fac = 100.0 - (double)i / (double)length * 100.0;
                fac *= 0.07;
                Block block = null;
                boolean withinThreshold = (double)i / (double)length <= ExplosionTests.BUFFER_THRESHOLD;
                Float buffered = withinThreshold ? this.buffer.getBufferedResult(iX, iY, iZ) : null;
                float f = 0.0f;
                if (buffered == null) {
                    block = this.world.getBlock(iX, iY, iZ);
                    if (!block.func_149688_o().func_76224_d()) {
                        f = (float)Math.pow(block.func_149638_a(null), 7.5 - fac);
                    }
                    if (withinThreshold) {
                        this.buffer.setBufferedResult(iX, iY, iZ, f);
                    }
                } else {
                    f = buffered.floatValue();
                }
                if ((res -= f) > 0.0f && block != Blocks.field_150350_a && buffered == null) {
                    lastPos = new FloatTriplet(x0, y0, z0);
                    ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(iX >> 4, iZ >> 4);
                    chunkCoords.add(chunkPos);
                }
                if (res <= 0.0f || i + 1 >= this.length) break;
            }
            for (ChunkCoordIntPair pos : chunkCoords) {
                List<FloatTriplet> triplets = this.perChunk.get(pos);
                if (triplets == null) {
                    triplets = new ArrayList<FloatTriplet>();
                    this.perChunk.put(pos, triplets);
                }
                triplets.add(lastPos);
            }
            this.generateGspUp();
            if (++amountProcessed < count) continue;
            TimeAnalyzer.endCount();
            return;
        }
        this.orderedChunks.addAll(this.perChunk.keySet());
        this.orderedChunks.sort(this.comparator);
        this.isCollectionComplete = true;
        TimeAnalyzer.endCount();
    }

    public MK5Frame setBuffer(ResultBuffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public void processChunk() {
        TimeAnalyzer.startCount("processChunk");
        if (this.perChunk.isEmpty()) {
            TimeAnalyzer.endCount();
            return;
        }
        ChunkCoordIntPair coord = this.orderedChunks.get(0);
        List<FloatTriplet> list = this.perChunk.get(coord);
        HashSet<BlockPos> toRem = new HashSet<BlockPos>();
        int chunkX = coord.field_77276_a;
        int chunkZ = coord.field_77275_b;
        int enter = Math.min(Math.abs(this.posX - (chunkX << 4)), Math.abs(this.posZ - (chunkZ << 4))) - 16;
        block0: for (FloatTriplet triplet : list) {
            float x = triplet.xCoord;
            float y = triplet.yCoord;
            float z = triplet.zCoord;
            Vec3 vec = Vec3.func_72443_a((double)(x - (float)this.posX), (double)(y - (float)this.posY), (double)(z - (float)this.posZ));
            double pX = vec.field_72450_a / vec.func_72433_c();
            double pY = vec.field_72448_b / vec.func_72433_c();
            double pZ = vec.field_72449_c / vec.func_72433_c();
            boolean inChunk = false;
            int i = enter;
            while ((double)i < vec.func_72433_c()) {
                int x0 = (int)Math.floor((double)this.posX + pX * (double)i);
                int y0 = (int)Math.floor((double)this.posY + pY * (double)i);
                int z0 = (int)Math.floor((double)this.posZ + pZ * (double)i);
                if (x0 >> 4 != chunkX || z0 >> 4 != chunkZ) {
                    if (inChunk) {
                        continue block0;
                    }
                } else {
                    inChunk = true;
                    if (!this.world.isAirBlock(x0, y0, z0)) {
                        toRem.add(new BlockPos(x0, y0, z0));
                    }
                }
                ++i;
            }
        }
        for (BlockPos pos : toRem) {
            this.world.setBlock(pos.getX(), pos.getY(), pos.getZ(), Blocks.field_150350_a);
        }
        this.perChunk.remove(coord);
        this.orderedChunks.remove(0);
        TimeAnalyzer.endCount();
    }

    public class FloatTriplet {
        public float xCoord;
        public float yCoord;
        public float zCoord;

        public FloatTriplet(float x, float y, float z) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
        }
    }

    public class CoordComparator
    implements Comparator<ChunkCoordIntPair> {
        @Override
        public int compare(ChunkCoordIntPair o1, ChunkCoordIntPair o2) {
            int diff2;
            int chunkX = MK5Frame.this.posX >> 4;
            int chunkZ = MK5Frame.this.posZ >> 4;
            int diff1 = Math.abs(chunkX - o1.field_77276_a) + Math.abs(chunkZ - o1.field_77275_b);
            return diff1 > (diff2 = Math.abs(chunkX - o2.field_77276_a) + Math.abs(chunkZ - o2.field_77275_b)) ? 1 : (diff1 < diff2 ? -1 : 0);
        }
    }

    public static class BufferArray
    implements ResultBuffer {
        BlockPos center;
        Float[][][] buffer;
        int size;
        HashMap<BlockPos, Float> map = new HashMap();

        public BufferArray(int x, int y, int z, int size) {
            this.size = (int)((double)size * 2.1);
            this.center = new BlockPos(x, y, z);
            this.buffer = new Float[this.size][256][this.size];
        }

        @Override
        public Float getBufferedResult(int x, int y, int z) {
            if (y < 0 || y > 255) {
                return null;
            }
            int iX = x - this.center.getX() + this.size * 100;
            int iZ = z - this.center.getZ() + this.size * 100;
            return this.buffer[iX % this.size][y][iZ % this.size];
        }

        @Override
        public void setBufferedResult(int x, int y, int z, float f) {
            if (y < 0 || y > 255) {
                return;
            }
            int iX = x - this.center.getX() + this.size * 100;
            int iZ = z - this.center.getZ() + this.size * 100;
            this.buffer[iX % this.size][y][iZ % this.size] = Float.valueOf(f);
        }
    }

    public static class BufferMap
    implements ResultBuffer {
        HashMap<BlockPos, Float> map = new HashMap();

        @Override
        public Float getBufferedResult(int x, int y, int z) {
            if (y < 0 || y > 255) {
                return null;
            }
            return this.map.get(new BlockPos(x, y, z));
        }

        @Override
        public void setBufferedResult(int x, int y, int z, float f) {
            if (y < 0 || y > 255) {
                return;
            }
            this.map.put(new BlockPos(x, y, z), Float.valueOf(f));
        }
    }

    public static class BufferNone
    implements ResultBuffer {
        @Override
        public Float getBufferedResult(int x, int y, int z) {
            return null;
        }

        @Override
        public void setBufferedResult(int x, int y, int z, float f) {
        }
    }

    public static interface ResultBuffer {
        public Float getBufferedResult(int var1, int var2, int var3);

        public void setBufferedResult(int var1, int var2, int var3, float var4);
    }
}

