/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.config.VersatileConfig;
import com.hbm.interfaces.ICustomWarhead;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface IRadioisotopeFuel {
    public static final String lifeKey = "PELLET_DEPLETION";

    public long getMaxLifespan();

    @CheckForNull
    public ItemStack getDecayItem();

    public IRadioisotopeFuel setDecays(@Nonnull ItemStack var1, long var2);

    public boolean getDoesDecay();

    public short getHeat();

    public static short getScaledPower(IRadioisotopeFuel fuel, ItemStack stack) {
        return (short)Math.ceil((long)fuel.getHeat() * (fuel.getLifespan(stack) * fuel.getMaxLifespan()));
    }

    @CheckForNull
    public static IRadioisotopeFuel getInstance(Item item) {
        return item instanceof IRadioisotopeFuel ? (IRadioisotopeFuel)item : null;
    }

    @CheckForNull
    public static IRadioisotopeFuel getInstance(ItemStack stack) {
        return stack == null ? null : IRadioisotopeFuel.getInstance(stack.func_77973_b());
    }

    default public void decay(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IRadioisotopeFuel) {
            if (!((IRadioisotopeFuel)stack.func_77973_b()).getDoesDecay()) {
                return;
            }
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a(lifeKey, this.getLifespan(stack) - 1L);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a(lifeKey, this.getMaxLifespan());
            }
        }
    }

    default public long getLifespan(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IRadioisotopeFuel) {
            if (stack.func_77942_o()) {
                return stack.field_77990_d.func_74763_f(lifeKey);
            }
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a(lifeKey, this.getMaxLifespan());
            return this.getMaxLifespan();
        }
        return 0L;
    }

    public static ItemStack handleDecay(ItemStack stack, IRadioisotopeFuel instance) {
        if (instance.getDoesDecay() && VersatileConfig.rtgDecay()) {
            if (instance.getLifespan(stack) <= 0L) {
                return instance.getDecayItem();
            }
            instance.decay(stack);
        }
        return stack;
    }

    public static long getLifespan(float halfLife, ICustomWarhead.SaltedFuel.HalfLifeType type, boolean realYears) {
        float life = 0.0f;
        switch (type) {
            case LONG: {
                life = (float)(48000 * (realYears ? 365 : 100) * 100) * halfLife;
                break;
            }
            case MEDIUM: {
                life = (float)(48000 * (realYears ? 365 : 100)) * halfLife;
                break;
            }
            case SHORT: {
                life = 48000.0f * halfLife;
            }
        }
        return (long)life;
    }

    public static void addTooltip(List<String> tooltip, ItemStack stack, boolean showAdv) {
        IRadioisotopeFuel instance = (IRadioisotopeFuel)stack.func_77973_b();
        tooltip.add(I18nUtil.resolveKey("desc.item.rtgHeat", instance.getDoesDecay() && VersatileConfig.scaleRTGPower() ? IRadioisotopeFuel.getScaledPower(instance, stack) : instance.getHeat()));
        if (instance.getDoesDecay()) {
            tooltip.add(I18nUtil.resolveKey("desc.item.rtgDecay", I18nUtil.resolveKey(instance.getDecayItem().func_77977_a() + ".name", new Object[0]), instance.getDecayItem().field_77994_a));
            tooltip.add(BobMathUtil.toPercentage(instance.getLifespan(stack), instance.getMaxLifespan()));
            if (showAdv) {
                tooltip.add("EXTENDED INFO:");
                tooltip.add(String.format(Locale.US, "%s / %s ticks", instance.getLifespan(stack), instance.getMaxLifespan()));
                String[] timeLeft = BobMathUtil.ticksToDate(instance.getLifespan(stack));
                String[] maxLife = BobMathUtil.ticksToDate(instance.getMaxLifespan());
                tooltip.add(String.format(Locale.US, "Time remaining: %s y, %s d, %s h", (Object[])timeLeft));
                tooltip.add(String.format(Locale.US, "Maximum life: %s y, %s d, %s h", (Object[])maxLife));
            }
        }
    }

    public static double getDuraBar(ItemStack stack) {
        IRadioisotopeFuel instance = (IRadioisotopeFuel)stack.func_77973_b();
        return 1.0 - (double)instance.getLifespan(stack) / (double)instance.getMaxLifespan();
    }
}

