/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import api.hbm.block.ICrucibleAcceptor;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidConnectorMK2;
import api.hbm.fluidmk2.IFluidReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardSenderMK2;
import api.hbm.fluidmk2.IFluidUserMK2;
import api.hbm.tile.IHeatSource;
import api.ntm1of90.compat.fluid.bridge.NTMFluidNetworkBridge;
import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.material.Mats;
import com.hbm.tileentity.IConditionalInvAccess;
import com.hbm.tileentity.TileEntityProxyBase;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="com.hbm.handler.CompatHandler.OCComponent", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityProxyCombo
extends TileEntityProxyBase
implements IEnergyReceiverMK2,
ISidedInventory,
IFluidReceiverMK2,
IHeatSource,
ICrucibleAcceptor,
SimpleComponent,
CompatHandler.OCComponent,
IFluidHandler {
    TileEntity tile;
    boolean inventory;
    boolean power;
    boolean fluid;
    boolean heat;
    public boolean moltenMetal;
    String componentName = "ntm_null";
    public static final FluidTank[] EMPTY_TANKS = new FluidTank[0];

    public TileEntityProxyCombo() {
    }

    public TileEntityProxyCombo(boolean inventory, boolean power, boolean fluid) {
        this.inventory = inventory;
        this.power = power;
        this.fluid = fluid;
    }

    public TileEntityProxyCombo inventory() {
        this.inventory = true;
        return this;
    }

    public TileEntityProxyCombo power() {
        this.power = true;
        return this;
    }

    public TileEntityProxyCombo moltenMetal() {
        this.moltenMetal = true;
        return this;
    }

    public TileEntityProxyCombo fluid() {
        this.fluid = true;
        return this;
    }

    public TileEntityProxyCombo heatSource() {
        this.heat = true;
        return this;
    }

    public TileEntity getTile() {
        if (this.tile == null || this.tile.func_145837_r()) {
            this.tile = this.getTE();
        }
        return this.tile;
    }

    @Override
    public void setPower(long i) {
        if (!this.power) {
            return;
        }
        if (this.getTile() instanceof IEnergyReceiverMK2) {
            ((IEnergyReceiverMK2)this.getTile()).setPower(i);
        }
    }

    @Override
    public long getPower() {
        if (!this.power) {
            return 0L;
        }
        if (this.getTile() instanceof IEnergyReceiverMK2) {
            return ((IEnergyReceiverMK2)this.getTile()).getPower();
        }
        return 0L;
    }

    @Override
    public long getMaxPower() {
        if (!this.power) {
            return 0L;
        }
        if (this.getTile() instanceof IEnergyReceiverMK2) {
            return ((IEnergyReceiverMK2)this.getTile()).getMaxPower();
        }
        return 0L;
    }

    @Override
    public long transferPower(long power) {
        if (!this.power) {
            return power;
        }
        if (this.getTile() instanceof IEnergyReceiverMK2) {
            return ((IEnergyReceiverMK2)this.getTile()).transferPower(power);
        }
        return power;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        if (!this.power) {
            return false;
        }
        if (this.getTile() instanceof IEnergyReceiverMK2) {
            return ((IEnergyReceiverMK2)this.getTile()).canConnect(dir);
        }
        return true;
    }

    @Override
    public FluidTank[] getAllTanks() {
        if (!this.fluid) {
            return EMPTY_TANKS;
        }
        if (this.getTile() instanceof IFluidReceiverMK2) {
            return ((IFluidReceiverMK2)this.getTile()).getAllTanks();
        }
        return EMPTY_TANKS;
    }

    @Override
    public long transferFluid(FluidType type, int pressure, long amount) {
        if (!this.fluid) {
            return amount;
        }
        if (this.getTile() instanceof IFluidReceiverMK2) {
            return ((IFluidReceiverMK2)this.getTile()).transferFluid(type, pressure, amount);
        }
        return amount;
    }

    @Override
    public long getDemand(FluidType type, int pressure) {
        if (!this.fluid) {
            return 0L;
        }
        if (this.getTile() instanceof IFluidReceiverMK2) {
            return ((IFluidReceiverMK2)this.getTile()).getDemand(type, pressure);
        }
        return 0L;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        if (!this.fluid) {
            return false;
        }
        if (this.getTile() instanceof IFluidConnectorMK2) {
            return ((IFluidConnectorMK2)this.getTile()).canConnect(type, dir);
        }
        return true;
    }

    public int func_70302_i_() {
        if (!this.inventory) {
            return 0;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.inventory) {
            return null;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70301_a(slot);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70298_a(i, j);
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (!this.inventory) {
            return null;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70304_b(slot);
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.inventory) {
            return;
        }
        if (this.getTile() instanceof ISidedInventory) {
            ((ISidedInventory)this.getTile()).func_70299_a(slot, stack);
        }
    }

    public String func_145825_b() {
        if (!this.inventory) {
            return null;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_145825_b();
        }
        return null;
    }

    public boolean func_145818_k_() {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_145818_k_();
        }
        return false;
    }

    public int func_70297_j_() {
        if (!this.inventory) {
            return 0;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70300_a(player);
        }
        return false;
    }

    public void func_70295_k_() {
        if (!this.inventory) {
            return;
        }
        if (this.getTile() instanceof ISidedInventory) {
            ((ISidedInventory)this.getTile()).func_70295_k_();
        }
    }

    public void func_70305_f() {
        if (!this.inventory) {
            return;
        }
        if (this.getTile() instanceof ISidedInventory) {
            ((ISidedInventory)this.getTile()).func_70305_f();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            if (this.getTile() instanceof IConditionalInvAccess) {
                return ((IConditionalInvAccess)this.getTile()).isItemValidForSlot(this.field_145851_c, this.field_145848_d, this.field_145849_e, slot, stack);
            }
            return ((ISidedInventory)this.getTile()).func_94041_b(slot, stack);
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        if (!this.inventory) {
            return new int[0];
        }
        if (this.getTile() instanceof ISidedInventory) {
            if (this.getTile() instanceof IConditionalInvAccess) {
                return ((IConditionalInvAccess)this.getTile()).getAccessibleSlotsFromSide(this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
            }
            return ((ISidedInventory)this.getTile()).func_94128_d(side);
        }
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack stack, int j) {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            if (this.getTile() instanceof IConditionalInvAccess) {
                return ((IConditionalInvAccess)this.getTile()).canInsertItem(this.field_145851_c, this.field_145848_d, this.field_145849_e, i, stack, j);
            }
            return ((ISidedInventory)this.getTile()).func_102007_a(i, stack, j);
        }
        return false;
    }

    public boolean func_102008_b(int i, ItemStack stack, int j) {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            if (this.getTile() instanceof IConditionalInvAccess) {
                return ((IConditionalInvAccess)this.getTile()).canExtractItem(this.field_145851_c, this.field_145848_d, this.field_145849_e, i, stack, j);
            }
            return ((ISidedInventory)this.getTile()).func_102008_b(i, stack, j);
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory = nbt.func_74767_n("inv");
        this.power = nbt.func_74767_n("power");
        this.fluid = nbt.func_74767_n("fluid");
        this.moltenMetal = nbt.func_74767_n("metal");
        this.heat = nbt.func_74767_n("heat");
        if (Loader.isModLoaded((String)"OpenComputers")) {
            this.componentName = nbt.func_74779_i("ocname");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("inv", this.inventory);
        nbt.func_74757_a("power", this.power);
        nbt.func_74757_a("fluid", this.fluid);
        nbt.func_74757_a("metal", this.moltenMetal);
        nbt.func_74757_a("heat", this.heat);
        if (Loader.isModLoaded((String)"OpenComputers")) {
            nbt.func_74778_a("ocname", this.componentName);
        }
    }

    @Override
    public int getHeatStored() {
        if (!this.heat) {
            return 0;
        }
        if (this.getTile() instanceof IHeatSource) {
            return ((IHeatSource)this.getTile()).getHeatStored();
        }
        return 0;
    }

    @Override
    public void useUpHeat(int heat) {
        if (!this.heat) {
            return;
        }
        if (this.getTile() instanceof IHeatSource) {
            ((IHeatSource)this.getTile()).useUpHeat(heat);
        }
    }

    @Override
    public boolean canAcceptPartialPour(World world, int x, int y, int z, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        if (this.moltenMetal && this.getTile() instanceof ICrucibleAcceptor) {
            return ((ICrucibleAcceptor)this.getTile()).canAcceptPartialPour(world, x, y, z, dX, dY, dZ, side, stack);
        }
        return false;
    }

    @Override
    public Mats.MaterialStack pour(World world, int x, int y, int z, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        if (this.moltenMetal && this.getTile() instanceof ICrucibleAcceptor) {
            return ((ICrucibleAcceptor)this.getTile()).pour(world, x, y, z, dX, dY, dZ, side, stack);
        }
        return null;
    }

    @Override
    public boolean canAcceptPartialFlow(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        if (this.moltenMetal && this.getTile() instanceof ICrucibleAcceptor) {
            return ((ICrucibleAcceptor)this.getTile()).canAcceptPartialFlow(world, x, y, z, side, stack);
        }
        return false;
    }

    @Override
    public Mats.MaterialStack flow(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        if (this.moltenMetal && this.getTile() instanceof ICrucibleAcceptor) {
            return ((ICrucibleAcceptor)this.getTile()).flow(world, x, y, z, side, stack);
        }
        return null;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        if (this.field_145850_b == null) {
            return this.componentName;
        }
        if (this.getTile() instanceof CompatHandler.OCComponent) {
            if (this.componentName == null || this.componentName.equals(CompatHandler.OCComponent.super.getComponentName())) {
                this.componentName = ((CompatHandler.OCComponent)this.getTile()).getComponentName();
            }
            return this.componentName;
        }
        return CompatHandler.OCComponent.super.getComponentName();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public boolean canConnectNode(ForgeDirection side) {
        if (this.getTile() instanceof CompatHandler.OCComponent) {
            return this.func_145832_p() >= 6 && this.func_145832_p() <= 11 && (this.power || this.fluid) && ((CompatHandler.OCComponent)this.getTile()).canConnectNode(side);
        }
        return CompatHandler.OCComponent.super.canConnectNode(null);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        if (this.getTile() instanceof CompatHandler.OCComponent) {
            return ((CompatHandler.OCComponent)this.getTile()).methods();
        }
        return CompatHandler.OCComponent.super.methods();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        if (this.getTile() instanceof CompatHandler.OCComponent) {
            return ((CompatHandler.OCComponent)this.getTile()).invoke(method, context, args);
        }
        return CompatHandler.OCComponent.super.invoke(null, null, null);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.fluid || resource == null || resource.amount <= 0) {
            return 0;
        }
        TileEntity te = this.getTile();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(from, resource, doFill);
        }
        if (te instanceof IFluidReceiverMK2) {
            return NTMFluidNetworkBridge.fillFromForge((IFluidReceiverMK2)te, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.fluid || resource == null || resource.amount <= 0) {
            return null;
        }
        TileEntity te = this.getTile();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).drain(from, resource, doDrain);
        }
        if (te instanceof IFluidStandardSenderMK2) {
            return NTMFluidNetworkBridge.drainToForge((IFluidStandardSenderMK2)te, resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.fluid || maxDrain <= 0) {
            return null;
        }
        TileEntity te = this.getTile();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).drain(from, maxDrain, doDrain);
        }
        if (te instanceof IFluidStandardSenderMK2) {
            return NTMFluidNetworkBridge.drainToForge((IFluidStandardSenderMK2)te, maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.fluid) {
            return false;
        }
        TileEntity te = this.getTile();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).canFill(from, fluid);
        }
        if (te instanceof IFluidReceiverMK2) {
            FluidType type = FluidMappingRegistry.getHbmFluidType(fluid);
            return type != Fluids.NONE && ((IFluidReceiverMK2)te).canConnect(type, from);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.fluid) {
            return false;
        }
        TileEntity te = this.getTile();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).canDrain(from, fluid);
        }
        if (te instanceof IFluidStandardSenderMK2) {
            FluidType type = FluidMappingRegistry.getHbmFluidType(fluid);
            return type != Fluids.NONE && ((IFluidConnectorMK2)te).canConnect(type, from);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.fluid) {
            return new FluidTankInfo[0];
        }
        TileEntity te = this.getTile();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).getTankInfo(from);
        }
        if (te instanceof IFluidUserMK2) {
            return NTMFluidNetworkBridge.getTankInfo((IFluidUserMK2)te);
        }
        return new FluidTankInfo[0];
    }

    static {
        FluidMappingRegistry.initialize();
    }
}

