/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.item.IDesignatorItem;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.handler.MissileStruct;
import com.hbm.inventory.container.ContainerCompactLauncher;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineCompactLauncher;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomMissile;
import com.hbm.items.weapon.ItemCustomMissilePart;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.TEMissileMultipartPacket;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IRadarCommandReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCompactLauncher
extends TileEntityLoadedBase
implements ISidedInventory,
IEnergyReceiverMK2,
IFluidStandardReceiver,
IGUIProvider,
IBufPacketReceiver,
IRadarCommandReceiver {
    private ItemStack[] slots = new ItemStack[8];
    public long power;
    public static final long maxPower = 100000L;
    public int solid;
    public static final int maxSolid = 25000;
    public FluidTank[] tanks = new FluidTank[2];
    public MissileStruct load;
    private static final int[] access = new int[]{0};
    private String customName;

    public TileEntityCompactLauncher() {
        this.tanks[0] = new FluidTank(Fluids.NONE, 25000);
        this.tanks[1] = new FluidTank(Fluids.NONE, 25000);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.compactLauncher";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public int getSolidScaled(int i) {
        return this.solid * i / 25000;
    }

    public void func_145845_h() {
        block10: {
            if (!this.field_145850_b.field_72995_K) {
                this.updateTypes();
                this.tanks[0].loadTank(2, 6, this.slots);
                this.tanks[1].loadTank(3, 7, this.slots);
                this.power = Library.chargeTEFromItems(this.slots, 5, this.power, 100000L);
                if (this.slots[4] != null && this.slots[4].func_77973_b() == ModItems.rocket_fuel && this.solid + 250 <= 25000) {
                    this.func_70298_a(4, 1);
                    this.solid += 250;
                }
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.updateConnections();
                }
                this.networkPackNT(50);
                MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.slots[0]);
                if (multipart != null) {
                    PacketDispatcher.wrapper.sendToAllAround(new TEMissileMultipartPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, multipart), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
                } else {
                    PacketDispatcher.wrapper.sendToAllAround(new TEMissileMultipartPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, new MissileStruct()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (!this.field_145850_b.func_72864_z(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z) || !this.canLaunch()) continue;
                        this.launchFromDesignator();
                        break block10;
                    }
                }
            } else {
                List entities = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 10), (double)((double)this.field_145849_e + 1.5)));
                for (Entity e : entities) {
                    if (!(e instanceof EntityMissileCustom)) continue;
                    for (int i = 0; i < 15; ++i) {
                        boolean dir = this.field_145850_b.field_73012_v.nextBoolean();
                        float moX = (float)(dir ? 0.0 : this.field_145850_b.field_73012_v.nextGaussian() * 0.5);
                        float moZ = (float)(!dir ? 0.0 : this.field_145850_b.field_73012_v.nextGaussian() * 0.5);
                        NBTTagCompound data = new NBTTagCompound();
                        data.func_74780_a("posX", (double)this.field_145851_c + 0.5);
                        data.func_74780_a("posY", (double)this.field_145848_d + 0.25);
                        data.func_74780_a("posZ", (double)this.field_145849_e + 0.5);
                        data.func_74778_a("type", "launchSmoke");
                        data.func_74780_a("moX", (double)moX);
                        data.func_74780_a("moY", 0.0);
                        data.func_74780_a("moZ", (double)moZ);
                        MainRegistry.proxy.effectNT(data);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeLong(this.power);
        buf.writeInt(this.solid);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.power = buf.readLong();
        this.solid = buf.readInt();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e + 1, Library.NEG_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e - 1, Library.NEG_Y), new DirPos(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e + 1, Library.NEG_Y), new DirPos(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e - 1, Library.NEG_Y)};
    }

    public boolean canLaunch() {
        return (double)this.power >= 75000.0 && this.isMissileValid() && this.hasDesignator() && this.hasFuel();
    }

    @Override
    public boolean sendCommandEntity(Entity target) {
        return this.sendCommandPosition((int)Math.floor(target.field_70165_t), this.field_145848_d, (int)Math.floor(target.field_70165_t));
    }

    @Override
    public boolean sendCommandPosition(int x, int y, int z) {
        if (!this.canLaunch()) {
            return false;
        }
        this.launchTo(x, z);
        return true;
    }

    public void launchFromDesignator() {
        IDesignatorItem designator;
        if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IDesignatorItem && (designator = (IDesignatorItem)this.slots[1].func_77973_b()).isReady(this.field_145850_b, this.slots[1], this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            Vec3 coords = designator.getCoords(this.field_145850_b, this.slots[1], this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int tX = (int)Math.floor(coords.field_72450_a);
            int tZ = (int)Math.floor(coords.field_72449_c);
            this.launchTo(tX, tZ);
        }
    }

    public void launchTo(int tX, int tZ) {
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:weapon.missileTakeOff", 10.0f, 1.0f);
        ItemCustomMissilePart chip = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(this.slots[0], "chip"));
        float c = ((Float)chip.attributes[0]).floatValue();
        float f = 1.0f;
        if (TileEntityCompactLauncher.getStruct((ItemStack)this.slots[0]).fins != null) {
            ItemCustomMissilePart fins = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(this.slots[0], "stability"));
            f = ((Float)fins.attributes[0]).floatValue();
        }
        Vec3 target = Vec3.func_72443_a((double)(this.field_145851_c - tX), (double)0.0, (double)(this.field_145849_e - tZ));
        target.field_72450_a *= (double)(c * f);
        target.field_72449_c *= (double)(c * f);
        target.func_72442_b(this.field_145850_b.field_73012_v.nextFloat() * 360.0f);
        EntityMissileCustom missile = new EntityMissileCustom(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 2.5f, (float)this.field_145849_e + 0.5f, tX + (int)target.field_72450_a, tZ + (int)target.field_72449_c, TileEntityCompactLauncher.getStruct(this.slots[0]));
        this.field_145850_b.func_72838_d((Entity)missile);
        this.subtractFuel();
        this.slots[0] = null;
    }

    private boolean hasFuel() {
        return this.solidState() != 0 && this.liquidState() != 0 && this.oxidizerState() != 0;
    }

    private void subtractFuel() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return;
        }
        ItemCustomMissilePart fuselage = multipart.fuselage;
        float f = ((Float)fuselage.attributes[1]).floatValue();
        int fuel = (int)f;
        switch ((ItemCustomMissilePart.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: {
                this.tanks[0].setFill(this.tanks[0].getFill() - fuel);
                this.tanks[1].setFill(this.tanks[1].getFill() - fuel);
                break;
            }
            case HYDROGEN: {
                this.tanks[0].setFill(this.tanks[0].getFill() - fuel);
                this.tanks[1].setFill(this.tanks[1].getFill() - fuel);
                break;
            }
            case XENON: {
                this.tanks[0].setFill(this.tanks[0].getFill() - fuel);
                break;
            }
            case BALEFIRE: {
                this.tanks[0].setFill(this.tanks[0].getFill() - fuel);
                this.tanks[1].setFill(this.tanks[1].getFill() - fuel);
                break;
            }
            case SOLID: {
                this.solid -= fuel;
                break;
            }
        }
        this.power = (long)((double)this.power - 75000.0);
    }

    public static MissileStruct getStruct(ItemStack stack) {
        return ItemCustomMissile.getStruct(stack);
    }

    public boolean isMissileValid() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return false;
        }
        ItemCustomMissilePart fuselage = multipart.fuselage;
        return fuselage.top == ItemCustomMissilePart.PartSize.SIZE_10;
    }

    public boolean hasDesignator() {
        return this.slots[1] != null && this.slots[1].func_77973_b() instanceof IDesignatorItem && ((IDesignatorItem)this.slots[1].func_77973_b()).isReady(this.field_145850_b, this.slots[1], this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int solidState() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return -1;
        }
        ItemCustomMissilePart fuselage = multipart.fuselage;
        if ((ItemCustomMissilePart.FuelType)((Object)fuselage.attributes[0]) == ItemCustomMissilePart.FuelType.SOLID) {
            if ((float)this.solid >= ((Float)fuselage.attributes[1]).floatValue()) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int liquidState() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return -1;
        }
        ItemCustomMissilePart fuselage = multipart.fuselage;
        switch ((ItemCustomMissilePart.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: 
            case HYDROGEN: 
            case XENON: 
            case BALEFIRE: {
                if ((float)this.tanks[0].getFill() >= ((Float)fuselage.attributes[1]).floatValue()) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    public int oxidizerState() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return -1;
        }
        ItemCustomMissilePart fuselage = multipart.fuselage;
        switch ((ItemCustomMissilePart.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: 
            case HYDROGEN: 
            case BALEFIRE: {
                if ((float)this.tanks[1].getFill() >= ((Float)fuselage.attributes[1]).floatValue()) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    public void updateTypes() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return;
        }
        ItemCustomMissilePart fuselage = multipart.fuselage;
        switch ((ItemCustomMissilePart.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: {
                this.tanks[0].setTankType(Fluids.KEROSENE);
                this.tanks[1].setTankType(Fluids.PEROXIDE);
                break;
            }
            case HYDROGEN: {
                this.tanks[0].setTankType(Fluids.HYDROGEN);
                this.tanks[1].setTankType(Fluids.OXYGEN);
                break;
            }
            case XENON: {
                this.tanks[0].setTankType(Fluids.XENON);
                break;
            }
            case BALEFIRE: {
                this.tanks[0].setTankType(Fluids.BALEFIRE);
                this.tanks[1].setTankType(Fluids.PEROXIDE);
                break;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.tanks[0].readFromNBT(nbt, "fuel");
        this.tanks[1].readFromNBT(nbt, "oxidizer");
        this.solid = nbt.func_74762_e("solidfuel");
        this.power = nbt.func_74763_f("power");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        this.tanks[0].writeToNBT(nbt, "fuel");
        this.tanks[1].writeToNBT(nbt, "oxidizer");
        nbt.func_74768_a("solidfuel", this.solid);
        nbt.func_74772_a("power", this.power);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return access;
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public long transferPower(long power) {
        this.power += power;
        if (this.power > this.getMaxPower()) {
            long overshoot = this.power - this.getMaxPower();
            this.power = this.getMaxPower();
            return overshoot;
        }
        return 0L;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.UNKNOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.UNKNOWN;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCompactLauncher(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCompactLauncher(player.field_71071_by, this);
    }
}

