/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.bomb.TileEntityLaunchPadBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLaunchPadLarge
extends TileEntityLaunchPadBase {
    public int formFactor = -1;
    public boolean erected = false;
    public boolean readyToLoad = false;
    public boolean scheduleErect = false;
    public float lift = 1.0f;
    public float erector = 90.0f;
    public float prevLift = 1.0f;
    public float prevErector = 90.0f;
    public float syncLift;
    public float syncErector;
    private int sync;
    public int delay = 20;
    private AudioWrapper audioLift;
    private AudioWrapper audioErector;
    protected boolean liftMoving = false;
    protected boolean erectorMoving = false;
    AxisAlignedBB bb = null;

    @Override
    public boolean isReadyForLaunch() {
        return this.erected && this.readyToLoad;
    }

    @Override
    public double getLaunchOffset() {
        return 2.0;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.prevLift = this.lift;
            this.prevErector = this.erector;
            float erectorSpeed = 1.5f;
            float liftSpeed = 0.025f;
            if (this.isMissileValid()) {
                if (this.slots[0].func_77973_b() instanceof ItemMissile) {
                    ItemMissile missile = (ItemMissile)this.slots[0].func_77973_b();
                    this.formFactor = missile.formFactor.ordinal();
                    if (missile.formFactor == ItemMissile.MissileFormFactor.ATLAS || missile.formFactor == ItemMissile.MissileFormFactor.HUGE) {
                        erectorSpeed /= 2.0f;
                        liftSpeed /= 2.0f;
                    }
                }
                if (this.erector == 90.0f && this.lift == 1.0f) {
                    this.readyToLoad = true;
                }
            } else {
                this.readyToLoad = false;
                this.erected = false;
                this.delay = 20;
            }
            if (this.power >= 75000L) {
                if (this.delay > 0) {
                    --this.delay;
                    if (this.delay < 10 && this.scheduleErect) {
                        this.erected = true;
                        this.scheduleErect = false;
                    }
                    if (this.slots[0] == null || !this.readyToLoad) {
                        if (this.erector < 90.0f) {
                            this.erector = Math.min(this.erector + erectorSpeed, 90.0f);
                            if (this.erector == 90.0f) {
                                this.delay = 20;
                            }
                        } else if (this.lift < 1.0f) {
                            this.lift = Math.min(this.lift + liftSpeed, 1.0f);
                            if (this.erector == 1.0f) {
                                this.readyToLoad = true;
                                this.delay = 20;
                            }
                        }
                    }
                } else if (!this.erected && this.readyToLoad) {
                    this.state = 1;
                    if (this.erector != 0.0f) {
                        this.erector = Math.max(this.erector - erectorSpeed, 0.0f);
                        if (this.erector == 0.0f) {
                            this.delay = 20;
                        }
                    } else if (this.lift > 0.0f) {
                        this.lift = Math.max(this.lift - liftSpeed, 0.0f);
                        if (this.lift == 0.0f) {
                            this.scheduleErect = true;
                            this.delay = 20;
                        }
                    }
                } else if (this.erector < 90.0f) {
                    this.erector = Math.min(this.erector + erectorSpeed, 90.0f);
                    if (this.erector == 90.0f) {
                        this.delay = 20;
                    }
                } else if (this.lift < 1.0f) {
                    this.lift = Math.min(this.lift + liftSpeed, 1.0f);
                    if (this.erector == 1.0f) {
                        this.readyToLoad = true;
                        this.delay = 20;
                    }
                }
            }
            if (!this.hasFuel() || !this.isMissileValid()) {
                this.state = 0;
            }
            if (this.erected && this.canLaunch()) {
                this.state = 2;
            }
            boolean prevLiftMoving = this.liftMoving;
            boolean prevErectorMoving = this.erectorMoving;
            this.liftMoving = false;
            this.erectorMoving = false;
            if (this.prevLift != this.lift) {
                this.liftMoving = true;
            }
            if (this.prevErector != this.erector) {
                this.erectorMoving = true;
            }
            if (prevLiftMoving && !this.liftMoving) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:door.wgh_stop", 2.0f, 1.0f);
            }
            if (prevErectorMoving && !this.erectorMoving) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:door.garage_stop", 2.0f, 1.0f);
            }
        } else {
            List entities;
            int i;
            this.prevLift = this.lift;
            this.prevErector = this.erector;
            if (this.sync > 0) {
                this.lift += (this.syncLift - this.lift) / (float)this.sync;
                this.erector += (this.syncErector - this.erector) / (float)this.sync;
                --this.sync;
            } else {
                this.lift = this.syncLift;
                this.erector = this.syncErector;
            }
            if (this.liftMoving) {
                if (this.audioLift == null || !this.audioLift.isPlaying()) {
                    this.audioLift = MainRegistry.proxy.getLoopedSound("hbm:door.wgh_start", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.75f, 25.0f, 1.0f, 5);
                    this.audioLift.startSound();
                }
                this.audioLift.keepAlive();
            } else if (this.audioLift != null) {
                this.audioLift.stopSound();
                this.audioLift = null;
            }
            if (this.erectorMoving) {
                if (this.audioErector == null || !this.audioErector.isPlaying()) {
                    this.audioErector = MainRegistry.proxy.getLoopedSound("hbm:door.garage_move", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.5f, 25.0f, 1.0f, 5);
                    this.audioErector.startSound();
                }
                this.audioErector.keepAlive();
            } else if (this.audioErector != null) {
                this.audioErector.stopSound();
                this.audioErector = null;
            }
            if (this.erected && (this.formFactor == ItemMissile.MissileFormFactor.HUGE.ordinal() || this.formFactor == ItemMissile.MissileFormFactor.ATLAS.ordinal()) && this.tanks[1].getFill() > 0) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "tower");
                data.func_74776_a("lift", 0.0f);
                data.func_74776_a("base", 0.5f);
                data.func_74776_a("max", 2.0f);
                data.func_74768_a("life", 70 + this.field_145850_b.field_73012_v.nextInt(30));
                data.func_74780_a("posX", (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5);
                data.func_74780_a("posZ", (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5);
                data.func_74780_a("posY", (double)(this.field_145848_d + 2));
                data.func_74757_a("noWind", true);
                data.func_74776_a("alphaMod", 2.0f);
                data.func_74776_a("strafe", 0.05f);
                for (i = 0; i < 3; ++i) {
                    MainRegistry.proxy.effectNT(data);
                }
            }
            if (!(entities = this.field_145850_b.func_72872_a(EntityMissileBaseNT.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 10), (double)((double)this.field_145849_e + 1.5)))).isEmpty()) {
                for (i = 0; i < 15; ++i) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                    if (this.field_145850_b.field_73012_v.nextBoolean()) {
                        dir = dir.getOpposite();
                    }
                    float moX = (float)(this.field_145850_b.field_73012_v.nextGaussian() * (double)0.15f + 0.75) * (float)dir.offsetX;
                    float moZ = (float)(this.field_145850_b.field_73012_v.nextGaussian() * (double)0.15f + 0.75) * (float)dir.offsetZ;
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74780_a("posX", (double)this.field_145851_c + 0.5);
                    data.func_74780_a("posY", (double)this.field_145848_d + 0.25);
                    data.func_74780_a("posZ", (double)this.field_145849_e + 0.5);
                    data.func_74778_a("type", "launchSmoke");
                    data.func_74780_a("moX", (double)moX);
                    data.func_74780_a("moY", 0.0);
                    data.func_74780_a("moZ", (double)moZ);
                    MainRegistry.proxy.effectNT(data);
                }
            }
        }
        super.func_145845_h();
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.liftMoving);
        buf.writeBoolean(this.erectorMoving);
        buf.writeBoolean(this.erected);
        buf.writeBoolean(this.readyToLoad);
        buf.writeByte((int)((byte)this.formFactor));
        buf.writeFloat(this.lift);
        buf.writeFloat(this.erector);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.liftMoving = buf.readBoolean();
        this.erectorMoving = buf.readBoolean();
        this.erected = buf.readBoolean();
        this.readyToLoad = buf.readBoolean();
        this.formFactor = buf.readByte();
        this.syncLift = buf.readFloat();
        this.syncErector = buf.readFloat();
        if (this.lift != this.syncLift || this.erector != this.syncErector) {
            this.sync = 3;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.erected = nbt.func_74767_n("erected");
        this.readyToLoad = nbt.func_74767_n("readyToLoad");
        this.lift = nbt.func_74760_g("lift");
        this.erector = nbt.func_74760_g("erector");
        this.formFactor = nbt.func_74762_e("formFactor");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("erected", this.erected);
        nbt.func_74757_a("readyToLoad", this.readyToLoad);
        nbt.func_74776_a("lift", this.lift);
        nbt.func_74776_a("erector", this.erector);
        nbt.func_74768_a("formFactor", this.formFactor);
    }

    @Override
    public void finalizeLaunch(Entity missile) {
        super.finalizeLaunch(missile);
        this.erected = false;
    }

    @Override
    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 5, this.field_145848_d, this.field_145849_e - 2, Library.POS_X), new DirPos(this.field_145851_c + 5, this.field_145848_d, this.field_145849_e + 2, Library.POS_X), new DirPos(this.field_145851_c - 5, this.field_145848_d, this.field_145849_e - 2, Library.NEG_X), new DirPos(this.field_145851_c - 5, this.field_145848_d, this.field_145849_e + 2, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 5, Library.POS_Z), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 5, Library.POS_Z), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 5, Library.NEG_Z), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 5, Library.NEG_Z)};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 10), (double)this.field_145848_d, (double)(this.field_145849_e - 10), (double)(this.field_145851_c + 11), (double)(this.field_145848_d + 15), (double)(this.field_145849_e + 11));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

