/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IInfoProviderEC;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.saveddata.TomSaveData;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityLoadedBase;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class TileEntityCondenser
extends TileEntityLoadedBase
implements IFluidStandardTransceiver,
IInfoProviderEC,
IConfigurableMachine,
IBufPacketReceiver,
IFluidCopiable {
    public int age = 0;
    public FluidTank[] tanks = new FluidTank[2];
    public int waterTimer = 0;
    protected int throughput;
    public static int inputTankSize = 100;
    public static int outputTankSize = 100;

    public TileEntityCondenser() {
        this.tanks[0] = new FluidTank(Fluids.SPENTSTEAM, inputTankSize);
        this.tanks[1] = new FluidTank(Fluids.WATER, outputTankSize);
    }

    @Override
    public String getConfigName() {
        return "condenser";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        inputTankSize = IConfigurableMachine.grab(obj, "I:inputTankSize", inputTankSize);
        outputTankSize = IConfigurableMachine.grab(obj, "I:outputTankSize", outputTankSize);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:inputTankSize").value((long)inputTankSize);
        writer.name("I:outputTankSize").value((long)outputTankSize);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int convert;
            ++this.age;
            if (this.age >= 2) {
                this.age = 0;
            }
            if (this.waterTimer > 0) {
                --this.waterTimer;
            }
            this.throughput = convert = Math.min(this.tanks[0].getFill(), this.tanks[1].getMaxFill() - this.tanks[1].getFill());
            if (this.extraCondition(convert)) {
                this.tanks[0].setFill(this.tanks[0].getFill() - convert);
                if (convert > 0) {
                    this.waterTimer = 20;
                }
                int light = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if ((double)TomSaveData.forWorld((World)this.field_145850_b).fire > 1.0E-5 && light > 7) {
                    this.tanks[1].setFill(this.tanks[1].getFill() - convert);
                } else {
                    this.tanks[1].setFill(this.tanks[1].getFill() + convert);
                }
                this.postConvert(convert);
            }
            this.subscribeToAllAround(this.tanks[0].getTankType(), this);
            this.sendFluidToAll(this.tanks[1], this);
            this.networkPackNT(150);
        }
    }

    public void packExtra(NBTTagCompound data) {
    }

    public boolean extraCondition(int convert) {
        return true;
    }

    public void postConvert(int convert) {
    }

    @Override
    public void serialize(ByteBuf buf) {
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
        buf.writeByte(this.waterTimer);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.waterTimer = buf.readByte();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74780_a("consumption", (double)this.throughput);
        data.func_74780_a("outputmb", (double)this.throughput);
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

