/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.machine.TileEntityCondenser;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCondenserPowered
extends TileEntityCondenser
implements IEnergyReceiverMK2 {
    public long power;
    public float spin;
    public float lastSpin;
    public static long maxPower = 10000000L;
    public static int inputTankSizeP = 1000000;
    public static int outputTankSizeP = 1000000;
    public static int powerConsumption = 10;
    AxisAlignedBB bb = null;

    public TileEntityCondenserPowered() {
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.SPENTSTEAM, inputTankSizeP);
        this.tanks[1] = new FluidTank(Fluids.WATER, outputTankSizeP);
    }

    @Override
    public String getConfigName() {
        return "condenserPowered";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "L:maxPower", maxPower);
        inputTankSizeP = IConfigurableMachine.grab(obj, "I:inputTankSize", inputTankSizeP);
        outputTankSizeP = IConfigurableMachine.grab(obj, "I:outputTankSize", outputTankSizeP);
        powerConsumption = IConfigurableMachine.grab(obj, "I:powerConsumption", powerConsumption);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:maxPower").value(maxPower);
        writer.name("I:inputTankSize").value((long)inputTankSizeP);
        writer.name("I:outputTankSize").value((long)outputTankSizeP);
        writer.name("I:powerConsumption").value((long)powerConsumption);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.lastSpin = this.spin;
            if (this.waterTimer > 0) {
                this.spin += 30.0f;
                if (this.spin >= 360.0f) {
                    this.spin -= 360.0f;
                    this.lastSpin -= 360.0f;
                }
                if (this.field_145850_b.func_82737_E() % 4L == 0L) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                    this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 1.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 1.5, (double)dir.offsetX * 0.1, 0.0, (double)dir.offsetZ * 0.1);
                    this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 - (double)dir.offsetX * 1.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5 - (double)dir.offsetZ * 1.5, (double)dir.offsetX * -0.1, 0.0, (double)dir.offsetZ * -0.1);
                }
            }
        }
    }

    @Override
    public void packExtra(NBTTagCompound data) {
        data.func_74772_a("power", this.power);
    }

    @Override
    public boolean extraCondition(int convert) {
        return this.power >= (long)(convert * 10);
    }

    @Override
    public void postConvert(int convert) {
        this.power -= (long)(convert * powerConsumption);
        if (this.power < 0L) {
            this.power = 0L;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
        buf.writeByte(this.waterTimer);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.waterTimer = buf.readByte();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
    }

    @Override
    public void subscribeToAllAround(FluidType type, TileEntity te) {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    @Override
    public void sendFluidToAll(FluidTank tank, TileEntity te) {
        for (DirPos pos : this.getConPos()) {
            this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 4, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * 4, rot), new DirPos(this.field_145851_c - rot.offsetX * 4, this.field_145848_d + 1, this.field_145849_e - rot.offsetZ * 4, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX, this.field_145848_d + 1, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d + 1, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite())};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }
}

