/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.container.ContainerCoreStabilizer;
import com.hbm.inventory.gui.GUICoreStabilizer;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemLens;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityCore;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityCoreStabilizer
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
SimpleComponent,
IGUIProvider,
IInfoProviderEC,
CompatHandler.OCComponent {
    public long power;
    public static final long maxPower = 2500000000L;
    public int watts;
    public int beam;
    public static final int range = 15;

    public TileEntityCoreStabilizer() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.dfcStabilizer";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.watts = MathHelper.func_76125_a((int)this.watts, (int)1, (int)100);
            int demand = (int)Math.pow(this.watts, 4.0);
            this.beam = 0;
            if (this.power >= (long)demand && this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.ams_lens && ItemLens.getLensDamage(this.slots[0]) < ((ItemLens)ModItems.ams_lens).field_77699_b) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                for (int i = 1; i <= 15; ++i) {
                    int x = this.field_145851_c + dir.offsetX * i;
                    int y = this.field_145848_d + dir.offsetY * i;
                    int z = this.field_145849_e + dir.offsetZ * i;
                    TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
                    if (te instanceof TileEntityCore) {
                        TileEntityCore core = (TileEntityCore)te;
                        core.field = Math.max(core.field, this.watts);
                        this.power -= (long)demand;
                        this.beam = i;
                        long dmg = ItemLens.getLensDamage(this.slots[0]);
                        if ((dmg += (long)this.watts) >= ((ItemLens)ModItems.ams_lens).field_77699_b) {
                            this.slots[0] = null;
                            break;
                        }
                        ItemLens.setLensDamage(this.slots[0], dmg);
                        break;
                    }
                    if (!this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z)) break;
                }
            }
            this.networkPackNT(250);
        }
    }

    private void updateConnections() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.watts);
        buf.writeInt(this.beam);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.watts = buf.readInt();
        this.beam = buf.readInt();
    }

    public long getPowerScaled(long i) {
        return this.power * i / 2500000000L;
    }

    public int getWattsScaled(int i) {
        return this.watts * i / 100;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 2500000000L;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.watts = nbt.func_74762_e("watts");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("watts", this.watts);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "dfc_stabilizer";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInput(Context context, Arguments args) {
        return new Object[]{this.watts};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getDurability(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.ams_lens && ItemLens.getLensDamage(this.slots[0]) < ((ItemLens)ModItems.ams_lens).field_77699_b) {
            return new Object[]{ItemLens.getLensDamage(this.slots[0])};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        Object lens_damage_buf = this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.ams_lens && ItemLens.getLensDamage(this.slots[0]) < ((ItemLens)ModItems.ams_lens).field_77699_b ? Long.valueOf(ItemLens.getLensDamage(this.slots[0])) : "N/A";
        return new Object[]{this.power, 2500000000L, this.watts, lens_damage_buf};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setInput(Context context, Arguments args) {
        int newOutput = args.checkInteger(0);
        this.watts = MathHelper.func_76125_a((int)newOutput, (int)0, (int)100);
        return new Object[0];
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCoreStabilizer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICoreStabilizer(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        int demand = (int)Math.pow(this.watts, 4.0);
        long damage = ItemLens.getLensDamage(this.slots[0]);
        ItemLens lens = (ItemLens)ModItems.ams_lens;
        if (this.getPower() >= (long)demand && this.slots[0] != null && this.slots[0].func_77973_b() == lens && damage < 432000000L) {
            data.func_74780_a("consumptionHE", (double)demand);
        } else {
            data.func_74780_a("consumptionHE", 0.0);
        }
    }
}

