/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardSender;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineDiFurnace;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.container.ContainerDiFurnace;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIDiFurnace;
import com.hbm.inventory.recipes.BlastFurnaceRecipes;
import com.hbm.items.ModItems;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDiFurnace
extends TileEntityMachinePolluting
implements IFluidStandardSender,
IGUIProvider,
IInfoProviderEC {
    public int progress;
    public int fuel;
    public static final int maxFuel = 12800;
    public static final int processingSpeed = 400;
    private static final int[] slots_io = new int[]{0, 1, 2, 3};
    public byte sideFuel = 1;
    public byte sideUpper = 1;
    public byte sideLower = 1;

    public TileEntityDiFurnace() {
        super(4, 50);
    }

    @Override
    public String getName() {
        return "container.diFurnace";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return i != 3;
    }

    public boolean hasItemPower(ItemStack stack) {
        return TileEntityDiFurnace.getItemPower(stack) > 0;
    }

    private static int getItemPower(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151044_h) {
            return 200;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
            return 2000;
        }
        if (item == Item.func_150898_a((Block)ModBlocks.block_coke)) {
            return 4000;
        }
        if (item == Items.field_151129_at) {
            return 12800;
        }
        if (item == Items.field_151072_bj) {
            return 1000;
        }
        if (item == Items.field_151065_br) {
            return 300;
        }
        if (item == ModItems.lignite) {
            return 150;
        }
        if (item == ModItems.powder_lignite) {
            return 150;
        }
        if (item == ModItems.powder_coal) {
            return 200;
        }
        if (item == ModItems.briquette) {
            return 200;
        }
        if (item == ModItems.coke) {
            return 400;
        }
        if (item == ModItems.solid_fuel) {
            return 400;
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuel = nbt.func_74762_e("powerTime");
        this.progress = nbt.func_74765_d("cookTime");
        byte[] modes = nbt.func_74770_j("modes");
        this.sideFuel = modes[0];
        this.sideUpper = modes[1];
        this.sideLower = modes[2];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("powerTime", this.fuel);
        nbt.func_74777_a("cookTime", (short)this.progress);
        nbt.func_74773_a("modes", new byte[]{this.sideFuel, this.sideUpper, this.sideLower});
    }

    @Override
    public int[] func_94128_d(int side) {
        return slots_io;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        if (i == 0 && this.sideUpper != j) {
            return false;
        }
        if (i == 1 && this.sideLower != j) {
            return false;
        }
        if (i == 2 && this.sideFuel != j) {
            return false;
        }
        if (i == 3) {
            return false;
        }
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 3;
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.progress * i / 400;
    }

    public int getPowerRemainingScaled(int i) {
        return this.fuel * i / 12800;
    }

    public boolean canProcess() {
        if (this.slots[0] == null || this.slots[1] == null) {
            return false;
        }
        if (!this.hasPower()) {
            return false;
        }
        ItemStack output = BlastFurnaceRecipes.getOutput(this.slots[0], this.slots[1]);
        if (output == null) {
            return false;
        }
        if (this.slots[3] == null) {
            return true;
        }
        if (!this.slots[3].func_77969_a(output)) {
            return false;
        }
        return this.slots[3].field_77994_a + output.field_77994_a <= this.slots[3].func_77976_d();
    }

    private void processItem() {
        ItemStack itemStack = BlastFurnaceRecipes.getOutput(this.slots[0], this.slots[1]);
        if (this.slots[3] == null) {
            this.slots[3] = itemStack.func_77946_l();
        } else if (this.slots[3].func_77969_a(itemStack)) {
            this.slots[3].field_77994_a += itemStack.field_77994_a;
        }
        for (int i = 0; i < 2; ++i) {
            this.func_70298_a(i, 1);
        }
    }

    public boolean hasPower() {
        return this.fuel > 0;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean extension = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == ModBlocks.machine_difurnace_extension;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.sendSmoke(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            if (extension) {
                this.sendSmoke(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, ForgeDirection.UP);
            }
            boolean markDirty = false;
            if (this.hasItemPower(this.slots[2]) && this.fuel <= 12800 - TileEntityDiFurnace.getItemPower(this.slots[2])) {
                this.fuel += TileEntityDiFurnace.getItemPower(this.slots[2]);
                if (this.slots[2] != null) {
                    markDirty = true;
                    --this.slots[2].field_77994_a;
                    if (this.slots[2].field_77994_a == 0) {
                        this.slots[2] = this.slots[2].func_77973_b().getContainerItem(this.slots[2]);
                    }
                }
            }
            if (this.canProcess()) {
                --this.fuel;
                this.progress += extension ? 3 : 1;
                if (this.progress >= 400) {
                    this.progress = 0;
                    this.processItem();
                    markDirty = true;
                }
                if (this.fuel < 0) {
                    this.fuel = 0;
                }
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.pollute(PollutionHandler.PollutionType.SOOT, 0.04f * (float)(extension ? 3 : 1));
                }
            } else {
                this.progress = 0;
            }
            boolean trigger = true;
            if (this.canProcess() && this.progress == 0) {
                trigger = false;
            }
            if (trigger) {
                markDirty = true;
                MachineDiFurnace.updateBlockState(this.progress > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.networkPackNT(15);
            if (markDirty) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeShort(this.progress);
        buf.writeShort(this.fuel);
        buf.writeBytes(new byte[]{this.sideFuel, this.sideUpper, this.sideLower});
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.progress = buf.readShort();
        this.fuel = buf.readShort();
        byte[] modes = new byte[3];
        buf.readBytes(modes);
        this.sideFuel = modes[0];
        this.sideUpper = modes[1];
        this.sideLower = modes[2];
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerDiFurnace(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIDiFurnace(player.field_71071_by, this);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[0];
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.getSmokeTanks();
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74772_a("energy_", (long)this.fuel);
        data.func_74772_a("capacity_", 12800L);
        data.func_74768_a("progress", this.progress);
    }
}

